/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class ReceiptDownScheduleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReceiptDownScheduleService.class);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("issetbankinterface");
        lst.add("bankaccountnumber");
        lst.add("company");
        lst.add("bank");
        lst.add("currency.fbasedataid.*");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        ErrorCode errorCode = new BeErrorCode().COMMON();
        String Receipt_Lock = new BeiBizResource().getReceipt_Lock();
        String day = (String)this.operationVariable.get("day");
        String startdate = (String)this.operationVariable.get("startdate");
        String enddate = (String)this.operationVariable.get("enddate");
        for (DynamicObject accountBank : dataEntities) {
            if (accountBank == null) continue;
            String bankNumber = accountBank.getString("bankaccountnumber");
            String bankAcctId = accountBank.getString("id");
            boolean isSuccess = MutexServiceHelper.request((String)bankAcctId, (String)"bd_accountbanks", (String)"op_receipt");
            if (isSuccess) {
                try {
                    DynamicObjectCollection currencyColl = accountBank.getDynamicObjectCollection("currency");
                    Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-2);
                    if (StringUtils.isNotEmpty((CharSequence)day)) {
                        beginDate = DateUtils.getNextDay((Date)new Date(), (int)(-Integer.parseInt(day)));
                    }
                    Date endDate = DateUtils.getNextDay((Date)new Date(), (int)-1);
                    if (this.operationVariable.containsKey("includetoday") && "1".equals(this.operationVariable.get("includetoday"))) {
                        beginDate = DateUtils.getNextDay((Date)new Date(), (int)(-Integer.parseInt(day) + 1));
                        endDate = new Date();
                        logger.info("\u60c5\u51b5\u4e3a \u7ed3\u675f\u65e5\u671f\u9700\u8981\u5305\u62ec\u4eca\u5929 \u7684\u667a\u80fd\u6267\u884c\u65b9\u6848\u65f6\uff0c\u5f00\u59cb\u65e5\u671f\uff1a{}", (Object)beginDate);
                        logger.info("\u60c5\u51b5\u4e3a \u7ed3\u675f\u65e5\u671f\u9700\u8981\u5305\u62ec\u4eca\u5929 \u7684\u667a\u80fd\u6267\u884c\u65b9\u6848\u65f6\uff0c\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)endDate);
                    } else if (!this.operationVariable.containsKey("includetoday") && this.operationVariable.containsKey("scheduling_plan_flag")) {
                        endDate = new Date();
                        logger.info("\u60c5\u51b5\u4e3a\u6267\u884c\u8c03\u5ea6\u8ba1\u5212\u65f6\uff0c\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)endDate);
                    }
                    if (EmptyUtil.isNoEmpty((String)startdate) && EmptyUtil.isNoEmpty((String)enddate)) {
                        beginDate = DateUtils.stringToDate((String)startdate, (String)"yyyy-MM-dd");
                        endDate = DateUtils.stringToDate((String)enddate, (String)"yyyy-MM-dd");
                    }
                    for (DynamicObject currency : currencyColl) {
                        try {
                            currency = currency.getDynamicObject("fbasedataid");
                            if (currency == null) {
                                logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u5e01\u79cd\u4e3anull,bankNumber:{},bankAcctId{}", (Object)bankNumber, (Object)bankAcctId);
                                continue;
                            }
                            OperateErrorInfo operateErrorInfo = AccountBankHelper.downReceipt(accountBank, currency, beginDate, endDate);
                            if (null == operateErrorInfo) continue;
                            errorInfos.add(operateErrorInfo);
                        }
                        catch (Exception e) {
                            String eStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                            logger.error("\u5faa\u73af\u5e01\u79cd\u53d6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + eStr);
                            StringBuilder errors = new StringBuilder();
                            String currNumber = "null";
                            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                                currNumber = currency.getString("number");
                            }
                            errors.append('\n').append(ResManager.loadKDString((String)"\u8d26\u53f7", (String)"ReceiptDownScheduleService_0", (String)"tmc-bei-business", (Object[])new Object[0])).append(bankNumber).append(ResManager.loadKDString((String)" \u5e01\u79cd", (String)"ReceiptDownScheduleService_1", (String)"tmc-bei-business", (Object[])new Object[0])).append(currNumber).append(' ').append(eStr).append(' ');
                            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                            operateErrorInfo.setLevel(ErrorLevel.Error);
                            operateErrorInfo.setMessage(errors.toString());
                            operateErrorInfo.setPkValue((Object)Long.valueOf(bankAcctId));
                            errorInfos.add(operateErrorInfo);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    String exStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.error("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u5f02\u5e38\uff1a" + exStr);
                    this.operationResult.setMessage(exStr);
                    this.operationResult.setSuccess(false);
                    throw new BEBizException(errorCode, (Object[])new String[]{e.getMessage()});
                }
                finally {
                    MutexServiceHelper.release((String)bankAcctId, (String)"bd_accountbanks", (String)"op_receipt");
                }
            }
            String message = String.format(Receipt_Lock, bankNumber);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(message);
            operateErrorInfo.setPkValue((Object)Long.valueOf(bankAcctId));
            errorInfos.add(operateErrorInfo);
        }
        if (errorInfos.size() > 0) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        } else {
            this.operationResult.setSuccess(true);
        }
        logger.info("\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)this.operationResult));
    }
}

