/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.online;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.EBBalanceQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;

public class BatchBalanceOnlineQueryService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List<OperateErrorInfo> operateErrorInfos = this.getProcessOperateInfo(dynamicObjects);
        if (!CollectionUtils.isEmpty(operateErrorInfos)) {
            List errMsgList = operateErrorInfos.stream().map(OperateInfo::getMessage).collect(Collectors.toList());
            throw new KDBizException(String.join((CharSequence)";", errMsgList));
        }
    }

    public List<OperateErrorInfo> getProcessOperateInfo(DynamicObject[] dynamicObjects) {
        DynamicObject accountBank = dynamicObjects[0].getDynamicObject("accountbank");
        DynamicObject currency = dynamicObjects[0].getDynamicObject("currency");
        List<Long> idList = Collections.singletonList(accountBank.getLong("id"));
        BalanceQueryParam balanceQueryParam = new BalanceQueryParam(currency, DateUtils.getCurrentDate(), DateUtils.getCurrentDate(), idList);
        List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
        return ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
    }
}

