/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.online;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class TransDetailOnlineQueryService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("rulename");
        sic.add("receredway");
        sic.add("ishandlink");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List<OperateErrorInfo> operateErrorInfos = this.getProcessOperateInfo(dynamicObjects);
        if (!CollectionUtils.isEmpty(operateErrorInfos)) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(operateErrorInfos);
            StringBuilder s = new StringBuilder();
            for (IOperateInfo iOperateInfo : this.operationResult.getAllErrorOrValidateInfo()) {
                s.append('\n').append(iOperateInfo.getMessage());
            }
            this.operationResult.setShowMessage(false);
            throw new BEBizException(new BeErrorCode().ONLINEQUERY_ERROR(), (Object[])new String[]{s.toString()});
        }
        this.operationResult.setSuccess(true);
    }

    public List<OperateErrorInfo> getProcessOperateInfo(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> accountbanks = new ArrayList<DynamicObject>(dynamicObjects.length);
        DynamicObject currency = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject accountBank = dynamicObject.getDynamicObject("accountbank");
            currency = dynamicObject.getDynamicObject("currency");
            accountbanks.add(accountBank);
        }
        List<Long> idList = accountbanks.stream().map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
        DetailQueryParam detailQueryParam = new DetailQueryParam(currency, DateUtils.getCurrentDate(), DateUtils.getCurrentDate(), idList, false);
        List<TransDetailResult> results = new EBDetailQueryService(detailQueryParam).downTransDetails();
        return ErrorInfoHelper.convertErrorInfos(results);
    }
}

