/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service.async;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;

public class TransDetailAsyncService {
    private static final Log logger = LogFactory.getLog(TransDetailAsyncService.class);

    public String asyncExecute(List<String> params) {
        RpcResult result = new RpcResult();
        Long accountId = (Long)JSON.parseObject((String)params.get(0), Long.class);
        DynamicObject accoutbank = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountbanks");
        Long currId = (Long)JSON.parseObject((String)params.get(1), Long.class);
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)currId, (String)"bd_currency");
        Date startdate = (Date)JSON.parseObject((String)params.get(2), Date.class);
        Date enddate = (Date)JSON.parseObject((String)params.get(3), Date.class);
        OperationResult operationResult = new OperationResult();
        List<Long> idList = Collections.singletonList((Long)accoutbank.getPkValue());
        DetailQueryParam detailQueryParam = new DetailQueryParam(currency, startdate, enddate, idList, true);
        List<TransDetailResult> results = new EBDetailQueryService(detailQueryParam).downTransDetails();
        List<OperateErrorInfo> operateErrorInfos = ErrorInfoHelper.convertErrorInfos(results);
        if (!CollectionUtils.isEmpty(operateErrorInfos)) {
            operationResult.setSuccess(false);
            operationResult.setAllErrorInfo(operateErrorInfos);
            operationResult.setShowMessage(false);
        } else {
            operationResult.setSuccess(true);
        }
        boolean success = operationResult.isSuccess();
        result.setMessage(operationResult.getMessage());
        if (!success) {
            StringBuilder sb = new StringBuilder();
            List allErrorInfo = operationResult.getAllErrorInfo();
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                sb.append(operateErrorInfo.getMessage());
                sb.append(' ');
                result.setMessage(sb.toString());
            }
            result.setStatusCode(RpcResultStatusCode.ERROR);
        }
        return JSON.toJSONString((Object)result);
    }
}

