/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service.factory.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.tcc.TCCSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.service.factory.IAutoMatchService;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AutoMatchServiceImpl
implements IAutoMatchService {
    private static final Log LOGGER = LogFactory.getLog(AutoMatchServiceImpl.class);
    private static final String MATCH_BILL_BRANCH_SCENES_CODE = "matchbill";
    private static final String MATCH_BILL_SERVICE_NAME = "AutoMatchBillTCCService";

    public static AutoMatchServiceImpl getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void execute(List<AutoMatchInfoParam> tAutoMatchInfoList, String receivedWay, Map<Object, String> tRuleNameMap, boolean doExecute, Set<Object> autoRecPayBizBillIdSet) {
        this.process(tAutoMatchInfoList, receivedWay, tRuleNameMap, doExecute, autoRecPayBizBillIdSet, true);
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoList, boolean isDeleteWork) {
        this.process(tAutoMatchInfoList, null, null, false, null, isDeleteWork);
    }

    private void process(List<AutoMatchInfoParam> tAutoMatchInfoList, String receivedWay, Map<Object, String> tRuleNameMap, boolean doExecute, Set<Object> autoRecPayBizBillIdSet, boolean isDeleteWork) {
        List lockBusinessIds;
        LOGGER.info("AutoMatchService,tAutoMatchInfoList:{},receivedWay:{},tRuleNameMap:{},doExecute:{},autoRecPayBizBillIdSet:{}", new Object[]{tAutoMatchInfoList, receivedWay, tRuleNameMap, doExecute, autoRecPayBizBillIdSet});
        CommonParam tmcParam = null;
        CommonParam fiParam = null;
        List transDetailIds = tAutoMatchInfoList.stream().map(t -> String.valueOf(t.getTransDetailId())).distinct().collect(Collectors.toList());
        List businessIds = tAutoMatchInfoList.stream().map(t -> EmptyUtil.isEmpty((Long)t.getRecedBillEntryId()) ? String.valueOf(t.getRecedBillId()) : String.valueOf(t.getRecedBillEntryId())).distinct().collect(Collectors.toList());
        if (transDetailIds.isEmpty() || businessIds.isEmpty()) {
            return;
        }
        List lockTransDetailIds = TxCheckUtil.getLocked(transDetailIds);
        if (!lockTransDetailIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u4e1a\u52a1\u5355\u636e\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchService_0", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        }
        if (!(businessIds = businessIds.stream().filter(v -> !"0".equals(v)).collect(Collectors.toList())).isEmpty() && !(lockBusinessIds = TxCheckUtil.getLocked(businessIds)).isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4e1a\u52a1\u5355\u636e\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchServiceImpl_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        List<AutoMatchInfoParam> tmcList = tAutoMatchInfoList.stream().filter(o -> AutoMatchServiceHelper.mTmcDb.contains(o.getRecedBillType())).collect(Collectors.toList());
        List<AutoMatchInfoParam> fiList = tAutoMatchInfoList.stream().filter(o -> !AutoMatchServiceHelper.mTmcDb.contains(o.getRecedBillType())).collect(Collectors.toList());
        String version = String.valueOf(DB.genGlobalLongId());
        CommonParam param = this.createCommonParam(tAutoMatchInfoList);
        this.setCommonParams(param, receivedWay, tRuleNameMap, doExecute, autoRecPayBizBillIdSet, version, isDeleteWork);
        if (!tmcList.isEmpty()) {
            tmcParam = this.createCommonParam(tmcList);
            this.setCommonParams(tmcParam, receivedWay, tRuleNameMap, doExecute, autoRecPayBizBillIdSet, version, isDeleteWork);
        }
        if (!fiList.isEmpty()) {
            fiParam = this.createCommonParam(fiList);
            this.setCommonParams(fiParam, receivedWay, tRuleNameMap, doExecute, autoRecPayBizBillIdSet, version, isDeleteWork);
        }
        TCCSession session = DtxFactory.createTCC((String)"bei_automatch");
        try {
            businessIds.addAll(transDetailIds);
            session.lock(businessIds);
            if (doExecute) {
                session.Try("tmc", "bei", "AutoMatchDetailTCCService", (Param)param, "matchdetail");
                if (tmcParam != null) {
                    session.Try("tmc", "bei", MATCH_BILL_SERVICE_NAME, (Param)tmcParam, MATCH_BILL_BRANCH_SCENES_CODE);
                }
                if (fiParam != null) {
                    session.Try("tmc", "bei", MATCH_BILL_SERVICE_NAME, (Param)fiParam, MATCH_BILL_BRANCH_SCENES_CODE);
                }
                session.Try("tmc", "bei", "AutoMatchBankJournalTCCService", (Param)param, "matchbankjournal");
            } else {
                if (tmcParam != null) {
                    session.Try("tmc", "bei", MATCH_BILL_SERVICE_NAME, (Param)tmcParam, MATCH_BILL_BRANCH_SCENES_CODE);
                }
                if (fiParam != null) {
                    session.Try("tmc", "bei", MATCH_BILL_SERVICE_NAME, (Param)fiParam, MATCH_BILL_BRANCH_SCENES_CODE);
                }
                session.Try("tmc", "bei", "AutoMatchBankJournalTCCService", (Param)param, "matchbankjournal");
                session.Try("tmc", "bei", "AutoMatchDetailTCCService", (Param)param, "matchdetail");
            }
        }
        catch (Exception e) {
            LOGGER.error("AutoMatchService tcc error", (Throwable)e);
            session.rollback();
            throw new KDBizException(e.getMessage());
        }
        session.commit();
    }

    private CommonParam createCommonParam(List<AutoMatchInfoParam> tAutoMatchInfoList) {
        CommonParam param = new CommonParam();
        param.put((Object)"AutoMatchInfoList", (Object)SerializationUtils.toJsonString(tAutoMatchInfoList));
        return param;
    }

    private void setCommonParams(CommonParam param, String receivedWay, Map<Object, String> tRuleNameMap, boolean doExecute, Set<Object> autoRecPayBizBillIdSet, String version, boolean isDeleteWork) {
        param.put((Object)"receredway", (Object)receivedWay);
        if (tRuleNameMap == null) {
            tRuleNameMap = new HashMap<Object, String>(2);
        }
        param.put((Object)"rulename", tRuleNameMap);
        param.put((Object)"DoExecute", (Object)doExecute);
        if (autoRecPayBizBillIdSet == null) {
            autoRecPayBizBillIdSet = new HashSet<Object>();
        }
        param.put((Object)"autoRecPayBizBillId", autoRecPayBizBillIdSet);
        param.put((Object)"version", (Object)version);
        param.put((Object)"isDeleteWork", (Object)isDeleteWork);
    }

    private static final class Singleton {
        private static final AutoMatchServiceImpl INSTANCE = new AutoMatchServiceImpl();

        private Singleton() {
        }
    }
}

