/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service.factory.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.service.factory.IBankServiceFacade;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;
import kd.tmc.fbp.service.ebservice.exception.EBBizException;
import kd.tmc.fbp.service.ebservice.service.TestConnectService;

public class BankServiceFacadeImpl
implements IBankServiceFacade {
    private static final Log logger = LogFactory.getLog(BankServiceFacadeImpl.class);

    @Override
    public BigDecimal getCurBalance(Long bankAcctId, Long currencyId) {
        BigDecimal balance = null;
        QFilter[] filter = new QFilter[]{new QFilter("accountbank.id", "=", (Object)bankAcctId), new QFilter("currency.id", "=", (Object)currencyId)};
        DynamicObjectCollection bankBalance = QueryServiceHelper.query((String)"bei_bankbalance", (String)"id, amount", (QFilter[])filter, (String)"bizdate desc", (int)1);
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)bankBalance)) {
            balance = ((DynamicObject)bankBalance.get(0)).getBigDecimal("amount");
        }
        return balance;
    }

    @Override
    public BigDecimal getValidBalance(Long bankAcctId, Long currencyId) {
        BigDecimal balance = null;
        QFilter[] filter = new QFilter[]{new QFilter("accountbank.id", "=", (Object)bankAcctId), new QFilter("currency.id", "=", (Object)currencyId)};
        DynamicObjectCollection bankBalance = QueryServiceHelper.query((String)"bei_bankbalance", (String)"id, valibalance ", (QFilter[])filter, (String)"bizdate desc", (int)1);
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)bankBalance)) {
            balance = ((DynamicObject)bankBalance.get(0)).getBigDecimal("valibalance");
        }
        return balance;
    }

    @Override
    public Map<String, Object> testConnect() {
        try {
            return TestConnectService.testConnect();
        }
        catch (Exception e) {
            String code;
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            if (e instanceof BEBizException && "tmc.bei.TENANTID_ERROR".equals(code = ((BEBizException)e).getErrorCode().getCode())) {
                throw new EBBizException(((BEBizException)e).getErrorCode());
            }
            throw new EBBizException(new BeErrorCode().CONNECT_ERR(), (Object[])new String[]{"\u201c" + e.getMessage()});
        }
    }

    private DataSet dsGroupBy(DataSet ds) {
        ds = ds.groupBy(new String[]{"orgid", "accoutid", "cuid"}).max("bizdate").finish();
        return ds;
    }

    @Override
    public Map<String, BigDecimal> getBalanceBatch(List<Long> orgIdList, List<Long> bankAcctId, Date queryDate) {
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        Date queryDateEnd = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        QFilter qFilter = new QFilter("accountbank.id", "in", bankAcctId);
        if (EmptyUtil.isNoEmpty(orgIdList)) {
            qFilter.and(new QFilter("company.id", "in", orgIdList));
        }
        qFilter.and(new QFilter("bizdate", "<=", (Object)queryDateEnd));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(BankServiceFacadeImpl.class.getName() + ".getCurBalance"), (String)"bei_bankbalance", (String)"company as orgid,accountbank as accoutid,currency as cuid,amount as factamt,bizdate", (QFilter[])qFilter.toArray(), null);){
            DataSet balanceRawDataSetTemp = this.dsGroupBy(balanceRawDataSet);
            DataSet ds = balanceRawDataSet.join(balanceRawDataSetTemp).on("orgid", "orgid").on("accoutid", "accoutid").on("cuid", "cuid").on("bizdate", "bizdate").select(new String[]{"orgid", "accoutid", "cuid", "factamt"}).finish();
            try (DataSet finalJournalDataSet = ds.groupBy(new String[]{"orgid", "accoutid", "cuid", "factamt"}).finish().distinct();){
                for (Row next : finalJournalDataSet) {
                    String key = next.getString("orgid") + '-' + next.getString("accoutid") + '-' + next.getString("cuid");
                    BigDecimal balance = next.getBigDecimal("factamt");
                    BigDecimal bigDecimal = (BigDecimal)balanceMap.get(key);
                    if (bigDecimal != null) {
                        balance = bigDecimal.add(balance);
                    }
                    balanceMap.put(key, balance);
                }
            }
        }
        return balanceMap;
    }

    @Override
    public Map<String, BigDecimal> getBalanceBatch(List<Long> bankAcctId, Date queryDate) {
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        Date queryDateEnd = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        QFilter qFilter = new QFilter("accountbank.id", "in", bankAcctId);
        qFilter.and(new QFilter("bizdate", "<=", (Object)queryDateEnd));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(BankServiceFacadeImpl.class.getName() + ".getCurBalance"), (String)"bei_bankbalance", (String)"accountbank as accoutid,currency as cuid,amount as factamt,bizdate", (QFilter[])qFilter.toArray(), null);){
            DataSet balanceRawDataSetTemp = balanceRawDataSet.groupBy(new String[]{"accoutid", "cuid"}).max("bizdate").finish();
            DataSet ds = balanceRawDataSet.join(balanceRawDataSetTemp).on("accoutid", "accoutid").on("cuid", "cuid").on("bizdate", "bizdate").select(new String[]{"accoutid", "cuid", "factamt"}).finish();
            try (DataSet finalJournalDataSet = ds.groupBy(new String[]{"accoutid", "cuid", "factamt"}).finish().distinct();){
                for (Row row : finalJournalDataSet) {
                    String key = row.getString("accoutid") + '-' + row.getString("cuid");
                    BigDecimal balance = row.getBigDecimal("factamt");
                    BigDecimal bigDecimal = (BigDecimal)balanceMap.get(key);
                    if (bigDecimal != null) {
                        balance = bigDecimal.add(balance);
                    }
                    balanceMap.put(key, balance);
                }
            }
        }
        return balanceMap;
    }
}

