/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service.factory.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.WorkBenchHelper;
import kd.tmc.bei.business.service.factory.IWorkBenchService;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WorkBenchServiceImpl
implements IWorkBenchService {
    private static final Log LOGGER = LogFactory.getLog(WorkBenchServiceImpl.class);

    public static WorkBenchServiceImpl getInstance() {
        return Singleton.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean execute(Object[] selectedPks, String entity, OperationResult result, OperateOption option, String target, String way) {
        boolean errorFlag = false;
        ArrayList<String> businessIds = new ArrayList<String>(selectedPks.length);
        if (selectedPks == null || selectedPks.length == 0) {
            return false;
        }
        for (Object selectedPk : selectedPks) {
            businessIds.add(String.valueOf(selectedPk));
        }
        List lockBusinessIds = TxCheckUtil.getLocked(businessIds);
        if (businessIds.size() == lockBusinessIds.size()) {
            LOGGER.info("\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d-pkIds:{}", (Object)lockBusinessIds.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        Map request = MutexServiceHelper.batchRequest(businessIds, (String)entity, (String)"batchWork_bench");
        ArrayList errors = new ArrayList();
        List requestIds = MutexServiceHelper.getRequestResultList(businessIds, errors, (Map)request);
        ArrayList<Object> list = new ArrayList<Object>(8);
        try {
            void var16_22;
            Object[] objectArray = selectedPks;
            int n = objectArray.length;
            boolean bl = false;
            while (var16_22 < n) {
                Object selectedPk = objectArray[var16_22];
                if (!lockBusinessIds.contains(selectedPk.toString()) && requestIds.contains(selectedPk.toString())) {
                    list.add(selectedPk);
                } else {
                    LOGGER.info("\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d-pkIds:{}", (Object)selectedPk.toString());
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue((Object)selectedPk.toString());
                    operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                    result.addErrorInfo(operateErrorInfo);
                }
                ++var16_22;
            }
            if (list.size() > 0) {
                LOGGER.info("[WorkBenchServiceImpl]\u5165\u8d26id\u5217\u8868\uff1a{}", list);
                Map<String, DynamicObject[]> businessBills = WorkBenchHelper.getTargetBillByWay(list.toArray(), entity, way, target, false, result);
                ArrayList<Long> successIdList = new ArrayList<Long>(10);
                for (Map.Entry<String, DynamicObject[]> entry : businessBills.entrySet()) {
                    if (EmptyUtil.isEmpty((Object[])entry.getValue())) continue;
                    Map idAndObjectMap = Arrays.stream((Object[])entry.getValue()).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
                    OperationResult operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"save", (String)entry.getKey(), (DynamicObject[])entry.getValue(), (OperateOption)option);
                    LOGGER.info("WorkBenchServiceImpl execute save operationResult: {}", (Object)operationResult.toString());
                    List successPkIds = operationResult.getSuccessPkIds();
                    if (EmptyUtil.isNoEmpty((Object)successPkIds)) {
                        for (Object pkId : successPkIds) {
                            long sourceBillId;
                            DynamicObject dynamicObject = (DynamicObject)idAndObjectMap.get(pkId);
                            if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !EmptyUtil.isNoEmpty((Long)(sourceBillId = dynamicObject.getLong("sourcebillid")))) continue;
                            successIdList.add(sourceBillId);
                        }
                    }
                    if (operationResult.isSuccess()) continue;
                    List allErrorOrValidateInfoList = operationResult.getAllErrorOrValidateInfo();
                    int successCnt = EmptyUtil.isNoEmpty((Object)operationResult.getSuccessPkIds()) ? operationResult.getSuccessPkIds().size() : 0;
                    int size = allErrorOrValidateInfoList.size() + successCnt;
                    if (size == 0) {
                        throw new KDBizException(operationResult.getMessage());
                    }
                    for (IOperateInfo errorInfo : allErrorOrValidateInfoList) {
                        long sourceBillId;
                        Object pkValue = errorInfo.getPkValue();
                        DynamicObject dynamicObject = (DynamicObject)idAndObjectMap.get(pkValue);
                        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !EmptyUtil.isNoEmpty((Long)(sourceBillId = dynamicObject.getLong("sourcebillid")))) continue;
                        OperateErrorInfo info = new OperateErrorInfo();
                        info.setLevel(ErrorLevel.Error);
                        info.setPkValue((Object)sourceBillId);
                        info.setMessage(errorInfo.getMessage());
                        result.addErrorInfo(info);
                    }
                }
                result.setSuccessPkIds(successIdList);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            for (Object e : list) {
                result.addErrorInfo(this.getOperateErrorInfo(e, ex.getMessage()));
            }
        }
        finally {
            if (requestIds.size() > 0) {
                MutexServiceHelper.batchRelease((List)requestIds, (String)entity, (String)"batchWork_bench");
            }
        }
        if (!result.isSuccess()) {
            errorFlag = true;
        }
        return errorFlag;
    }

    private OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    static final class Singleton {
        private static WorkBenchServiceImpl instance = new WorkBenchServiceImpl();

        Singleton() {
        }
    }
}

