/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public abstract class AbstractAccountBatchTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AbstractAccountBatchTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObjectCollection data;
        DynamicObjectCollection accountbanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{this.getAccountQfilter(map)});
        if (accountbanks.size() == 0) {
            return;
        }
        Set accountPks = accountbanks.stream().map(t -> t.get("id")).collect(Collectors.toSet());
        ArrayList<QFilter> entityFilters = new ArrayList<QFilter>(4);
        entityFilters.add(new QFilter(this.getAccountKey(), "in", accountPks));
        QFilter enFilter = this.getEntityQfilter(map);
        if (Objects.nonNull(enFilter)) {
            entityFilters.add(enFilter);
        }
        if ((data = QueryServiceHelper.query((String)this.getEntityNumber(), (String)"id", (QFilter[])entityFilters.toArray(new QFilter[0]))).size() == 0) {
            return;
        }
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65701" + data.size());
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65702" + this.getOperationKey());
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65703" + this.getEntityNumber());
        ArrayList errors = new ArrayList();
        ArrayList dataList = new ArrayList(data);
        List dataParts = Lists.partition(dataList, (int)this.getProcessBatch());
        for (List dataPartList : dataParts) {
            DynamicObject[] dataPart = dataPartList.toArray(new DynamicObject[0]);
            List idList = Arrays.stream(dataPart).map(e -> e.get("id")).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
            List requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])dataPart, errors, (Map)request);
            try {
                OperationResult result;
                if (requestIds.size() > 0) {
                    Object[] longIds = requestIds.stream().map(Long::valueOf).toArray();
                    result = TmcOperateServiceHelper.execOperateWithoutThrow((String)this.getOperationKey(), (String)this.getEntityNumber(), (Object[])longIds, (OperateOption)OperateOption.create());
                } else {
                    result = new OperationResult();
                }
                for (OperateErrorInfo error : errors) {
                    result.addErrorInfo(error);
                }
                this.buildLog(result);
            }
            finally {
                if (requestIds.size() <= 0) continue;
                MutexServiceHelper.batchRelease((List)requestIds, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
            }
        }
    }

    private void buildLog(OperationResult result) {
        logger.info("\u64cd\u4f5c\u540d\u79f0" + this.getOperationKey());
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
    }

    protected QFilter getAccountQfilter(Map<String, Object> param) {
        QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
        return filter;
    }

    protected QFilter getEntityQfilter(Map<String, Object> param) {
        return null;
    }

    protected abstract String getEntityNumber();

    protected abstract String getOperationKey();

    public String getAccountKey() {
        return "accountbank";
    }

    protected int getProcessBatch() {
        return 200;
    }
}

