/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task;

import java.util.Map;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.business.task.AbstractAccountBatchTask;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class MissingRecordRepairTask
extends AbstractAccountBatchTask {
    private static final Log logger = LogFactory.getLog(MissingRecordRepairTask.class);
    private static final int MAX_TRY_NUM = 10;

    @Override
    protected QFilter getAccountQfilter(Map<String, Object> param) {
        QFilter filter = super.getAccountQfilter(param);
        filter.and("issetbankinterface", "=", (Object)"1");
        Object bankaccountnumber = param.get("bankaccountnumber");
        logger.info("\u53c2\u6570 bankaccountnumber" + bankaccountnumber);
        if (EmptyUtil.isNoEmpty((Object)bankaccountnumber)) {
            String[] number = bankaccountnumber.toString().split(",");
            filter.and(new QFilter("bankaccountnumber", "in", (Object)number));
        }
        return filter;
    }

    @Override
    protected QFilter getEntityQfilter(Map<String, Object> param) {
        if (Objects.isNull(param)) {
            return null;
        }
        String num = Objects.nonNull(param.get("try_num")) ? param.get("try_num").toString() : "";
        int tryNum = StringUtils.isNotEmpty((CharSequence)num) ? Integer.parseInt(num) : 3;
        tryNum = Math.min(tryNum, 10);
        logger.info("repair task try number {}", (Object)tryNum);
        return new QFilter("trynum", "<", (Object)tryNum);
    }

    @Override
    protected String getEntityNumber() {
        return "bei_missingreord";
    }

    @Override
    protected String getOperationKey() {
        return "missingrepair";
    }
}

