/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.helper.QueryRequestRecordHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.common.enums.ExecuteWayEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.bei.common.enums.QueryTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QueryBalanceTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(QueryBalanceTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("\u5f53\u524d\u4efb\u52a1id" + this.taskId);
        QueryRequestRecordHelper.saveQueryTaskInfo(Long.parseLong(this.taskId), QueryTypeEnum.BALANCE.getValue(), ExecuteWayEnum.HAND.getValue());
        List accountid = (List)params.get("accountid");
        Date beginDate = DateUtils.stringToDate((String)((String)params.get("startdate")), (String)"yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate((String)((String)params.get("enddate")), (String)"yyyy-MM-dd");
        context = (RequestContext)JSONObject.parseObject((String)((String)params.get("RequestContext")), RequestContext.class);
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((Object[])accountid.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        int size = accountBanks.size();
        HashMap<Long, DynamicObject> accountBankMap = new HashMap<Long, DynamicObject>(size);
        HashMap<Long, String> bankId_Number = new HashMap<Long, String>(size);
        HashMap<Map<String, Object>, Set<Long>> bankInterface_AcctIds = new HashMap<Map<String, Object>, Set<Long>>(16);
        for (Map.Entry entry : accountBanks.entrySet()) {
            DynamicObject accountBank = (DynamicObject)entry.getValue();
            Long accountBankId = accountBank.getLong("id");
            String accountBankNumber = accountBank.getString("bankaccountnumber");
            String bankinterface = accountBank.getString("bankinterface");
            accountBankMap.put(accountBankId, accountBank);
            bankId_Number.put(accountBankId, accountBankNumber);
            DynamicObjectCollection currencys = new DynamicObjectCollection();
            for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                currencys.add((Object)currency.getDynamicObject("fbasedataid"));
            }
            for (DynamicObject currency : currencys) {
                HashMap<String, Object> mapForCurrAndBankInterFace = new HashMap<String, Object>();
                mapForCurrAndBankInterFace.put("currency", currency);
                mapForCurrAndBankInterFace.put("bankinterface", bankinterface);
                if (CollectionUtils.isEmpty((Collection)((Collection)bankInterface_AcctIds.get(mapForCurrAndBankInterFace)))) {
                    HashSet<Long> bankAccIds = new HashSet<Long>();
                    bankAccIds.add(accountBankId);
                    bankInterface_AcctIds.put(mapForCurrAndBankInterFace, bankAccIds);
                    continue;
                }
                Set bankIdSet = (Set)bankInterface_AcctIds.get(mapForCurrAndBankInterFace);
                bankIdSet.add(accountBankId);
            }
        }
        int batchDownAcctCount = 1;
        DynamicObjectCollection servConfInits = QueryServiceHelper.query((String)"bei_serviceconfig", (String)"id,batchdownstrategy,batchdownaccountsnum", null);
        if (servConfInits.size() > 0 && 0 == (batchDownAcctCount = ((DynamicObject)servConfInits.get(0)).getInt("batchdownaccountsnum"))) {
            batchDownAcctCount = 1;
        }
        if (endDate.compareTo(DateUtils.getCurrentDate()) >= 0) {
            logger.info("is start to get curr data ");
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, endDate, endDate, batchDownAcctCount);
            logger.info("start to get history data after get curr ");
            Date endBeforeDay = DateUtils.getLastDay((Date)endDate, (int)1);
            if (endBeforeDay.compareTo(beginDate) >= 0) {
                this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, beginDate, endBeforeDay, batchDownAcctCount);
            }
            logger.info("end to get history data after get curr ");
        } else {
            logger.info("start to get history data");
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, beginDate, endDate, batchDownAcctCount);
            logger.info("end to get history data ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBalanceData(Map<Long, DynamicObject> accountBankMap, Map<Map<String, Object>, Set<Long>> bankInterface_AcctIds, Map<Long, String> bankId_Number, Date beginDate, Date endDate, Integer batchDownAcctCount) {
        logger.info("bankInterfaceAccounMap is that:" + SerializationUtils.toJsonString(bankInterface_AcctIds));
        int size = bankInterface_AcctIds.size();
        int progress = 0;
        for (Map.Entry<Map<String, Object>, Set<Long>> group : bankInterface_AcctIds.entrySet()) {
            Set<Long> bankIds = group.getValue();
            Map<String, Object> keyMap = group.getKey();
            ArrayList<Long> bankAccts = new ArrayList<Long>(bankIds);
            int bankSize = bankIds.size();
            for (int i = 0; i < bankSize; i += batchDownAcctCount.intValue()) {
                List subList = i + batchDownAcctCount >= bankSize ? bankAccts.subList(i, bankSize) : bankAccts.subList(i, i + batchDownAcctCount);
                DynamicObject currency = (DynamicObject)keyMap.get("currency");
                ArrayList<String> bankNumList = new ArrayList<String>(10);
                ArrayList<String> swCodeList = new ArrayList<String>(10);
                ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>(10);
                for (Long bankId : subList) {
                    bankNumList.add(bankId_Number.get(bankId));
                    DynamicObject account = accountBankMap.get(bankId);
                    accountList.add(account);
                    DynamicObject bank = account.getDynamicObject("bank");
                    String swCode = "";
                    if (bank != null) {
                        swCode = bank.getString("swift_code");
                    }
                    swCodeList.add(swCode);
                }
                DynamicObject queryRequestRecord = QueryRequestRecordHelper.buildQueryRequestRecord(accountList, currency, beginDate, endDate, Long.parseLong(this.taskId));
                String bankInterface = keyMap.get("bankinterface").toString();
                long requestId = queryRequestRecord.getLong("requestid");
                BalanceQueryParam balanceQueryParam = new BalanceQueryParam(null, beginDate, endDate, null);
                BalanceQueryInfo balanceQueryInfo = new BalanceQueryInfo(balanceQueryParam);
                balanceQueryInfo.setBankAccts(bankNumList);
                balanceQueryInfo.setSwiftCode(swCodeList);
                DynamicObject accountBankDy = accountBankMap.get(subList.get(0));
                balanceQueryInfo.setBankAcct(accountBankDy);
                balanceQueryInfo.setCurrency(currency);
                balanceQueryInfo.setBankVersion(bankInterface);
                balanceQueryInfo.setOrgId(accountBankDy.getDynamicObject("openorg").getLong("id"));
                balanceQueryInfo.setRequestId(requestId);
                String errorMsg = "";
                try {
                    BalanceResult balanceResult = EBServiceFacadeFactory.getBankService().queryBatchBalance(balanceQueryInfo, queryRequestRecord);
                    errorMsg = balanceResult.getErrMsg();
                }
                catch (Exception e) {
                    try {
                        logger.error("queryBatchBalance" + requestId + "Exception:", (Throwable)e);
                        errorMsg = e.getMessage();
                    }
                    catch (Throwable throwable) {
                        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                            queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                            queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                            queryRequestRecord.set("exception_tag", (Object)errorMsg);
                        } else {
                            queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                        }
                        throw throwable;
                    }
                    if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                        queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                        queryRequestRecord.set("exception_tag", (Object)errorMsg);
                    } else {
                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                    }
                }
                if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                    queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                    queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                    queryRequestRecord.set("exception_tag", (Object)errorMsg);
                } else {
                    queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryRequestRecord});
            }
            this.feedbackProgress(++progress * 100 / size);
        }
    }
}

