/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.upgrade;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class BotpUpdateService {
    private static final Log logger = LogFactory.getLog(BotpUpdateService.class);
    public static final String BEI_TRANSDETAIL_CAS = "bei_transdetail_cas";
    public String sourceBillType;
    public String targetBillType;
    public String tc;
    public String lk;

    public String upgrade(List<String> listParams) {
        this.sourceBillType = listParams.get(0);
        this.targetBillType = listParams.get(1);
        this.tc = listParams.get(2);
        this.lk = listParams.get(3);
        Map<String, Long> tableMap = this.getTableMap();
        logger.info("tableMap\uff1a{}", tableMap);
        if (tableMap.isEmpty()) {
            logger.info("tableid not found");
            return "tableid not found";
        }
        Set<Long> sourceBillIds = this.getSourceBillIds();
        logger.info("sourceBillIds\uff1a{}", sourceBillIds);
        try (TXHandle h = TX.requiresNew((String)"sSQL1");){
            try {
                String sSQL1 = "Update t_botp_billtracker set FSTableId = ? where FSTableId = ? and FTTableId = ?";
                DB.execute((DBRoute)DBRouteConst.SYS, (String)sSQL1, (Object[])new Object[]{tableMap.get(this.sourceBillType), tableMap.get(BEI_TRANSDETAIL_CAS), tableMap.get(this.targetBillType)});
            }
            catch (Exception e) {
                logger.error("sSQL1\u5f02\u5e38", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        h = TX.requiresNew((String)"sSQL2");
        var5_5 = null;
        try {
            try {
                String sSQL2 = "Update " + this.tc + " set FSTableId = ? where FSTableId = ? and FTTableId = ?";
                DB.execute((DBRoute)DBRouteConst.CAS, (String)sSQL2, (Object[])new Object[]{tableMap.get(this.sourceBillType), tableMap.get(BEI_TRANSDETAIL_CAS), tableMap.get(this.targetBillType)});
            }
            catch (Exception e) {
                logger.error("sSQL2\u5f02\u5e38", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable e) {
            var5_5 = e;
            throw e;
        }
        finally {
            if (h != null) {
                if (var5_5 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable e) {
                        var5_5.addSuppressed(e);
                    }
                } else {
                    h.close();
                }
            }
        }
        h = TX.requiresNew((String)"sSQL3");
        var5_5 = null;
        try {
            try {
                String sSQL3 = "Update " + this.lk + " set FSTableId = ? where FSTableId = ?";
                DB.execute((DBRoute)DBRouteConst.CAS, (String)sSQL3, (Object[])new Object[]{tableMap.get(this.sourceBillType), tableMap.get(BEI_TRANSDETAIL_CAS)});
            }
            catch (Exception e) {
                logger.error("sSQL3\u5f02\u5e38", (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (var5_5 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        return "success";
    }

    private Set<Long> getSourceBillIds() {
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((String)BEI_TRANSDETAIL_CAS, (String)"id", null);
        Long[] transDetailIds = (Long[])Arrays.stream(transDetails).map(t -> t.getLong("id")).toArray(Long[]::new);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)BEI_TRANSDETAIL_CAS, (Long[])transDetailIds);
        HashSet<Long> sourceBillIds = new HashSet<Long>();
        for (Map.Entry entry : targetBills.entrySet()) {
            if (!Objects.equals(this.targetBillType, entry.getKey())) continue;
            sourceBillIds.addAll((Collection)entry.getValue());
        }
        return sourceBillIds;
    }

    private Map<String, Long> getTableMap() {
        List<String> entitys = Arrays.asList(this.sourceBillType, BEI_TRANSDETAIL_CAS, this.targetBillType);
        HashMap<String, Long> tableMap = new HashMap<String, Long>();
        for (String entity : entitys) {
            this.getTableMap(entity, tableMap);
        }
        return tableMap;
    }

    private void getTableMap(String entity, Map<String, Long> tableMap) {
        String sSQL = "select ftableid from t_meta_entityinfo where fentitykey = ?";
        DataSet ds = DB.queryDataSet((String)"entity", (DBRoute)DBRoute.meta, (String)sSQL, (Object[])new Object[]{entity});
        if (ds.hasNext()) {
            Row row = ds.next();
            Long ftableid = row.getLong("ftableid");
            tableMap.put(entity, ftableid);
        }
    }
}

