/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankpay;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankPayingErrorCode;

public class BankPayBillCommitBeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("bankpaystate");
        lst.add("isbitback");
        lst.add("billstatus");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ErrorCode BILLSTATUS_CANNOT_SUBMIT = new BankPayingErrorCode().BILLSTATUS_CANNOT_SUBMIT();
        ErrorCode STATUS_CANNOT_SUBMIT = new BankPayingErrorCode().STATUS_CANNOT_SUBMIT();
        ErrorCode BITBACKED_CANNOT_SUBMIT = new BankPayingErrorCode().BITBACKED_CANNOT_SUBMIT();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String billStauts = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStauts)) {
                this.addErrorMessage(data, BILLSTATUS_CANNOT_SUBMIT.getMessage());
            }
            String bankPayState = info.getString("bankpaystate");
            if (!BeBillStatusEnum.OP.getValue().equals(bankPayState)) {
                this.addErrorMessage(data, STATUS_CANNOT_SUBMIT.getMessage());
                continue;
            }
            if (!info.getBoolean("isbitback")) continue;
            this.addErrorMessage(data, BITBACKED_CANNOT_SUBMIT.getMessage());
        }
    }
}

