/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankpay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankPayCommitBeSrcValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("srcbilltype");
        lst.add("sourcebillid");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<String, List<ExtendedDataEntity>> srcBillGrp = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(o -> {
            String sourceBillType = o.getDataEntity().getString("srcbilltype");
            return EmptyUtil.isEmpty((String)sourceBillType) ? "cas_paybill" : sourceBillType;
        }));
        for (Map.Entry<String, List<ExtendedDataEntity>> grpEntry : srcBillGrp.entrySet()) {
            String procStatusVal;
            String procStatusProp;
            String srcBillType = grpEntry.getKey();
            if ("ifm_transhandlebill".equals(srcBillType)) {
                procStatusProp = "paidstatus";
                procStatusVal = "B";
            } else {
                procStatusProp = "billstatus";
                procStatusVal = "E";
            }
            List srcIdList = grpEntry.getValue().stream().map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
            QFilter srcIdFilter = new QFilter("id", "in", srcIdList);
            QFilter srcStatusFilter = new QFilter(procStatusProp, "=", (Object)procStatusVal);
            DynamicObjectCollection legalIdCol = QueryServiceHelper.query((String)srcBillType, (String)"id", (QFilter[])new QFilter[]{srcIdFilter, srcStatusFilter});
            Set legalSetIdSet = legalIdCol.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            for (ExtendedDataEntity data : grpEntry.getValue()) {
                DynamicObject info = data.getDataEntity();
                long sourceBillId = info.getLong("sourcebillid");
                if (legalSetIdSet.contains(sourceBillId)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u5355\u636e\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u4e3a\u94f6\u4f01\u5904\u7406\u4e2d, \u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"BankPayService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
    }
}

