/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankpay;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.errorcode.BankPayingErrorCode;

public class BankPayingAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(60);
        lst.add("creator");
        lst.add("auditor");
        lst.add("auditdate");
        lst.add("billno");
        lst.add("billstatus");
        lst.add("srcbilltype");
        lst.add("srcbillno");
        lst.add("company");
        lst.add("applyorg");
        lst.add("submittime");
        lst.add("expectdealtime");
        lst.add("payeeacct");
        lst.add("currency");
        lst.add("amount");
        lst.add("usage");
        lst.add("isbitback");
        lst.add("isrefund");
        lst.add("accountbank");
        lst.add("payeename");
        lst.add("payeeacct");
        lst.add("payeebank");
        lst.add("recbanknumber");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("serialnumber");
        lst.add("bankreturnmsg");
        lst.add("bitbacker");
        lst.add("bitbacktime");
        lst.add("bankpaystate");
        lst.add("batchseqid");
        lst.add("isprivatepay");
        lst.add("submituser");
        lst.add("sourcebillid");
        lst.add("statementrefno");
        lst.add("islinkpay");
        lst.add("parentacctbank");
        lst.add("childacctbank");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ErrorCode STATUS_CANNOT_AUDIT = new BankPayingErrorCode().STATUS_CANNOT_AUDIT();
        ErrorCode AUDITED_CANNOT_AUDIT = new BankPayingErrorCode().AUDITED_CANNOT_AUDIT();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String bankPayState = info.getString("bankpaystate");
            if (!bankPayState.equals(BeBillStatusEnum.OP.getValue())) {
                throw new KDBizException(STATUS_CANNOT_AUDIT, new Object[0]);
            }
            if (BillStatusEnum.AUDIT.getValue().equalsIgnoreCase(info.getString("billstatus"))) {
                throw new KDBizException(AUDITED_CANNOT_AUDIT, new Object[0]);
            }
            if (!info.getBoolean("islinkpay") || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{info.getDynamicObject("parentacctbank"), info.getDynamicObject("childacctbank")})) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u573a\u666f\u4e0b\uff0c\u8054\u52a8\u652f\u4ed8\u76f8\u5173\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankPayingAuditValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

