/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankpay;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankAgentErrorCode;

public class BankPayingBitBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(60);
        lst.add("billno");
        lst.add("billstatus");
        lst.add("srcbilltype");
        lst.add("srcbillno");
        lst.add("company");
        lst.add("applyorg");
        lst.add("submittime");
        lst.add("expectdealtime");
        lst.add("payeeacct");
        lst.add("currency");
        lst.add("amount");
        lst.add("usage");
        lst.add("isbitback");
        lst.add("isrefund");
        lst.add("bankpaystate");
        lst.add("payeename");
        lst.add("payeeacct");
        lst.add("payeebank");
        lst.add("recbanknumber");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("serialnumber");
        lst.add("bankreturnmsg");
        lst.add("bitbacker");
        lst.add("bitbacktime");
        lst.add("batchseqid");
        lst.add("isprivatepay");
        lst.add("sourcebillid");
        lst.add("statementrefno");
        lst.add("isupdatingstatus");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean isUpdatingStatus;
            boolean canBitBack;
            DynamicObject info = data.getDataEntity();
            String billstatus = info.getString("billstatus");
            if (info.getBoolean("isbitback")) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u6253\u56de\uff0c\u4e0d\u80fd\u518d\u6b21\u6253\u56de\u3002", (String)"BankPayingBitBackValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String bankPayState = info.getString("bankpaystate");
            boolean bl = canBitBack = BeBillStatusEnum.TF.getValue().equals(bankPayState) && BillStatusEnum.AUDIT.getValue().equals(billstatus) || BillStatusEnum.SAVE.getValue().equals(billstatus);
            if (!canBitBack) {
                this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u8005\u4ea4\u6613\u5931\u8d25\u7684\u94f6\u884c\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u6253\u56de\u3002", (String)"BankPayingBitBackValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (info.getBoolean("isrefund")) {
                this.addMessage(data, ResManager.loadKDString((String)"\u94f6\u884c\u9000\u7968\u4e0d\u5141\u8bb8\u6253\u56de\u3002", (String)"BankPayingBitBackValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (!(isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName()))) continue;
            this.addErrorMessage(data, new BankAgentErrorCode().BANKPAYSTATE_ISUPDATINGSTATUS_REPAY().getMessage());
        }
    }
}

