/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankpay;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class BankPayingRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("bankpaystate");
        lst.add("isupdatingstatus");
        lst.add("billstatus");
        lst.add("billno");
        lst.add("billstatus");
        lst.add("srcbillno");
        lst.add("company");
        lst.add("payeeacct");
        lst.add("isrefund");
        lst.add("submittime");
        lst.add("accountbank");
        lst.add("serialnumber");
        lst.add("bankreturnmsg");
        lst.add("batchseqid");
        lst.add("sourcebillid");
        lst.add("statementrefno");
        lst.add("currency");
        lst.add("incomeradds");
        lst.add("incomeswiftcode");
        lst.add("incomebankcode");
        lst.add("istranspay");
        lst.add("usecn");
        lst.add("excontract");
        lst.add("payerfeeaccno");
        lst.add("paymentmethod");
        lst.add("servicelevel");
        lst.add("transremarks");
        lst.add("proxyaccno");
        lst.add("proxyaccname");
        lst.add("proxybankcountry");
        lst.add("proxybankarea");
        lst.add("proxyswiftcode");
        lst.add("proxybankname");
        lst.add("proxybankadds");
        lst.add("deliverymethod");
        lst.add("chequetype");
        lst.add("chequeusage");
        lst.add("payerfeetype");
        lst.add("payerfeecurrency");
        lst.add("tolexchangerate");
        lst.add("srcbilltype");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String billstatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u8fdb\u884c\u5931\u8d25\u91cd\u4ed8\u3002", (String)"BankPayingRepayValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), BillStatusEnum.getName((String)billstatus)));
                continue;
            }
            String payState = info.getString("bankpaystate");
            if (!BeBillStatusEnum.TF.getValue().equals(payState)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5931\u8d25\u91cd\u4ed8\u3002", (String)"BankPayingRepayValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            boolean isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName());
            if (!isUpdatingStatus) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5305\u542b\u672a\u5b8c\u6210\u7684\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u8bf7\u5b8c\u6210\u6d41\u7a0b\u5ba1\u6838\u540e\u518d\u64cd\u4f5c\u3002", (String)"BankPayingRepayValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

