/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.banktrans;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankAgentErrorCode;

public class BankTransBitBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("paystate");
        selector.add("isupdatingstatus");
        selector.add("isbitback");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean isUpdatingStatus;
            boolean canBitBack;
            DynamicObject info = data.getDataEntity();
            String billstatus = info.getString("billstatus");
            String bankPayState = info.getString("paystate");
            boolean bl = canBitBack = (BeBillStatusEnum.TF.getValue().equals(bankPayState) || BeBillStatusEnum.PS.getValue().equals(bankPayState)) && BillStatusEnum.AUDIT.getValue().equals(billstatus) || BillStatusEnum.SAVE.getValue().equals(billstatus);
            if (!canBitBack) {
                this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u5b58\u201d\u3001\u201c\u4ea4\u6613\u5931\u8d25\u201d\u6216\u201c\u90e8\u5206\u5931\u8d25\u201d\u7684\u5355\u636e\u624d\u80fd\u6253\u56de\u3002", (String)"BankTransBitBackValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (info.getBoolean("isbitback")) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u6253\u56de\uff0c\u4e0d\u80fd\u518d\u6b21\u6253\u56de\u3002", (String)"BankTransBitBackValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (!(isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName()))) continue;
            this.addErrorMessage(data, new BankAgentErrorCode().BANKPAYSTATE_ISUPDATINGSTATUS_REPAY().getMessage());
        }
    }
}

