/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.banktrans;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankTransSyncStatusValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("paystate");
        selector.add("isupdatingstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            Object billStatus = info.get("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String status = info.getString("paystate");
            if (BeBillStatusEnum.OP.getValue().equals(status)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u51c6\u5907\u63d0\u4ea4\u72b6\u6001\u4e0d\u5141\u8bb8\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (BeBillStatusEnum.TF.getValue().equals(status)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (BeBillStatusEnum.TS.getValue().equals(status)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f\uff0c\u4e0d\u80fd\u518d\u6b21\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (status.equals(BeBillStatusEnum.OF.getValue())) {
                this.addMessage(data, ResManager.loadKDString((String)"\u94f6\u4f01\u5f02\u5e38\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_5", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (status.equals(BeBillStatusEnum.PS.getValue())) {
                this.addMessage(data, ResManager.loadKDString((String)"\u90e8\u5206\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_6", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (status.equals(BeBillStatusEnum.SF.getValue())) {
                this.addMessage(data, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u540c\u6b65\u72b6\u6001\u3002", (String)"BankTransSyncStatusValidator_8", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            OperateOption option = this.getOption();
            String validate = option.getVariableValue("isvalidate", "true");
            if (EmptyUtil.isNotEmpty((CharSequence)validate) && StringUtils.equals((CharSequence)validate, (CharSequence)"false") || !PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName())) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u9009\u62e9\u8bb0\u5f55\u5305\u542b\u672a\u5ba1\u6838\u5b8c\u6210\u7684\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u5355\u3002", (String)"BankTransSyncStatusValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

