/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.detail;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.helper.SyncAutoBalanceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SyncAutoBalanceValdator
extends AbstractTmcBizOppValidator {
    private static final DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();

    public void validate(ExtendedDataEntity[] extendDetailDatas) throws KDBizException {
        Set currencyIds;
        List accountBankIds;
        QFilter qFilter;
        Date endDate;
        DynamicObject dataEntity = extendDetailDatas[0].getDataEntity();
        Date startDate = dataEntity.getDate("startdate");
        int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)(endDate = dataEntity.getDate("enddate")));
        if (diffDays > 90) {
            this.addErrorMessage(extendDetailDatas[0], ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u8303\u56f4\u4e0d\u5141\u8bb8\u8d85\u8fc790\u5929\u3002", (String)"SyncAutoBalanceValdator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection orgs = dataEntity.getDynamicObjectCollection("org");
        List orgIds = orgs.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection accountBanks = dataEntity.getDynamicObjectCollection("accountbank");
        DynamicObjectCollection currencys = dataEntity.getDynamicObjectCollection("currency");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)accountBanks)) {
            qFilter = SyncAutoBalanceHelper.getAccountBankQfilter(orgIds);
            accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, currency.fbasedataid.id as currencyid", (QFilter[])qFilter.toArray());
            accountBankIds = accountBanks.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            currencyIds = accountBanks.stream().map(o -> o.getLong("currencyid")).collect(Collectors.toSet());
        } else {
            accountBankIds = accountBanks.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
                currencyIds = currencys.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            } else {
                qFilter = new QFilter("id", "in", accountBankIds);
                accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, currency.fbasedataid.id as currencyid", (QFilter[])qFilter.toArray());
                currencyIds = accountBanks.stream().map(o -> o.getLong("currencyid")).collect(Collectors.toSet());
            }
        }
        String detailSelectField = "id,billno,company,currency,accountbank,bizdate,transbalance,biztime,sortno";
        QFilter qFilter2 = new QFilter("company", "in", orgIds);
        qFilter2.and("datasource", "in", (Object)new String[]{DataSourceEnum.IMPORT.getValue(), DataSourceEnum.RECEIPTGEN.getValue(), DataSourceEnum.FROMIMG.getValue()});
        qFilter2.and("accountbank", "in", accountBankIds);
        qFilter2.and("currency", "in", currencyIds);
        qFilter2.and("bizdate", ">=", (Object)startDate);
        qFilter2.and("bizdate", "<=", (Object)endDate);
        Object[] transDetailColl = BusinessDataServiceHelper.load((String)"bei_betransdetail_imp", (String)detailSelectField, (QFilter[])qFilter2.toArray());
        if (EmptyUtil.isEmpty((Object[])transDetailColl)) {
            this.addErrorMessage(extendDetailDatas[0], ResManager.loadKDString((String)"\u6240\u9009\u8303\u56f4\u4e0d\u5b58\u5728\u53ef\u81ea\u52a8\u751f\u6210\u4f59\u989d\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SyncAutoBalanceValdator_2", (String)"tmc-bei-business", (Object[])new Object[0]));
        } else {
            String serialize = SerializationUtils.serializeToBase64((Object)transDetailColl);
            String traceId = RequestContext.get().getTraceId();
            cache.put("auto_balance_cache_transdetail_data_" + traceId, (Object)serialize, 3600000);
        }
    }
}

