/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.serviceconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class ServiceConfigSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("isenable");
        selector.add("isenable2");
        selector.add("serveraddress");
        selector.add("serveraddress2");
        selector.add("appid");
        selector.add("appsecret");
        selector.add("usertype");
        selector.add("useraccount");
        selector.add("publiccaname");
        selector.add("isopenapi");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DynamicObject[] servConfInits;
        DynamicObjectCollection appScopes_new;
        ExtendedDataEntity data = this.dataEntities[0];
        DynamicObject item = data.getDataEntity();
        if (item.getBoolean("isenable")) {
            if (StringUtils.isEmpty((CharSequence)item.getString("serveraddress").replace("http://", ""))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u670d\u52a1\u542f\u7528\u65f6\uff0c\u670d\u52a1\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (StringUtils.isEmpty((CharSequence)item.getString("customerid"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5ba2\u6237ID\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_9", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
        if (item.getBoolean("isenable2") && item.getBoolean("isopenapi")) {
            if (StringUtils.isEmpty((CharSequence)item.getString("serveraddress2").replace("http://", ""))) {
                this.addMessage(data, ResManager.loadKDString((String)"OpenAPI\u5f00\u542f\u65f6\uff0c\u670d\u52a1\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (StringUtils.isEmpty((CharSequence)item.getString("appid")) || StringUtils.isEmpty((CharSequence)item.getString("appsecret"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5f00\u653e\u5e73\u53f0\u8ba4\u8bc1\u7cfb\u7edf\u7f16\u7801\u548cAccess Token\u52a0\u5bc6\u8ba4\u8bc1\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (StringUtils.isEmpty((CharSequence)item.getString("usertype")) || StringUtils.isEmpty((CharSequence)item.getString("useraccount"))) {
                this.addMessage(data, ResManager.loadKDString((String)"OpenAPI\u5f00\u542f\u65f6\uff0c\u7528\u6237\u7c7b\u578b\u548c\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (StringUtils.isEmpty((CharSequence)item.getString("publiccaname"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u7cfb\u7edf\u516c\u94a5\u8bc1\u4e66\u5fc5\u987b\u4e0a\u4f20\u3002", (String)"ServiceConfigSaveValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (StringUtils.isEmpty((CharSequence)item.getString("customerid2"))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5ba2\u6237ID\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigSaveValidator_10", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
        if (item.getBoolean("isenable") && item.getBoolean("isenable2") && (appScopes_new = item.getDynamicObjectCollection("appscope_entity")) != null && appScopes_new.size() > 1) {
            HashMap<Object, List> idSeqMap = new HashMap<Object, List>();
            ArrayList<Long> reBankCgSeq = new ArrayList<Long>(appScopes_new.size());
            for (DynamicObject entry : appScopes_new) {
                Long id = (Long)entry.getDynamicObject("e_bankcgno").getPkValue();
                List seqList = idSeqMap.getOrDefault(id, new ArrayList(10));
                Long seq = entry.getLong("seq");
                seqList.add(seq);
                idSeqMap.put(id, seqList);
                if (seqList.size() <= 1) continue;
                reBankCgSeq.add(seq);
            }
            if (reBankCgSeq.size() > 0) {
                String reTips = ResManager.loadKDString((String)"\u9002\u7528\u8303\u56f4\u7b2c%s\u884c\u94f6\u884c\u7c7b\u522b\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u586b\u5199\u3002", (String)"ServiceConfigSaveValidator_11", (String)"tmc-bei-business", (Object[])new Object[0]);
                ArrayList<String> msgList = new ArrayList<String>(reBankCgSeq.size());
                for (Long seq : reBankCgSeq) {
                    String msg = String.format(reTips, seq);
                    msgList.add(msg);
                }
                String content = String.join((CharSequence)"\r\n", msgList);
                this.addMessage(data, content, ErrorLevel.Error);
            }
        }
        if ((servConfInits = TmcDataServiceHelper.load((String)"bei_serviceconfig", (String)"id", null)).length > 0) {
            String id = servConfInits[0].getString("id");
            boolean isProcessingBill = false;
            DynamicObject servConfInit = TmcDataServiceHelper.loadSingle((Object)id, (String)"bei_serviceconfig");
            boolean isEnableService1_new = item.getBoolean("isenable");
            boolean isEnableService2_new = item.getBoolean("isenable2");
            boolean isEnableService1_old = servConfInit.getBoolean("isenable");
            boolean isEnableService2_old = servConfInit.getBoolean("isenable2");
            DynamicObjectCollection appScopes_new2 = item.getDynamicObjectCollection("appscope_entity");
            DynamicObjectCollection appScopes_old = servConfInit.getDynamicObjectCollection("appscope_entity");
            Set bankCgNoIds_new = appScopes_new2.stream().filter(appScope -> appScope.getDynamicObject("e_bankcgno") != null).map(appScope -> (Long)appScope.getDynamicObject("e_bankcgno").getPkValue()).collect(Collectors.toSet());
            Set bankCgNoIds_old = appScopes_old.stream().filter(appScope -> appScope.getDynamicObject("e_bankcgno") != null).map(appScope -> (Long)appScope.getDynamicObject("e_bankcgno").getPkValue()).collect(Collectors.toSet());
            boolean isChangeAppScope = false;
            if (bankCgNoIds_new.size() != bankCgNoIds_old.size()) {
                isChangeAppScope = true;
            } else if (!bankCgNoIds_new.containsAll(bankCgNoIds_old)) {
                isChangeAppScope = true;
            }
            QFilter filter = new QFilter("paystate", "in", (Object)new String[]{BeBillStatusEnum.OS.getValue(), BeBillStatusEnum.BP.getValue(), BeBillStatusEnum.OF.getValue(), BeBillStatusEnum.NC.getValue()});
            QFilter filter1 = new QFilter("bankpaystate", "in", (Object)new String[]{BeBillStatusEnum.OS.getValue(), BeBillStatusEnum.BP.getValue(), BeBillStatusEnum.OF.getValue(), BeBillStatusEnum.NC.getValue()});
            DynamicObject[] bankPayBills = TmcDataServiceHelper.load((String)"bei_bankpaybill", (String)"id,accountbank.bank", (QFilter[])new QFilter[]{filter1});
            DynamicObject[] bankAgentPays = TmcDataServiceHelper.load((String)"bei_bankagentpay", (String)"id,accountbank.bank", (QFilter[])new QFilter[]{filter});
            DynamicObject[] bankTranSupBills = TmcDataServiceHelper.load((String)"bei_banktransupbill", (String)"id,accountbank.bank", (QFilter[])new QFilter[]{filter});
            DynamicObject[] bankTransDownBills = TmcDataServiceHelper.load((String)"bei_banktransdownbill", (String)"id,accountbank.bank", (QFilter[])new QFilter[]{filter});
            Set banks1 = Stream.of(bankPayBills).filter(bankPayBill -> bankPayBill.getDynamicObject("accountbank.bank") != null).map(bankPayBill -> (Long)bankPayBill.getDynamicObject("accountbank.bank").getPkValue()).collect(Collectors.toSet());
            Set banks2 = Stream.of(bankAgentPays).filter(bankAgentPay -> bankAgentPay.getDynamicObject("accountbank.bank") != null).map(bankAgentPay -> (Long)bankAgentPay.getDynamicObject("accountbank.bank").getPkValue()).collect(Collectors.toSet());
            Set banks3 = Stream.of(bankTranSupBills).filter(bankTranSupBill -> bankTranSupBill.getDynamicObject("accountbank.bank") != null).map(bankTranSupBill -> (Long)bankTranSupBill.getDynamicObject("accountbank.bank").getPkValue()).collect(Collectors.toSet());
            Set banks4 = Stream.of(bankTransDownBills).filter(bankTransDownBill -> bankTransDownBill.getDynamicObject("accountbank.bank") != null).map(bankTransDownBill -> (Long)bankTransDownBill.getDynamicObject("accountbank.bank").getPkValue()).collect(Collectors.toSet());
            HashSet banks = new HashSet(10);
            banks.addAll(banks1);
            banks.addAll(banks2);
            banks.addAll(banks3);
            banks.addAll(banks4);
            QFilter filter2 = new QFilter("id", "in", banks);
            DynamicObject[] bankBills = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bank_cate", (QFilter[])new QFilter[]{filter2});
            Set bankCates = Stream.of(bankBills).filter(bankBill -> bankBill.getDynamicObject("bank_cate") != null).map(bankBill -> (Long)bankBill.getDynamicObject("bank_cate").getPkValue()).collect(Collectors.toSet());
            if (!(isEnableService1_new == isEnableService1_old && isEnableService2_new == isEnableService2_old || bankPayBills.length <= 0 && bankAgentPays.length <= 0 && bankTranSupBills.length <= 0 && bankTransDownBills.length <= 0)) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u7b49\u5f85\u5728\u9014\u94f6\u884c\u5355\u636e\u5904\u7406\u5b8c\u6210\uff0c\u518d\u4fee\u6539\u94f6\u4f01\u670d\u52a1\u914d\u7f6e\u3002", (String)"ServiceConfigSaveValidator_5", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                isProcessingBill = true;
                return;
            }
            if (!isProcessingBill && isChangeAppScope && isEnableService1_new && isEnableService2_new) {
                if (bankCgNoIds_old.size() == 0 && bankCgNoIds_new.size() > 0) {
                    for (Long bankCateId : bankCates) {
                        if (bankCgNoIds_new.contains(bankCateId)) continue;
                        this.addMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u7b49\u5f85\u5728\u9014\u94f6\u884c\u5355\u636e\u5904\u7406\u5b8c\u6210\uff0c\u518d\u4fee\u6539\u94f6\u4f01\u670d\u52a1\u914d\u7f6e\u3002", (String)"ServiceConfigSaveValidator_5", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                        return;
                    }
                } else if (bankCgNoIds_old.size() > 0) {
                    for (Long bankCgNoId : bankCgNoIds_new) {
                        if (bankCgNoIds_old.contains(bankCgNoId) || !bankCates.contains(bankCgNoId)) continue;
                        this.addMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u7b49\u5f85\u8be5\u94f6\u884c\u8fd4\u56de\u5728\u9014\u4e1a\u52a1\u652f\u4ed8\u60c5\u51b5\uff0c\u518d\u4fee\u6539\u9002\u7528\u8303\u56f4\u3002", (String)"ServiceConfigSaveValidator_7", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                        break;
                    }
                    if (bankCgNoIds_new.size() == 0) {
                        for (Long bankCate : bankCates) {
                            if (bankCgNoIds_old.contains(bankCate)) continue;
                            this.addMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u7b49\u5f85\u5728\u9014\u94f6\u884c\u5355\u636e\u5904\u7406\u5b8c\u6210\uff0c\u518d\u4fee\u6539\u9002\u7528\u8303\u56f4\u3002", (String)"ServiceConfigSaveValidator_8", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                            break;
                        }
                    } else {
                        for (Long bankCgNoId : bankCgNoIds_old) {
                            if (bankCgNoIds_new.contains(bankCgNoId) || !bankCates.contains(bankCgNoId)) continue;
                            this.addMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u7b49\u5f85\u8be5\u94f6\u884c\u8fd4\u56de\u5728\u9014\u4e1a\u52a1\u652f\u4ed8\u60c5\u51b5\uff0c\u518d\u4fee\u6539\u9002\u7528\u8303\u56f4\u3002", (String)"ServiceConfigSaveValidator_7", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
                        }
                    }
                }
            } else if (!isProcessingBill && !isEnableService1_new && isEnableService2_new && bankCgNoIds_new.size() > 0) {
                this.addMessage(data, ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u914d\u7f6e\u9002\u7528\u8303\u56f4\u3002", (String)"ServiceConfigSaveValidator_6", (String)"tmc-bei-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }
}

