/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.workbench;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PassiveCancelEnterValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PassiveCancelEnterValidator.class);

    public void validate() {
        List collect = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getPkValue()).collect(Collectors.toList());
        HashSet recedBillIds = new HashSet(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject detailData = data.getDataEntity();
            DynamicObjectCollection recedBillEntry = detailData.getDynamicObjectCollection("recedbillentry");
            recedBillIds.addAll(recedBillEntry.stream().map(v -> v.getLong("e_recedbillid")).collect(Collectors.toSet()));
        }
        QFilter sourcebillidFilter = new QFilter("sourcebillid", "in", collect);
        if (recedBillIds.size() > 0) {
            sourcebillidFilter = new QFilter("id", "in", recedBillIds);
        }
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        Set recedbillnumberSet = Arrays.stream(Arrays.stream(this.dataEntities).filter(o -> "handmerge".equals(o.getDataEntity().getString("receredway"))).map(o -> o.getDataEntity()).toArray(DynamicObject[]::new)).map(o -> o.getDynamicObjectCollection("recedbillentry")).flatMap(o -> o.stream().map(p -> p.getString("e_recedbillnumber"))).filter(o -> !EmptyUtil.isEmpty((String)o)).distinct().collect(Collectors.toSet());
        if (!EmptyUtil.isEmpty(recedbillnumberSet) && recedbillnumberSet.size() > 0) {
            sourcebillidFilter = sourcebillidFilter.or(new QFilter("billno", "in", recedbillnumberSet));
        }
        DynamicObject[] businessBillsFca = BusinessDataServiceHelper.load((String)"fca_transdownbill", (String)"id,billno,billstatus,sourcebillid", (QFilter[])new QFilter[]{sourcebillidFilter, billstatusFilter});
        DynamicObject[] businessBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,billstatus,org,bankcheckflag,sourcebillid,ishandlink", (QFilter[])new QFilter[]{sourcebillidFilter, billstatusFilter});
        List<String> recedBillNumber = AutoMatchHelper.getRecedBillNumber((DynamicObject[])Arrays.stream(this.dataEntities).map(o -> o.getDataEntity()).toArray(DynamicObject[]::new));
        DynamicObject[] businessBillR = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", recedBillNumber), billstatusFilter});
        String isDeleteWork = "true";
        if (this.getOption().containsVariable("isDeleteWork")) {
            isDeleteWork = this.getOption().getVariableValue("isDeleteWork");
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String format;
            String billno;
            String receredway;
            DynamicObject detailData = data.getDataEntity();
            String receredtype = detailData.getString("receredtype");
            if (!ReceredtypeEnum.ACCOUNTED.getValue().equals(receredtype)) {
                String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u53d6\u6d88\u751f\u5355\u3002", (String)"RecCancelEnterValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (!StringUtils.equalsAny((CharSequence)(receredway = detailData.getString("receredway")), (CharSequence[])new CharSequence[]{ReceredWayEnum.RULE.getValue(), ReceredWayEnum.HAND.getValue(), ReceredWayEnum.HANDMERGE.getValue()})) {
                billno = detailData.getString("billno");
                String format2 = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u64cd\u4f5c\u5931\u8d25\u3002\u53ea\u6709\u901a\u8fc7\u201c\u6309\u89c4\u5219\u751f\u5355\u201d\u6216\u201c\u624b\u5de5\u751f\u5355\u201d\u6216\u201c\u624b\u5de5\u5408\u5e76\u751f\u5355\u201d\u64cd\u4f5c\u6210\u529f\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u624d\u80fd\u53d6\u6d88\u751f\u5355\u3002", (String)"RecCancelEnterValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                this.addMessage(data, format2, ErrorLevel.Error);
            }
            if (!"true".equals(isDeleteWork)) continue;
            billno = detailData.getString("billno");
            List<String> recedBillNumbers = AutoMatchHelper.getRecedBillNumber(new DynamicObject[]{detailData});
            boolean result = Arrays.stream(businessBillR).anyMatch(businessBill -> recedBillNumbers.contains(businessBill.getString("billno")));
            if (result) {
                format = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u751f\u5355\uff0c\u8bf7\u5148\u5bf9\u6536\u6b3e\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"PassivePayWorkbenchList_55", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                this.addMessage(data, format, ErrorLevel.Error);
            }
            if (result = Arrays.stream(businessBills).anyMatch(businessBill -> detailData.getString("id").equals(businessBill.getString("sourcebillid")) || recedBillNumbers.contains(businessBill.getString("billno")))) {
                format = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5165\u8d26\uff0c\u8bf7\u5148\u5bf9\u4ed8\u6b3e\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"RecCancelEnterValidator_22", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                this.addMessage(data, format, ErrorLevel.Error);
            }
            if (!(result = Arrays.stream(businessBillsFca).anyMatch(businessBill -> detailData.getString("id").equals(businessBill.getString("sourcebillid")) || recedBillNumbers.contains(businessBill.getString("billno"))))) continue;
            format = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u6210\u7684\u5212\u62e8\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5165\u8d26\uff0c\u8bf7\u5148\u5bf9\u5212\u62e8\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"RecCancelEnterValidator_20", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
            this.addMessage(data, format, ErrorLevel.Error);
        }
    }
}

