/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RecCancelEnterValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(RecCancelEnterValidator.class);

    public void validate() {
        ArrayList<String> claimNos = new ArrayList<String>();
        HashSet recedBillIds = new HashSet(10);
        for (ExtendedDataEntity data : this.dataEntities) {
            String receredway;
            DynamicObject detailData = data.getDataEntity();
            String claimnoticebillno = detailData.getString("claimnoticebillno");
            if (claimnoticebillno != null && !"".equals(claimnoticebillno)) {
                claimNos.add(claimnoticebillno);
            }
            String receredtype = detailData.getString("receredtype");
            if (!ReceredtypeEnum.ACCOUNTED.getValue().equals(receredtype)) {
                String msg = ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u8fdb\u884c\u53d6\u6d88\u751f\u5355\u3002", (String)"RecCancelEnterValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            if (!StringUtils.equalsAny((CharSequence)(receredway = detailData.getString("receredway")), (CharSequence[])new CharSequence[]{ReceredWayEnum.RULE.getValue(), ReceredWayEnum.HAND.getValue(), ReceredWayEnum.HANDMERGE.getValue()})) {
                String billno = detailData.getString("billno");
                String format = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u64cd\u4f5c\u5931\u8d25\u3002\u53ea\u6709\u901a\u8fc7\u201c\u6309\u89c4\u5219\u751f\u5355\u201d\u6216\u201c\u624b\u5de5\u751f\u5355\u201d\u6216\u201c\u624b\u5de5\u5408\u5e76\u751f\u5355\u201d\u64cd\u4f5c\u6210\u529f\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u624d\u80fd\u53d6\u6d88\u751f\u5355\u3002", (String)"RecCancelEnterValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                this.addMessage(data, format, ErrorLevel.Error);
            }
            DynamicObjectCollection recedBillEntry = detailData.getDynamicObjectCollection("recedbillentry");
            recedBillIds.addAll(recedBillEntry.stream().map(v -> v.getLong("e_recedbillid")).collect(Collectors.toSet()));
        }
        QFilter filter = null;
        if (recedBillIds.size() > 0) {
            filter = new QFilter("id", "in", recedBillIds);
        }
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        Set recedbillnumberSet = Arrays.stream(Arrays.stream(this.dataEntities).filter(o -> "handmerge".equals(o.getDataEntity().getString("receredway"))).map(o -> o.getDataEntity()).toArray(DynamicObject[]::new)).map(o -> o.getDynamicObjectCollection("recedbillentry")).flatMap(o -> o.stream().map(p -> p.getString("e_recedbillnumber"))).filter(o -> !EmptyUtil.isEmpty((String)o)).distinct().collect(Collectors.toSet());
        if (!EmptyUtil.isEmpty(recedbillnumberSet) && recedbillnumberSet.size() > 0 && null != filter) {
            filter = filter.or(new QFilter("billno", "in", recedbillnumberSet));
        }
        DynamicObject[] businessBillArrFca = BusinessDataServiceHelper.load((String)"fca_transupbill", (String)"id,billstatus,billno,sourcebillid", (QFilter[])new QFilter[]{filter, billstatusFilter});
        if (claimNos.size() > 0) {
            filter = filter != null ? filter.or(new QFilter("sourcebillnumber", "in", claimNos)) : new QFilter("sourcebillnumber", "in", claimNos);
        }
        DynamicObject[] businessBillArr = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,billno,org,bankcheckflag,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{filter, billstatusFilter});
        DynamicObject[] cas_claimbills = null;
        DynamicObject[] claimBills = null;
        if (claimNos.size() > 0) {
            QFilter claimno = new QFilter("claimno", "in", claimNos);
            QFilter qFilter = new QFilter("claimtype", "=", (Object)"1");
            cas_claimbills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter[]{claimno, qFilter});
            claimBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", claimNos), new QFilter("isunclaim", "=", (Object)"1")});
        }
        DynamicObject[] businessBillR = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{filter, billstatusFilter});
        String isDeleteWork = "true";
        if (this.getOption().containsVariable("isDeleteWork")) {
            isDeleteWork = this.getOption().getVariableValue("isDeleteWork");
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String format;
            DynamicObject transbill = data.getDataEntity();
            String claimnoticebillno = transbill.getString("claimnoticebillno");
            String billno = transbill.getString("billno");
            if ("true".equals(isDeleteWork)) {
                String format2;
                List<String> recedBillNumbers = AutoMatchHelper.getRecedBillNumber(new DynamicObject[]{transbill});
                boolean result = Arrays.stream(businessBillArr).anyMatch(businessBill -> recedBillNumbers.contains(businessBill.getString("billno")));
                if (result) {
                    format2 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5165\u8d26\uff0c\u8bf7\u5148\u5bf9\u6536\u6b3e\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"RecCancelEnterValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                    this.addMessage(data, format2, ErrorLevel.Error);
                }
                if (result = Arrays.stream(businessBillR).anyMatch(businessBill -> recedBillNumbers.contains(businessBill.getString("billno")))) {
                    format2 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5165\u8d26\uff0c\u8bf7\u5148\u5bf9\u4ed8\u6b3e\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"RecCancelEnterValidator_22", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                    this.addMessage(data, format2, ErrorLevel.Error);
                }
                if (result = Arrays.stream(businessBillArrFca).anyMatch(businessBill -> recedBillNumbers.contains(businessBill.getString("billno")))) {
                    format2 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u751f\u6210\u7684\u5212\u62e8\u5355\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u5165\u8d26\uff0c\u8bf7\u5148\u5bf9\u5212\u62e8\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"RecCancelEnterValidator_20", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                    this.addMessage(data, format2, ErrorLevel.Error);
                }
            }
            if (cas_claimbills != null && cas_claimbills.length > 0) {
                for (DynamicObject cas_claimbill : cas_claimbills) {
                    String claimno1 = cas_claimbill.getString("claimno");
                    if (claimnoticebillno == null || !claimnoticebillno.equals(claimno1)) continue;
                    format = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u7ecf\u53d1\u751f\u4e86\u6536\u6b3e\u4e1a\u52a1\u53d8\u66f4\u64cd\u4f5c,\u8bf7\u5148\u8fdb\u884c\u6536\u6b3e\u4e1a\u52a1\u53d8\u66f4\u5904\u7406\u3002", (String)"RecCancelEnterValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                    this.addMessage(data, format, ErrorLevel.Error);
                }
            }
            if (claimBills == null || claimBills.length <= 0) continue;
            for (DynamicObject claimBill : claimBills) {
                String claimBillBillno = claimBill.getString("billno");
                if (!claimBillBillno.equals(claimnoticebillno)) continue;
                format = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u5df2\u5165\u8d26\uff0c\u8bf7\u5230\u201c\u8ba4\u9886\u4e2d\u5fc3\u201d\u53d6\u6d88\u5165\u8d26\u3002", (String)"RecCancelEnterValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]), billno);
                this.addMessage(data, format, ErrorLevel.Error);
            }
        }
    }
}

