/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.bei.extpoint.balance.IBalanceReportInterface;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDailyBalanceQueryHelper {
    public static final String DATE_RANGE_FLAG = "dateRangeFlag";
    public static final String CONDITION_COMPANY = "filter_org";
    public static final String CONDITION_ORGVIEW = "filter_orgview";
    public static final String CONDITION_BANK = "filter_bank";
    public static final String CONDITION_BANK_ACCOUNT_NUMBER = "filter_bankaccountnumber";
    public static final String CONDITION_CURRENCY = "filter_currency";
    public static final String CONDITION_DATE = "filter_bizdate";
    public static final String CONDITION_START_DATE = "filter_startbizdate";
    public static final String CONDITION_END_DATE = "filter_endbizdate";
    public static final String CONDITION_REPORT_CURRENCY = "filter_statcurrency";
    public static final String CONDITION_ACCT_STYLE = "filter_acctstyle";
    public static final String CONDITION_ACCTTYPE = "filter_accttype";
    public static final String CONDITION_ACCT_PROPERTY = "filter_acctproperty";
    public static final String CONDITION_CURRENCY_UNIT = "filter_currencyunit";
    private static final String SHOW_REPORT_AMOUNT = "reportamount";
    private static final String SHOW_ORIGINAL_AMOUNT = "originalamount";
    private static final String SHOW_REPORT_VALIBALANCE = "reportvalibalance";
    private static final String SHOW_ORIGINAL_VALIBALANCE = "originalvalibalance";
    private static final String SHOW_REPORT_LSTBALANCE = "reportlstbalance";
    private static final String SHOW_ORIGINAL_LSTBALANCE = "originallstbalance";
    private static final String SHOW_SERACH_DATE = "searchdate";
    private static final String ALIAS_SEPARATOR = ".";
    private static final String FILTER_SEPARATOR = "filter_";
    private static final String FILTER_MULTI_VALUE_SEPARATOR = ",";
    private static final String COLUMN_SEPARATOR = ",";
    private static final Set<String> BANK_CONDITION_SET = Collections.unmodifiableSet(new LinkedHashSet<String>(8){
        {
            this.add(BankDailyBalanceQueryHelper.CONDITION_BANK);
            this.add(BankDailyBalanceQueryHelper.CONDITION_BANK_ACCOUNT_NUMBER);
            this.add(BankDailyBalanceQueryHelper.CONDITION_ACCT_STYLE);
            this.add(BankDailyBalanceQueryHelper.CONDITION_ACCTTYPE);
            this.add(BankDailyBalanceQueryHelper.CONDITION_ACCT_PROPERTY);
            this.add(BankDailyBalanceQueryHelper.CONDITION_COMPANY);
        }
    });
    private static final Map<String, Map<String, String>> CONDITION_FILED_MAP_DATABASE_COLUMN = Collections.unmodifiableMap(new HashMap<String, Map<String, String>>(4){
        {
            this.put(BankDailyBalanceQueryHelper.FILTER_TYPE_BANK, new HashMap<String, String>(8){
                {
                    super(x0);
                    this.put(BankDailyBalanceQueryHelper.CONDITION_BANK, "");
                    this.put(BankDailyBalanceQueryHelper.CONDITION_BANK_ACCOUNT_NUMBER, "id");
                    this.put(BankDailyBalanceQueryHelper.CONDITION_ACCT_STYLE, "");
                    this.put(BankDailyBalanceQueryHelper.CONDITION_ACCTTYPE, "");
                    this.put(BankDailyBalanceQueryHelper.CONDITION_ACCT_PROPERTY, "");
                    this.put(BankDailyBalanceQueryHelper.CONDITION_COMPANY, "org.id");
                }
            });
            this.put(BankDailyBalanceQueryHelper.FILTER_TYPE_BANK_BALANCE, new HashMap<String, String>(8){
                {
                    super(x0);
                    this.put(BankDailyBalanceQueryHelper.CONDITION_BANK, "");
                }
            });
        }
    });
    private static final Map<String, String> FILTER_FIELD_OPERATER = Collections.unmodifiableMap(new HashMap<String, String>(4){
        {
            this.put(BankDailyBalanceQueryHelper.CONDITION_DATE, "<=");
            this.put(BankDailyBalanceQueryHelper.CONDITION_START_DATE, ">=");
            this.put(BankDailyBalanceQueryHelper.CONDITION_END_DATE, "<=");
        }
    });
    private static final Map<String, Class> FILTER_FIELD_FILTER_NULL = Collections.unmodifiableMap(new HashMap<String, Class>(4){
        {
            this.put(BankDailyBalanceQueryHelper.CONDITION_DATE, Date.class);
            this.put(BankDailyBalanceQueryHelper.CONDITION_START_DATE, Date.class);
            this.put(BankDailyBalanceQueryHelper.CONDITION_END_DATE, Date.class);
            this.put(BankDailyBalanceQueryHelper.CONDITION_BANK_ACCOUNT_NUMBER, Long.class);
        }
    });
    private static final String SELECT_FIELD_BANK_CURRENCY_NAME = "currency.name";
    private static final String SELECT_FIELD_BANK_CURRENCY_SIGN = "currency.sign";
    private static final String SELECT_FIELD_BANK_CURRENCY_AMTPRECISION = "currency.amtprecision";
    private static final String SELECT_FIELD_BANK_BANK_NAME = "accountbank.bank.name";
    private static final String SELECT_FIELD_BANK_COMPANY_NAME = "company.name";
    private static final String SELECT_FIELD_BANK_REPORT_CURRENCY = "statcurrency";
    private static final String COMPANY_NAME_ORDER_BY = "companynameorderby";
    private static final String FILTER_TYPE_BANK = "bd_accountbanks";
    private static final String FILTER_TYPE_BANK_BALANCE = "bei_bankbalance";
    private static final String BANK_BALANCE_SELECT_FIELDS = String.join((CharSequence)",", "company", "currency", "amount", "valibalance", "to_char(bizdate,'yyyy-MM-dd') as bizdate", "to_char(enddate,'yyyy-MM-dd') as enddate", "currency.name", "currency.sign", "currency.amtprecision", "accountbank.bank.name", "company.name", "lstbalance", "bank", "accountbank", "datasource", "modifytime");
    private static final Log logger = LogFactory.getLog(BankDailyBalanceQueryHelper.class);
    private static final String EXRATE_TABLE_CURRENCY_ID = "tarcurrency";
    private static final String EXRATE_TABLE_EXCHG_RATE = "rate";
    private static final String MULTIPLY = "*";
    private static final String ORDER_BY_FIELD = "order_field";
    private static final String ORDER_BY_SUM_FIELD = "sum_level_field";
    private static final String ORDER_BY_TOTAL_FIELD = "total_field";
    private static final Long DEFAULTORGVIEWID = 8L;

    public static DataSet query(ReportQueryParam reportQueryParam) {
        Map<String, Object> transQueryParam = BankDailyBalanceQueryHelper.transQueryParam(reportQueryParam);
        List<Long> orgIdList = BankDailyBalanceQueryHelper.getQueryOrgIds(reportQueryParam, CONDITION_COMPANY, CONDITION_ORGVIEW);
        if (EmptyUtil.isEmpty(orgIdList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8d44\u91d1\u7ec4\u7ec7\u6743\u9650\u3002", (String)"BankDailyBalanceListDataPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]));
        }
        transQueryParam.put("orgIdList", orgIdList);
        return BankDailyBalanceQueryHelper.query(transQueryParam);
    }

    public static DataSet query(Map<String, Object> transQueryParam) {
        return BankDailyBalanceQueryHelper.query(transQueryParam, true);
    }

    public static DataSet query(Map<String, Object> transQueryParam, boolean isAddTotal) {
        DataSet bankAccountDataSet = null;
        DataSet bankDailyBalanceDataSet = null;
        DataSet exratetableDataSet = null;
        try {
            QFilter qFilter = BankDailyBalanceQueryHelper.getQFilter(transQueryParam);
            bankAccountDataSet = BankDailyBalanceQueryHelper.getBankAccountDataSet(transQueryParam);
            bankDailyBalanceDataSet = BankDailyBalanceQueryHelper.getBankDailyBalanceDataSet(qFilter, transQueryParam);
            exratetableDataSet = BankDailyBalanceQueryHelper.getExratetableDataSet(transQueryParam);
            DataSet finish = bankDailyBalanceDataSet.leftJoin(exratetableDataSet).on("currency", EXRATE_TABLE_CURRENCY_ID).select(BankDailyBalanceQueryHelper.getSelectFields(bankDailyBalanceDataSet, new String[0]).split(","), BankDailyBalanceQueryHelper.getSelectFields(exratetableDataSet, new String[0]).split(",")).finish();
            String currencyUnit = (String)transQueryParam.get(CONDITION_CURRENCY_UNIT);
            finish = BankDailyBalanceQueryHelper.addFieldForDataSet(finish, currencyUnit, transQueryParam);
            String selectFields = BankDailyBalanceQueryHelper.getSelectFields(finish, new String[0]);
            DataSet dataSet = finish.join(bankAccountDataSet, JoinType.INNER).on("accountbank", "id").select(selectFields.split(","), BankDailyBalanceQueryHelper.getSelectFields(bankAccountDataSet, new String[0]).split(",")).finish();
            dataSet = BankDailyBalanceQueryHelper.addOrderByField(dataSet, "1", "2", "1");
            dataSet = dataSet.select(BankDailyBalanceQueryHelper.getSelectFields(dataSet, new String[0]) + "," + SELECT_FIELD_BANK_COMPANY_NAME + " as " + COMPANY_NAME_ORDER_BY);
            if (isAddTotal) {
                dataSet = BankDailyBalanceQueryHelper.addSubtotal(dataSet);
                dataSet = BankDailyBalanceQueryHelper.addTotal(dataSet);
            }
            logger.info("\u522b\u540d\u8f6c\u6362\u5e76\u6392\u5e8f\u8fd4\u56de\u7ed3\u679c\u96c6");
            DataSet resultDataSet = dataSet.select(BankDailyBalanceQueryHelper.getSelectFieldsConverAlias(dataSet, new String[0])).orderBy(new String[]{ORDER_BY_TOTAL_FIELD, "companynameorderby  ASC", ORDER_BY_SUM_FIELD, BankDailyBalanceQueryHelper.getFieldAlias(SELECT_FIELD_BANK_COMPANY_NAME) + "  ASC", ORDER_BY_FIELD, BankDailyBalanceQueryHelper.getFieldAlias("openorg.name") + " ASC", BankDailyBalanceQueryHelper.getFieldAlias(SELECT_FIELD_BANK_BANK_NAME) + " ASC", BankDailyBalanceQueryHelper.getFieldAlias(SELECT_FIELD_BANK_CURRENCY_NAME) + " ASC"});
            logger.info("\u5173\u95edDataSet");
            BankDailyBalanceQueryHelper.closeDataSet(bankAccountDataSet, bankDailyBalanceDataSet, exratetableDataSet, finish, dataSet);
            return resultDataSet;
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            BankDailyBalanceQueryHelper.closeDataSet(bankAccountDataSet, bankDailyBalanceDataSet, exratetableDataSet);
            throw e;
        }
    }

    private static DataSet addTotal(DataSet dataSet) {
        logger.info("\u6dfb\u52a0\u603b\u8ba1\u884c");
        GroupbyDataSet groupbyDataSet = dataSet.filter("sum_level_field=2").groupBy(new String[]{SELECT_FIELD_BANK_REPORT_CURRENCY});
        DataSet totalDataSet = groupbyDataSet.sum(SHOW_REPORT_AMOUNT).sum(SHOW_REPORT_VALIBALANCE).sum(SHOW_REPORT_LSTBALANCE).finish();
        totalDataSet = BankDailyBalanceQueryHelper.addOrderByField(totalDataSet, "3", "1", "2");
        totalDataSet = BankDailyBalanceQueryHelper.addFieldSameEmptyFromTarget(totalDataSet, dataSet, true);
        DataSet union = dataSet.union(totalDataSet);
        BankDailyBalanceQueryHelper.closeDataSet(dataSet, totalDataSet);
        return union;
    }

    private static void closeDataSet(DataSet ... dataSets) {
        if (Objects.isNull(dataSets)) {
            return;
        }
        for (DataSet dataSet : dataSets) {
            if (Objects.isNull(dataSet)) continue;
            dataSet.close();
        }
    }

    private static DataSet addSubtotal(DataSet dataSet) {
        logger.info("\u6dfb\u52a0\u5c0f\u8ba1\u884c");
        String companyName = SELECT_FIELD_BANK_COMPANY_NAME;
        String reportCurrency = SELECT_FIELD_BANK_REPORT_CURRENCY;
        GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy(new String[]{"company", companyName, COMPANY_NAME_ORDER_BY, reportCurrency});
        DataSet sumDataSet = groupbyDataSet.sum(SHOW_REPORT_AMOUNT).sum(SHOW_REPORT_VALIBALANCE).sum(SHOW_REPORT_LSTBALANCE).finish().select(new String[]{"company", companyName, COMPANY_NAME_ORDER_BY, reportCurrency, SHOW_REPORT_AMOUNT, SHOW_REPORT_VALIBALANCE, SHOW_REPORT_LSTBALANCE});
        sumDataSet = BankDailyBalanceQueryHelper.addOrderByField(sumDataSet, "2", "1", "1");
        sumDataSet = BankDailyBalanceQueryHelper.addFieldSameEmptyFromTarget(sumDataSet, dataSet, false);
        DataSet union = dataSet.union(sumDataSet);
        BankDailyBalanceQueryHelper.closeDataSet(dataSet, sumDataSet);
        return union;
    }

    private static DataSet addFieldSameEmptyFromTarget(DataSet sumDataSet, DataSet dataSet, boolean isTotal) {
        Field[] fields = dataSet.getRowMeta().getFields();
        Field[] sumFields = sumDataSet.getRowMeta().getFields();
        Set fieldNameSet = Arrays.stream(sumFields).map(Field::getName).collect(Collectors.toSet());
        List stringList = Arrays.stream(fields).map(Field::getName).map(name -> SELECT_FIELD_BANK_COMPANY_NAME.equals(name) ? BankDailyBalanceQueryHelper.getTotalName(name, isTotal) : (fieldNameSet.contains(name) ? name : "NULL AS " + name)).collect(Collectors.toList());
        return sumDataSet.select(String.join((CharSequence)",", stringList));
    }

    private static String getTotalName(String name, boolean isTotal) {
        if (isTotal) {
            return String.format(ResManager.loadKDString((String)"'\u603b\u8ba1' as %s", (String)"BankDailyBalanceQueryHelper_1", (String)"tmc-bei-report", (Object[])new Object[0]), name);
        }
        return String.format(ResManager.loadKDString((String)"CONCAT(%1$s ,'\u5c0f\u8ba1') as %2$s", (String)"BankDailyBalanceQueryHelper_0", (String)"tmc-bei-report", (Object[])new Object[0]), name, name);
    }

    private static DataSet addOrderByField(DataSet dataSet, String sumLevel, String order, String totalOrder) {
        return dataSet.addField(sumLevel, ORDER_BY_SUM_FIELD).addField(order, ORDER_BY_FIELD).addField(totalOrder, ORDER_BY_TOTAL_FIELD);
    }

    private static String getSelectFieldAlias(String name) {
        return BankDailyBalanceQueryHelper.getSelectFieldAlias(name, true);
    }

    private static String getSelectFieldAlias(String name, boolean isSelect) {
        if (!name.contains(ALIAS_SEPARATOR)) {
            return name;
        }
        String alias = name.replace(ALIAS_SEPARATOR, "");
        return isSelect ? name + " " + alias : alias;
    }

    private static String getFieldAlias(String name) {
        return BankDailyBalanceQueryHelper.getSelectFieldAlias(name, false);
    }

    private static DataSet addFieldForDataSet(DataSet dataSet, String currencyUnit, Map<String, Object> paramMap) {
        String unit = (String)paramMap.get(CONDITION_CURRENCY_UNIT);
        if (EmptyUtil.isEmpty((String)unit)) {
            unit = "1";
        }
        String currencyRadix = "/" + unit;
        StringBuilder sb = new StringBuilder();
        logger.info("\u6dfb\u52a0\u62a5\u544a\u5e01\u663e\u793a\uff0c\u5e76\u91cd\u65b0\u6309\u8ba1\u91cf\u5355\u4f4d\u8ba1\u7b97\u539f\u5e01\u62a5\u544a\u5e01,\u8ba1\u91cf\u5355\u4f4d\uff1a{},\u8ba1\u7b97\u57fa\u6570:{}", (Object)currencyUnit, (Object)currencyRadix);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, "amount", currencyRadix), SHOW_ORIGINAL_AMOUNT);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, BankDailyBalanceQueryHelper.getField(sb, "amount", MULTIPLY, EXRATE_TABLE_EXCHG_RATE), currencyRadix), SHOW_REPORT_AMOUNT);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, "valibalance", currencyRadix), SHOW_ORIGINAL_VALIBALANCE);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, BankDailyBalanceQueryHelper.getField(sb, "valibalance", MULTIPLY, EXRATE_TABLE_EXCHG_RATE), currencyRadix), SHOW_REPORT_VALIBALANCE);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, "lstbalance", currencyRadix), SHOW_ORIGINAL_LSTBALANCE);
        dataSet = dataSet.addField(BankDailyBalanceQueryHelper.getField(sb, BankDailyBalanceQueryHelper.getField(sb, "lstbalance", MULTIPLY, EXRATE_TABLE_EXCHG_RATE), currencyRadix), SHOW_REPORT_LSTBALANCE);
        return dataSet;
    }

    private static String getSelectFields(DataSet dataSet, String ... filters) {
        return BankDailyBalanceQueryHelper.getSelectFieldsIfConverAlias(dataSet, false, filters);
    }

    private static String getSelectFieldsIfConverAlias(DataSet dataSet, boolean converAlias, String ... filters) {
        Field[] fields = dataSet.getRowMeta().getFields();
        Set<Object> filterSet = Objects.isNull(filters) ? new HashSet(2) : Arrays.stream(filters).collect(Collectors.toSet());
        List collect = Arrays.stream(fields).map(Field::getName).filter(name -> !filterSet.contains(name)).map(name -> converAlias ? BankDailyBalanceQueryHelper.getSelectFieldAlias(name) : name).collect(Collectors.toList());
        return String.join((CharSequence)",", collect);
    }

    private static String getSelectFieldsConverAlias(DataSet dataSet, String ... filters) {
        return BankDailyBalanceQueryHelper.getSelectFieldsIfConverAlias(dataSet, true, filters);
    }

    private static String getField(StringBuilder sb, String field, String suffix) {
        return BankDailyBalanceQueryHelper.getField(sb, field, suffix, "");
    }

    private static String getField(StringBuilder sb, String field, String operator, String fieldSecond) {
        sb.delete(0, sb.length());
        return sb.append(field).append(operator).append(fieldSecond).toString();
    }

    private static DataSet getExratetableDataSet(Map<String, Object> transQueryParam) {
        DynamicObject reportCurrency = (DynamicObject)transQueryParam.get(CONDITION_REPORT_CURRENCY);
        Long reportCurrencyId = Objects.isNull(reportCurrency) ? Long.valueOf(0L) : (Long)reportCurrency.getPkValue();
        logger.info("\u62a5\u544a\u5e01id:{}", (Object)reportCurrencyId);
        HashSet<Long> currencyIdSet = new HashSet<Long>(16);
        Object currency = transQueryParam.get(CONDITION_CURRENCY);
        if (EmptyUtil.isNoEmpty((Object)currency)) {
            currencyIdSet.addAll(BankDailyBalanceQueryHelper.getQueryIds(currency));
        } else {
            QFilter filter = BankDailyBalanceQueryHelper.getFilterByType(transQueryParam, FILTER_TYPE_BANK);
            QFilter accountFilter = BankDailyBalanceQueryHelper.getAccountFilter(filter);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"AccountBank", (String)FILTER_TYPE_BANK, (String)"currency.fbasedataid", (QFilter[])new QFilter[]{accountFilter}, null);
            while (ds.hasNext()) {
                Long currencyId = ds.next().getLong("currency.fbasedataid");
                if (!EmptyUtil.isNoEmpty((Long)currencyId)) continue;
                currencyIdSet.add(currencyId);
            }
            ds.close();
        }
        Date bizDate = EmptyUtil.isEmpty((Object)transQueryParam.get(DATE_RANGE_FLAG)) ? (Date)transQueryParam.get(CONDITION_DATE) : DateUtils.getDataFormat((Date)((Date)transQueryParam.get(CONDITION_END_DATE)), (boolean)true);
        return TmcBusinessBaseHelper.getExChangeDataSet(new ArrayList(currencyIdSet), (Long)reportCurrencyId, (long)RequestContext.get().getOrgId(), (Date)bizDate, (boolean)false).addField(reportCurrencyId.toString(), SELECT_FIELD_BANK_REPORT_CURRENCY);
    }

    private static QFilter getQFilter(Map<String, Object> transQueryParam) {
        Object currency;
        Object accounts;
        QFilter qFilter;
        boolean singleDateFlag = EmptyUtil.isEmpty((Object)transQueryParam.get(DATE_RANGE_FLAG));
        if (singleDateFlag) {
            Date bizDate = (Date)transQueryParam.get(CONDITION_DATE);
            qFilter = new QFilter("bizdate", "<=", (Object)bizDate);
            qFilter.and("enddate", ">", (Object)bizDate);
        } else {
            Date startDate = (Date)transQueryParam.get(CONDITION_START_DATE);
            Date endDate = (Date)transQueryParam.get(CONDITION_END_DATE);
            qFilter = new QFilter("enddate", ">", (Object)startDate);
            qFilter.and("bizdate", "<=", (Object)endDate);
        }
        List orgIds = (List)transQueryParam.get("orgIdList");
        if (EmptyUtil.isNoEmpty((Object)orgIds) && !orgIds.isEmpty()) {
            qFilter.and("company", "in", (Object)orgIds);
        } else {
            Object orgs = transQueryParam.get(CONDITION_COMPANY);
            if (EmptyUtil.isNoEmpty((Object)orgs)) {
                qFilter.and("company", "in", BankDailyBalanceQueryHelper.getQueryIds(orgs));
            }
        }
        Object banks = transQueryParam.get(CONDITION_BANK);
        if (EmptyUtil.isNoEmpty((Object)banks)) {
            List<Long> bankIds = BankDailyBalanceQueryHelper.getQueryIds(banks);
            qFilter.and("bank", "in", bankIds);
        }
        if (EmptyUtil.isNoEmpty((Object)(accounts = transQueryParam.get(CONDITION_BANK_ACCOUNT_NUMBER)))) {
            List<Long> accountIds = BankDailyBalanceQueryHelper.getQueryIds(accounts);
            qFilter.and("accountbank", "in", accountIds);
        }
        if (EmptyUtil.isNoEmpty((Object)(currency = transQueryParam.get(CONDITION_CURRENCY)))) {
            List<Long> currencyIds = BankDailyBalanceQueryHelper.getQueryIds(currency);
            qFilter.and("currency", "in", currencyIds);
        }
        return qFilter;
    }

    private static DataSet getBankDailyBalanceDataSet(QFilter qFilter, Map<String, Object> transQueryParam) {
        String expr;
        boolean singleDateFlag = EmptyUtil.isEmpty((Object)transQueryParam.get(DATE_RANGE_FLAG));
        logger.info("\u5f00\u59cb\u83b7\u53d6\u8d26\u6237\u5f53\u65e5\u4f59\u989dDataSet,\u8fc7\u6ee4\u6761\u4ef6:{} ", (Object)qFilter);
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)"AccountBank", (String)FILTER_TYPE_BANK_BALANCE, (String)BANK_BALANCE_SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter}, null);
        if (singleDateFlag) {
            String searchDate = "";
            try {
                Date date = (Date)transQueryParam.get(CONDITION_DATE);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                searchDate = simpleDateFormat.format(date);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            expr = "'" + searchDate + "'";
        } else {
            String startDate = DateUtils.formatString((Date)((Date)transQueryParam.get(CONDITION_START_DATE)), (String)"yyyy-MM-dd");
            expr = "case when bizdate<'" + startDate + "' then '" + startDate + "' else bizdate end";
        }
        DataSet filter = balanceDataSet.addField(expr, SHOW_SERACH_DATE);
        DataSet[] splitDataSet = filter.splitByFilter(new String[]{"lstbalance is null"}, true);
        DataSet lstBalanceNull = BankDailyBalanceQueryHelper.updateLastBalance(splitDataSet[0]);
        DataSet allDs = lstBalanceNull.union(splitDataSet[1]);
        BankDailyBalanceQueryHelper.closeDataSet(balanceDataSet, filter);
        return allDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSet updateLastBalance(DataSet lstBalanceNull) {
        ArrayList<Object[]> rowDataList = new ArrayList<Object[]>(1024);
        RowMeta rowMeta = lstBalanceNull.getRowMeta();
        try {
            for (Row row : lstBalanceNull) {
                Date date = row.getDate("bizdate");
                Date searchDate = row.getDate(SHOW_SERACH_DATE);
                if (DateUtils.formatString((Date)date, (String)"yyyyMMdd").equals(DateUtils.formatString((Date)searchDate, (String)"yyyyMMdd"))) {
                    Long company = row.getLong("company");
                    Long accountBank = row.getLong("accountbank");
                    Long currencyId = row.getLong("currency");
                    QFilter balanceFilter = new QFilter("company", "=", (Object)company);
                    balanceFilter.and("accountbank", "=", (Object)accountBank);
                    balanceFilter.and("currency", "=", (Object)currencyId);
                    balanceFilter.and("bizdate", "=", (Object)DateUtils.getLastDay((Date)date, (int)1));
                    DataSet balanceQuery = QueryServiceHelper.queryDataSet((String)"BalanceQuery", (String)FILTER_TYPE_BANK_BALANCE, (String)("company,currency,accountbank,'" + DateUtils.formatString((Date)date, (String)"yyyy-MM-dd") + "' as bizdate,amount as newlstbalance"), (QFilter[])balanceFilter.toArray(), null);
                    if (balanceQuery.hasNext()) {
                        BigDecimal lastBalance = balanceQuery.next().getBigDecimal("newlstbalance");
                        rowDataList.add(BankDailyBalanceQueryHelper.updateLastBalance(row, rowMeta, lastBalance));
                        continue;
                    }
                    rowDataList.add(BankDailyBalanceQueryHelper.updateLastBalance(row, rowMeta, null));
                    continue;
                }
                BigDecimal lastBalance = row.getBigDecimal("amount");
                rowDataList.add(BankDailyBalanceQueryHelper.updateLastBalance(row, rowMeta, lastBalance));
            }
        }
        catch (Throwable throwable) {
            BankDailyBalanceQueryHelper.closeDataSet(lstBalanceNull);
            throw throwable;
        }
        BankDailyBalanceQueryHelper.closeDataSet(lstBalanceNull);
        return Algo.create((String)"updateLastBalance").createDataSet(new Input[]{new CollectionInput(rowMeta, rowDataList)});
    }

    private static Object[] updateLastBalance(Row row, RowMeta rowMeta, BigDecimal lastBalance) {
        String[] fieldNames = rowMeta.getFieldNames();
        Object[] result = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            result[i] = "lstbalance".equals(fieldName) ? lastBalance : row.get(fieldName);
        }
        return result;
    }

    private static List<Long> getQueryIds(Object object) {
        if (object instanceof DynamicObjectCollection) {
            return ((DynamicObjectCollection)object).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        }
        return (List)object;
    }

    private static DataSet getBankAccountDataSet(Map<String, Object> transQueryParam) {
        QFilter qFilter = BankDailyBalanceQueryHelper.getFilterByType(transQueryParam, FILTER_TYPE_BANK);
        boolean singleDateFlag = EmptyUtil.isEmpty((Object)transQueryParam.get(DATE_RANGE_FLAG));
        if (singleDateFlag) {
            Date bizDate = (Date)transQueryParam.get(CONDITION_DATE);
            QFilter qFilterCloseDate = new QFilter("closedate", ">=", (Object)bizDate).or("closedate", "is null", null);
            QFilter qFilterOpenDate = new QFilter("opendate", "<=", (Object)DateUtils.getDataFormat((Date)bizDate, (boolean)false));
            QFilter qFilterDate = qFilterCloseDate.and(qFilterOpenDate);
            qFilter = qFilter != null ? qFilter.and(qFilterDate) : qFilterDate;
        } else {
            Date startDate = (Date)transQueryParam.get(CONDITION_START_DATE);
            Date endDate = (Date)transQueryParam.get(CONDITION_END_DATE);
            QFilter qFilterCloseDate = new QFilter("closedate", ">=", (Object)startDate).or("closedate", "is null", null);
            QFilter qFilterOpenDate = new QFilter("opendate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
            QFilter qFilterDate = qFilterCloseDate.and(qFilterOpenDate);
            qFilter = qFilter != null ? qFilter.and(qFilterDate) : qFilterDate;
        }
        logger.info("\u5f00\u59cb\u83b7\u53d6\u8d26\u6237DataSet,\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)qFilter);
        QFilter accountFilter = BankDailyBalanceQueryHelper.getAccountFilter(qFilter);
        String selectFields = "org.name,id,name,number,acctname,org.id,openorg,openorg.id,openorg.name,acctproperty,acctproperty.name,accttype,acctstyle,bankaccountnumber accountnumber" + BankDailyBalanceQueryHelper.getAccountFields();
        return QueryServiceHelper.queryDataSet((String)"AccountBank", (String)FILTER_TYPE_BANK, (String)selectFields, (QFilter[])new QFilter[]{accountFilter}, null);
    }

    public static QFilter getAccountFilter(QFilter qFilter) {
        PluginProxy pluginProxy = PluginProxy.create(IBalanceReportInterface.class, (String)"kd.sdk.tmc.bei.extpoint.balance.IBalanceReportInterface.getAccountFilter");
        List lists = pluginProxy.callReplace(p -> p.getAccountFilter(qFilter));
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (QFilter)lists.get(0);
        }
        return qFilter;
    }

    private static String getAccountFields() {
        PluginProxy pluginProxy = PluginProxy.create(IBalanceReportInterface.class, (String)"kd.sdk.tmc.bei.extpoint.balance.IBalanceReportInterface.getAccountFields");
        List lists = pluginProxy.callReplace(IBalanceReportInterface::getAccountFields);
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty((String)((String)lists.get(0)))) {
            return "," + (String)lists.get(0);
        }
        return "";
    }

    private static QFilter getFilterByType(Map<String, Object> transQueryParam, String filterType) {
        Map<String, String> dataBaseColumnMap = CONDITION_FILED_MAP_DATABASE_COLUMN.get(filterType);
        if (FILTER_TYPE_BANK.equals(filterType)) {
            return BankDailyBalanceQueryHelper.doGetFilterByType(BANK_CONDITION_SET, transQueryParam, dataBaseColumnMap);
        }
        return null;
    }

    private static QFilter doGetFilterByType(Set<String> conditionKeySet, Map<String, Object> transQueryParam, Map<String, String> dataBaseColumnMap) {
        QFilter qFilter = null;
        for (String key : conditionKeySet) {
            Object object = CONDITION_COMPANY.equals(key) ? transQueryParam.get("orgIdList") : transQueryParam.get(key);
            if (Objects.isNull(object)) continue;
            String columnName = BankDailyBalanceQueryHelper.getDataBaseColumn(dataBaseColumnMap, key);
            String qFilterOperator = BankDailyBalanceQueryHelper.getQfilterOperator(key);
            QFilter qFilterByValue = BankDailyBalanceQueryHelper.getQFilterByValue(columnName, qFilterOperator, object);
            BankDailyBalanceQueryHelper.andConditionNonNull(key, columnName, qFilterByValue);
            qFilter = BankDailyBalanceQueryHelper.getFirstOrMergeQFilter(qFilter, qFilterByValue);
        }
        return qFilter;
    }

    private static void andConditionNonNull(String key, String columnName, QFilter qFilterByValue) {
        Class valueClass = FILTER_FIELD_FILTER_NULL.get(key);
        if (Objects.isNull(valueClass)) {
            return;
        }
        if (String.class.isAssignableFrom(valueClass)) {
            qFilterByValue.and(new QFilter(columnName, "!=", (Object)""));
        } else if (Long.class.isAssignableFrom(valueClass)) {
            qFilterByValue.and(new QFilter(columnName, "!=", (Object)0L));
        } else if (Integer.class.isAssignableFrom(valueClass)) {
            qFilterByValue.and(new QFilter(columnName, "!=", (Object)0));
        } else if (Date.class.isAssignableFrom(valueClass)) {
            qFilterByValue.and(new QFilter(columnName, "!=", null));
        }
    }

    private static String getQfilterOperator(String key) {
        return FILTER_FIELD_OPERATER.get(key);
    }

    private static String getDataBaseColumn(Map<String, String> dataBaseColumnMap, String key) {
        String columnName;
        String string = columnName = Objects.isNull(dataBaseColumnMap) ? "" : dataBaseColumnMap.get(key);
        if (StringUtils.isBlank((CharSequence)columnName)) {
            if (key.contains(FILTER_SEPARATOR)) {
                return key.substring(FILTER_SEPARATOR.length());
            }
            return key;
        }
        return columnName;
    }

    private static QFilter getQFilterByValue(String columnName, String qfilterOperater, Object object) {
        Object value;
        Class<?> valueClass = object.getClass();
        if (DynamicObjectCollection.class.isAssignableFrom(valueClass)) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)object;
            return new QFilter(columnName, BankDailyBalanceQueryHelper.getOperatorIfCustom("in", qfilterOperater), (Object)dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).toArray());
        }
        if (DynamicObject.class.isAssignableFrom(valueClass)) {
            return new QFilter(columnName, BankDailyBalanceQueryHelper.getOperatorIfCustom("=", qfilterOperater), ((DynamicObject)object).getPkValue());
        }
        if (String.class.isAssignableFrom(valueClass) && ((String)(value = (String)object)).contains(",") && (value = BankDailyBalanceQueryHelper.trimString((String)value, ",")) != null && ((String)value).contains(",")) {
            return new QFilter(columnName, BankDailyBalanceQueryHelper.getOperatorIfCustom("in", qfilterOperater), (Object)((String)value).split(","));
        }
        if (ArrayList.class.isAssignableFrom(valueClass) && EmptyUtil.isNoEmpty((Object)(value = (ArrayList)object)) && value.size() > 0) {
            return new QFilter(columnName, BankDailyBalanceQueryHelper.getOperatorIfCustom("in", qfilterOperater), value);
        }
        return new QFilter(columnName, BankDailyBalanceQueryHelper.getOperatorIfCustom("=", qfilterOperater), object);
    }

    private static String getOperatorIfCustom(String defaultOperator, String qfilterOperator) {
        return StringUtils.isBlank((CharSequence)qfilterOperator) ? defaultOperator : qfilterOperator;
    }

    private static String trimString(String value, String deleteStr) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (value.startsWith(deleteStr)) {
            return value.substring(deleteStr.length());
        }
        if (value.endsWith(deleteStr)) {
            return value.substring(0, value.length() - deleteStr.length());
        }
        return value;
    }

    private static QFilter getFirstOrMergeQFilter(QFilter first, QFilter qFilter) {
        return Objects.isNull(first) ? qFilter : first.and(qFilter);
    }

    private static Map<String, Object> transQueryParam(ReportQueryParam param) {
        List filterItems = param.getFilter().getFilterItems();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(filterItems.size());
        for (FilterItemInfo filterItem : filterItems) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    public static List<Long> getQueryOrgIds(ReportQueryParam queryParam, String orgField, String orgViewField) {
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem(orgViewField).getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem(orgField).getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                DynamicObjectCollection bank = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(CONDITION_BANK).getValue();
                DynamicObjectCollection bankAccountNumber = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(CONDITION_BANK_ACCOUNT_NUMBER).getValue();
                DynamicObjectCollection currency = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(CONDITION_CURRENCY).getValue();
                List AuthOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
                orgIds = bank == null && bankAccountNumber == null && currency == null ? AuthOrgId : BankDailyBalanceQueryHelper.getQueryParamOrgId(bank, bankAccountNumber, currency, (List<Long>)AuthOrgId);
            }
            if (queryParam.getFilter().containProp("filter_isincludelower") && ((Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue()).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }

    public static List<Long> getQueryOrgIds(Map<String, Object> queryParam) {
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String queryWay = (String)queryParam.get("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.get(CONDITION_ORGVIEW);
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.get(CONDITION_COMPANY);
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)"bei", (String)"bei_report_balance_qing", (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.get(CONDITION_COMPANY);
            if (EmptyUtil.isEmpty(orgIds)) {
                List bank = (List)queryParam.get(CONDITION_BANK);
                List bankAccountNumber = (List)queryParam.get(CONDITION_BANK_ACCOUNT_NUMBER);
                List currency = (List)queryParam.get(CONDITION_CURRENCY);
                List AuthOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)"bei", (String)"bei_report_balance_qing", (String)"47150e89000000ac");
                orgIds = bank == null && bankAccountNumber == null && currency == null ? AuthOrgId : BankDailyBalanceQueryHelper.getQueryParamOrgId(bank, bankAccountNumber, currency, (List<Long>)AuthOrgId);
            }
        }
        return orgIds;
    }

    private static List<Long> getQueryParamOrgId(DynamicObjectCollection bank, DynamicObjectCollection bankAccountNumber, DynamicObjectCollection currency, List<Long> AuthOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        QFilter qFilter = null;
        if (bank != null) {
            Set bankId = bank.stream().map(b -> b.getLong("id")).collect(Collectors.toSet());
            qFilter = new QFilter("bank", "in", bankId);
        }
        if (bankAccountNumber != null) {
            Set bankAccountId = bankAccountNumber.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
            QFilter acctQFilter = new QFilter("id", "in", bankAccountId);
            QFilter qFilter2 = qFilter = qFilter == null ? acctQFilter : qFilter.and(acctQFilter);
        }
        if (currency != null) {
            Set currencyId = currency.stream().map(c -> c.getLong("id")).collect(Collectors.toSet());
            QFilter currencyQFilter = new QFilter("currency.fbasedataid", "in", currencyId);
            QFilter qFilter3 = qFilter = qFilter == null ? currencyQFilter : qFilter.and(currencyQFilter);
        }
        if (qFilter != null) {
            DynamicObjectCollection openOrg = QueryServiceHelper.query((String)FILTER_TYPE_BANK, (String)"company", (QFilter[])new QFilter[]{qFilter});
            Set orgIdSet = openOrg.stream().map(o -> o.getLong("company")).collect(Collectors.toSet());
            orgIdSet.retainAll(AuthOrgId);
            orgIds.addAll(orgIdSet);
        }
        return orgIds;
    }

    private static List<Long> getQueryParamOrgId(List<Long> bankId, List<Long> bankAccountId, List<Long> currencyId, List<Long> AuthOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        QFilter qFilter = null;
        if (bankId != null) {
            qFilter = new QFilter("bank", "in", bankId);
        }
        if (bankAccountId != null) {
            QFilter acctQFilter = new QFilter("id", "in", bankAccountId);
            QFilter qFilter2 = qFilter = qFilter == null ? acctQFilter : qFilter.and(acctQFilter);
        }
        if (currencyId != null) {
            QFilter currencyQFilter = new QFilter("currency.fbasedataid", "in", currencyId);
            QFilter qFilter3 = qFilter = qFilter == null ? currencyQFilter : qFilter.and(currencyQFilter);
        }
        if (qFilter != null) {
            DynamicObjectCollection openOrg = QueryServiceHelper.query((String)FILTER_TYPE_BANK, (String)"company", (QFilter[])new QFilter[]{qFilter});
            Set orgIdSet = openOrg.stream().map(o -> o.getLong("company")).collect(Collectors.toSet());
            orgIdSet.retainAll(AuthOrgId);
            orgIds.addAll(orgIdSet);
        }
        return orgIds;
    }
}

