/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.IFrame;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceQueryQingViewPlugin
extends AbstractReportFormPlugin {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object startDate = filterInfo.getValue("filter_startbizdate");
            if (startDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryQingViewPlugin_3", (String)"tmc-bei-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object endDate = filterInfo.getValue("filter_endbizdate");
            if (endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryQingViewPlugin_4", (String)"tmc-bei-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object reportcurrency = filterInfo.getValue("filter_statcurrency");
            if (reportcurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryQingViewPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        if ("filter_org".equals(pro) && (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_org")) || !oldValue.equals(newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
            return;
        }
        if ("filter_bank".equals(pro) && (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_bank")) || !oldValue.equals(newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject baseCurrency;
        DynamicObjectCollection queryFisBankRollOrg;
        super.afterCreateNewData(e);
        Long fisBankRollOrg = this.getFisBankRollOrg();
        Object[] arrObj = new Object[]{};
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            arrObj = new Object[]{fisBankRollOrg};
            this.getModel().setValue("filter_org", (Object)new Object[]{fisBankRollOrg});
        }
        if (!EmptyUtil.isEmpty((Object[])arrObj) && (baseCurrency = TmcBusinessBaseHelper.getStandardCurrency((long)((Long)arrObj[0]))) != null) {
            this.getModel().setValue("filter_statcurrency", baseCurrency.getPkValue());
        }
        Date now = new Date();
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getView().getControl("filter_bizdaterange");
        dateRangeEdit.setMaxDate(now);
        this.getModel().setValue("filter_startbizdate", (Object)now);
        this.getModel().setValue("filter_endbizdate", (Object)now);
    }

    public Long getFisBankRollOrg() {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && OrgHelper.hasPermission((String)"bei", (long)userId, (long)currentOrg.getLong("id"), (String)"bei_report_balance_qing", (String)"47150e89000000ac")) {
            return currentOrg.getLong("id");
        }
        List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)userId, (String)"bei_report_balance_qing", (String)"47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initAccountF7();
    }

    private void initAccountF7() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("filter_bankaccountnumber");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List<Long> list;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            DynamicObjectCollection bankColl = (DynamicObjectCollection)this.getModel().getValue("filter_bank");
            QFilter allFilters = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgColl)) {
                list = this.getIdList(orgColl);
                allFilters = new QFilter("company.id", "in", list);
            } else {
                QFilter filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)"bei", (String)"bei_report_balance_qing", (String)"47150e89000000ac", (String)"company.id");
                if (filter != null) {
                    allFilters = filter;
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankColl)) {
                list = this.getIdList(bankColl);
                QFilter qFilterOfBank = new QFilter("bank.id", "in", list);
                allFilters = null != allFilters ? allFilters.and(qFilterOfBank) : qFilterOfBank;
            }
            if (null != allFilters) {
                showParameter.getListFilterParameter().setFilter(allFilters);
            }
        });
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (DynamicObject dynamicObject : coll) {
            idList.add((Long)dynamicObject.getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IFrameMessage message = new IFrameMessage();
        message.setType("reExtractData");
        IFrame frame = (IFrame)this.getView().getControl("qinganalysisap");
        frame.postMessage(message);
    }
}

