/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDailyBalanceFormListPlugin
extends AbstractReportFormPlugin {
    private static final String RPTENTITY = "bei_report_dailybalance";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object date;
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null && (date = filterInfo.getValue("filter_bizdate")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryQingViewPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initAccountF7();
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        String filterKey = "filter_org";
        if (filterKey.equals(pro) && (EmptyUtil.isEmpty((Object)this.getModel().getValue(filterKey)) || !oldValue.equals(newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
            return;
        }
        if ("filter_bank".equals(pro) && (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_bank")) || !oldValue.equals(newValue))) {
            this.getModel().setValue("filter_bankaccountnumber", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        super.afterCreateNewData(e);
        Long fisBankRollOrg = this.getFisBankRollOrg();
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            this.getModel().setValue("filter_org", (Object)new Object[]{fisBankRollOrg});
        }
    }

    private void initAccountF7() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("filter_bankaccountnumber");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter allFilters;
            List<Long> list;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            DynamicObjectCollection bankColl = (DynamicObjectCollection)this.getModel().getValue("filter_bank");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgColl)) {
                list = this.getIdList(orgColl);
                allFilters = new QFilter("company.id", "in", list);
            } else {
                QFilter filter;
                allFilters = filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)"bei", (String)RPTENTITY, (String)"47150e89000000ac", (String)"company.id");
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankColl)) {
                list = this.getIdList(bankColl);
                QFilter qFilterOfBank = new QFilter("bank.id", "in", list);
                if (null != allFilters) {
                    allFilters = allFilters.and(qFilterOfBank);
                }
            }
            if (null != allFilters) {
                showParameter.getListFilterParameter().setFilter(allFilters);
            }
        });
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        for (DynamicObject dynamicObject : coll) {
            idList.add((Long)dynamicObject.getDynamicObject("fbasedataid").getPkValue());
        }
        return idList;
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        List authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId((Long)requestContext.getCurrUserId(), (String)RPTENTITY, (String)"47150e89000000ac");
        if (!authorizedBankOrgId.isEmpty()) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }
}

