/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.plugin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.report.helper.BankDailyBalanceQueryHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BeiBalanceQueryQingAnlsPlugin
extends AbstractFormPlugin
implements IQingDataProvider {
    private static Log log = LogFactory.getLog(BeiBalanceQueryQingAnlsPlugin.class);

    protected List<Object[]> getColumnItems() {
        boolean isFalse = false;
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"companyname", ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"BeiBalanceQueryQingAnlsPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"number", ResManager.loadKDString((String)"\u8d26\u53f7", (String)"BeiBalanceQueryQingAnlsPlugin_1", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"acctname", ResManager.loadKDString((String)"\u8d26\u6237\u540d\u79f0", (String)"BeiBalanceQueryQingAnlsPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"name", ResManager.loadKDString((String)"\u8d26\u6237\u7b80\u79f0", (String)"BeiBalanceQueryQingAnlsPlugin_3", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"accountbankbankname", ResManager.loadKDString((String)"\u5f00\u6237\u884c", (String)"BeiBalanceQueryQingAnlsPlugin_4", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"acctpropertyname", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"BeiBalanceQueryQingAnlsPlugin_5", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"BeiBalanceQueryQingAnlsPlugin_6", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u522b", (String)"BeiBalanceQueryQingAnlsPlugin_7", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BeiBalanceQueryQingAnlsPlugin_8", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"searchdate", ResManager.loadKDString((String)"\u65e5\u671f", (String)"BeiBalanceQueryQingAnlsPlugin_9", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"originalamount", ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d-\u539f\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_10", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"reportamount", ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d-\u62a5\u544a\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_11", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"originalvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d-\u539f\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_12", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"reportvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d-\u62a5\u544a\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_13", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"originallstbalance", ResManager.loadKDString((String)"\u6628\u65e5\u4f59\u989d-\u539f\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_14", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"reportlstbalance", ResManager.loadKDString((String)"\u6628\u65e5\u4f59\u989d-\u62a5\u544a\u5e01", (String)"BeiBalanceQueryQingAnlsPlugin_15", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), isFalse});
        field.add(new Object[]{"datasource", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90", (String)"BeiBalanceQueryQingAnlsPlugin_16", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"modifytime", ResManager.loadKDString((String)"\u6700\u540e\u66f4\u65b0\u65f6\u95f4", (String)"BeiBalanceQueryQingAnlsPlugin_17", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f", (String)"BeiBalanceQueryQingAnlsPlugin_18", (String)"tmc-bei-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), isFalse});
        return field;
    }

    public QingData getData(String qingPageId, int startRow, int limit) {
        log.info("startRow = ", (Object)startRow);
        log.info("limit = " + limit);
        if (startRow > 1) {
            return null;
        }
        QingData qingData = new QingData();
        qingData.setDataindex(this.createDataIndex());
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        HashMap<String, Object> filterParam = new HashMap<String, Object>();
        this.initOtherQueryParam(filterParam);
        filterParam.put("filter_statcurrency", EmptyUtil.isNoEmpty((Object)this.getModel().getValue("filter_statcurrency")) ? this.getModel().getValue("filter_statcurrency") : null);
        filterParam.put("filter_acctstyle", EmptyUtil.isNoEmpty((Object)this.getModel().getValue("filter_acctstyle")) ? this.getModel().getValue("filter_acctstyle") : null);
        filterParam.put("filter_accttype", EmptyUtil.isNoEmpty((Object)this.getModel().getValue("filter_accttype")) ? this.getModel().getValue("filter_accttype") : null);
        filterParam.put("filter_acctproperty", EmptyUtil.isNoEmpty((Object)this.getModel().getValue("filter_acctproperty")) ? this.getModel().getValue("filter_acctproperty") : null);
        filterParam.put("filter_currencyunit", EmptyUtil.isNoEmpty((Object)this.getModel().getValue("filter_currencyunit")) ? this.getModel().getValue("filter_currencyunit") : null);
        filterParam.put("dateRangeFlag", "1");
        List<Long> orgIdList = BankDailyBalanceQueryHelper.getQueryOrgIds(filterParam);
        filterParam.put("orgIdList", EmptyUtil.isNoEmpty(orgIdList) ? orgIdList : null);
        DataSet ds = this.getDataSet(filterParam);
        String startDate = DateUtils.formatString((Date)((Date)filterParam.get("filter_startbizdate")), (String)"yyyy-MM-dd");
        String endDate = DateUtils.formatString((Date)((Date)filterParam.get("filter_endbizdate")), (String)"yyyy-MM-dd");
        if (!EmptyUtil.isEmpty((Object)ds)) {
            String[] arr = ds.getRowMeta().getFieldNames();
            List<String> list = Arrays.asList(arr);
            for (Row rs : ds) {
                List<Object[]> cols = this.getColumnItems();
                Object[] row = new Object[cols.size()];
                for (int index = 0; index < cols.size(); ++index) {
                    Object[] column = cols.get(index);
                    String filed = (String)column[0];
                    if (!list.contains(filed)) continue;
                    Object value = rs.get(filed);
                    if ("acctstyle".equalsIgnoreCase(filed) && EmptyUtil.isNoEmpty((Object)value)) {
                        switch (value.toString()) {
                            case "basic": {
                                value = ResManager.loadKDString((String)"\u57fa\u672c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "normal": {
                                value = ResManager.loadKDString((String)"\u4e00\u822c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_1", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "temp": {
                                value = ResManager.loadKDString((String)"\u4e34\u65f6\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "spcl": {
                                value = ResManager.loadKDString((String)"\u4e13\u7528\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_3", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "fgn_curr": {
                                value = ResManager.loadKDString((String)"\u7ecf\u5e38\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_4", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "fng_fin": {
                                value = ResManager.loadKDString((String)"\u8d44\u672c\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_5", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                        }
                    }
                    if ("accttype".equalsIgnoreCase(filed) && EmptyUtil.isNoEmpty((Object)value)) {
                        switch (value.toString()) {
                            case "in_out": {
                                value = ResManager.loadKDString((String)"\u6536\u652f\u6237", (String)"AbstractBeiQingAnlsDataPlugin_6", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "in": {
                                value = ResManager.loadKDString((String)"\u6536\u5165\u6237", (String)"AbstractBeiQingAnlsDataPlugin_7", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "out": {
                                value = ResManager.loadKDString((String)"\u652f\u51fa\u6237", (String)"AbstractBeiQingAnlsDataPlugin_8", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                        }
                    }
                    if ("datasource".equalsIgnoreCase(filed) && EmptyUtil.isNoEmpty((Object)value)) {
                        switch (value.toString()) {
                            case "frombank": {
                                value = DataSourceEnum.FROMBANK.getName();
                                break;
                            }
                            case "import": {
                                value = DataSourceEnum.IMPORT.getName();
                                break;
                            }
                            case "receiptgen": {
                                value = DataSourceEnum.RECEIPTGEN.getName();
                                break;
                            }
                            case "fromifm": {
                                value = DataSourceEnum.FROMIFM.getName();
                                break;
                            }
                            case "fromschedule": {
                                value = DataSourceEnum.FROMSCHEDULE.getName();
                                break;
                            }
                            case "fromauto": {
                                value = DataSourceEnum.FROMAUTO.getName();
                                break;
                            }
                            case "hand": {
                                value = ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e", (String)"AbstractBeiQingAnlsDataPlugin_13", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                            case "update": {
                                value = ResManager.loadKDString((String)"\u5386\u53f2\u5347\u7ea7", (String)"AbstractBeiQingAnlsDataPlugin_14", (String)"tmc-bei-report", (Object[])new Object[0]);
                                break;
                            }
                        }
                    }
                    if ("searchdate".equalsIgnoreCase(filed) && EmptyUtil.isNoEmpty((Object)value) && value.toString().compareTo(startDate) < 0) {
                        value = startDate;
                    }
                    if ("enddate".equalsIgnoreCase(filed) && EmptyUtil.isNoEmpty((Object)value) && value.toString().compareTo(endDate) > 0) {
                        value = endDate;
                    }
                    row[index] = value;
                }
                data.add(row);
            }
        }
        qingData.setRows(data);
        return qingData;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        return BankDailyBalanceQueryHelper.query(paramMap);
    }

    protected Map<String, Integer> createDataIndex() {
        List<Object[]> list = this.getColumnItems();
        HashMap<String, Integer> index = new HashMap<String, Integer>(20);
        for (int k = 0; k < list.size(); ++k) {
            Object[] column = list.get(k);
            index.put((String)column[0], k);
        }
        return index;
    }

    public QingMeta getMeta(String qingPageId) {
        return this.createColumnItems();
    }

    private QingMeta createColumnItems() {
        QingMeta qingMeta = new QingMeta();
        qingMeta.addEntryEntity(this.createEntityMetas());
        for (Object[] column : this.getColumnItems()) {
            qingMeta.addColumn(this.createField((String)column[0], (String)column[1], (Integer)column[2], (Boolean)column[3]));
        }
        return qingMeta;
    }

    protected EntryEntity createEntityMetas() {
        EntryEntity entity = new EntryEntity();
        entity.setKey(this.getEntityName());
        entity.setName(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d\u62a5\u8868\u67e5\u8be2\uff08\u8f7b\u5206\u6790\uff09", (String)"AbstractBeiQingAnlsDataPlugin_12", (String)"tmc-bei-report", (Object[])new Object[0])));
        entity.setPkFieldName(this.getFieldPK());
        return entity;
    }

    protected String getEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    private Field createField(String key, String name, int fieldType, boolean hide) {
        Field field = new Field();
        field.setEntity(this.getEntityName());
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setFieldType(fieldType);
        field.setHide(hide);
        return field;
    }

    protected String getFieldPK() {
        return "id";
    }

    public String getFilterParameter() {
        return this.getPageCache().get("qFilter");
    }

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put("qFilter", filterParameter);
    }

    protected void initOtherQueryParam(Map<String, Object> paramMap) {
        Object filter_company;
        String filter_queryWay = (String)this.getModel().getValue("filter_queryway");
        paramMap.put("filter_queryway", filter_queryWay);
        Object filter_orgview = this.getModel().getValue("filter_orgview");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(filter_queryWay)) {
            paramMap.put("filter_orgview", filter_orgview);
        }
        if ((filter_company = this.getModel().getValue("filter_org")) != null && filter_company != "" && ((DynamicObjectCollection)filter_company).size() > 0) {
            DynamicObjectCollection companys = (DynamicObjectCollection)filter_company;
            paramMap.put("filter_org", this.getIdList(companys));
        } else {
            paramMap.put("filter_org", null);
        }
        Object filter_countNumber = this.getModel().getValue("filter_bankaccountnumber");
        if (filter_countNumber != null && filter_countNumber != "" && ((DynamicObjectCollection)filter_countNumber).size() > 0) {
            DynamicObjectCollection bankAccs = (DynamicObjectCollection)filter_countNumber;
            paramMap.put("filter_bankaccountnumber", this.getIdList(bankAccs));
        } else {
            paramMap.put("filter_bankaccountnumber", null);
        }
        Object filter_bank = this.getModel().getValue("filter_bank");
        if (filter_bank != null && filter_bank != "" && ((DynamicObjectCollection)filter_bank).size() > 0) {
            DynamicObjectCollection bankAccs = (DynamicObjectCollection)filter_bank;
            paramMap.put("filter_bank", this.getIdList(bankAccs));
        } else {
            paramMap.put("filter_bank", null);
        }
        Object filter_currency = this.getModel().getValue("filter_currency");
        if (filter_currency != null && filter_currency != "" && ((DynamicObjectCollection)filter_currency).size() > 0) {
            DynamicObjectCollection bankAccs = (DynamicObjectCollection)filter_currency;
            paramMap.put("filter_currency", this.getIdList(bankAccs));
        } else {
            paramMap.put("filter_currency", null);
        }
        Date startDate = (Date)this.getModel().getValue("filter_startbizdate");
        paramMap.put("filter_startbizdate", DateUtils.getDataFormat((Date)startDate, (boolean)true));
        Date endDate = (Date)this.getModel().getValue("filter_endbizdate");
        paramMap.put("filter_endbizdate", DateUtils.getDataFormat((Date)endDate, (boolean)false));
    }

    private List<Long> getIdList(DynamicObjectCollection coll) {
        return coll.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
    }
}

