/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.mservice.MQ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.webapi.ebentity.biz.detail.Detail;

public class DetailScheduleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(DetailScheduleConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String errorMsg;
        DynamicObject queryRequest;
        block18: {
            Map param = (Map)message;
            long requestId = (Long)param.get("requestid");
            logger.info("\u5f53\u524dMQ\u67e5\u8be2\u8bf7\u6c42id:" + requestId);
            queryRequest = TmcDataServiceHelper.loadSingle((Object)requestId, (String)"bei_queryrequest", (String)"id,status,exception,exception_tag,publishtime,createtime,task");
            if (!QueryRequestStatusEnum.NOSTART.getValue().equals(queryRequest.getString("status"))) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\u5df2\u67e5\u8be2\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u67e5\u8be2");
                acker.discard(messageId);
                return;
            }
            Date curDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
            Date date = DateUtils.getDataFormat((Date)queryRequest.getDate("createtime"), (boolean)true);
            if (date.compareTo(curDate) != 0) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\u5df2\u8fc7\u671f\uff0c\u4e0d\u518d\u67e5\u8be2");
                acker.discard(messageId);
                return;
            }
            Date beginDate = (Date)param.get("begindate");
            Date endDate = (Date)param.get("enddate");
            String downloadFromBankStr = (String)param.get("downloadFromBank");
            boolean downloadFromBank = Boolean.parseBoolean(downloadFromBankStr);
            DetailQueryInfo detailQueryInfo = new DetailQueryInfo();
            DynamicObject accountBank = (DynamicObject)param.get("accountbank");
            detailQueryInfo.setBankAcct(accountBank);
            detailQueryInfo.setBeginDate(beginDate);
            detailQueryInfo.setEndDate(endDate);
            detailQueryInfo.setCurr((DynamicObject)param.get("currency"));
            detailQueryInfo.setAsyncTask(false);
            detailQueryInfo.setDownloadFromBank(downloadFromBank);
            detailQueryInfo.setSchedule(true);
            detailQueryInfo.setRequestId(requestId);
            detailQueryInfo.setOrgId(Long.valueOf(TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)accountBank)));
            errorMsg = "";
            try {
                ArrayList detailIds = new ArrayList(10);
                List<Object> uniqueSeqIds = new ArrayList(10);
                int totalCount = 0;
                int progress = 0;
                while (detailQueryInfo.isSuccess() && !detailQueryInfo.isLastPage()) {
                    TransDetailResult transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, new DynamicObject[]{queryRequest});
                    if (detailQueryInfo.isDownloadFromBank() && transDetailResult != null && transDetailResult.isTimeOut()) {
                        detailQueryInfo.setDownloadFromBank(false);
                        detailQueryInfo.setPageNum(detailQueryInfo.getPageNum() - 1);
                        transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, new DynamicObject[]{queryRequest});
                        detailQueryInfo.setDownloadFromBank(true);
                    }
                    if (transDetailResult != null) {
                        errorMsg = transDetailResult.getErrMsg();
                        totalCount = transDetailResult.getTotalCount();
                        progress = transDetailResult.getProgress();
                    }
                    if (progress == 0) {
                        logger.info("\u5f53\u524d\u5e01\u79cd\u672a\u5728\u4e0b\u8f7d\uff0c\u76f4\u63a5\u8df3\u51fa\u3002");
                        break;
                    }
                    if (transDetailResult == null || CollectionUtils.isEmpty((Collection)transDetailResult.getDetailIds())) break;
                    detailIds.addAll(transDetailResult.getDetailIds());
                    uniqueSeqIds = transDetailResult.getDetails().stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getUniqueSeq())).map(Detail::getUniqueSeq).collect(Collectors.toList());
                }
                logger.info("\u5faa\u73af\u7ed3\u675f\uff1adetailQueryInfo.isSuccess() = {}, detailQueryInfo.isLastPage() = {}", (Object)detailQueryInfo.isSuccess(), (Object)detailQueryInfo.isLastPage());
                if (!CollectionUtils.isEmpty(detailIds)) {
                    HashSet checkRepeat = new HashSet(detailIds.size());
                    checkRepeat.addAll(detailIds);
                    if (totalCount != checkRepeat.size()) {
                        logger.info(" transDetail[detailIds] from ebg is repeated ");
                        throw new KDBizException("transDetail[detailIds] from ebg is repeated");
                    }
                    DetailQueryParam detailQueryParam = new DetailQueryParam();
                    detailQueryParam.setBeginDate(beginDate);
                    detailQueryParam.setEndDate(endDate);
                    new EBDetailQueryService(detailQueryParam).deleteNoExistDetail(detailQueryInfo.getBankAcct(), detailQueryInfo.getCurr(), detailIds, uniqueSeqIds);
                    break block18;
                }
                logger.info("detailIds is empty");
            }
            catch (Exception e2) {
                block19: {
                    try {
                        logger.error("queryTransDetail Exception:", (Throwable)e2);
                        errorMsg = e2.getMessage();
                        if (!(e2 instanceof KDBizException)) break block19;
                        throw e2;
                    }
                    catch (Throwable throwable) {
                        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                            queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                            queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                            queryRequest.set("exception_tag", (Object)errorMsg);
                        } else {
                            queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                        }
                        TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
                        throw throwable;
                    }
                }
                if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                    queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                    queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                    queryRequest.set("exception_tag", (Object)errorMsg);
                } else {
                    queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                }
                TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
            }
        }
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
            queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
            queryRequest.set("exception_tag", (Object)errorMsg);
        } else {
            queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
        acker.ack(messageId);
    }
}

