/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.business.opservice.helper.DealTheSameNameTransHelper;
import kd.tmc.bei.business.service.factory.impl.AgentBankCheckFlagImpl;
import kd.tmc.bei.business.service.factory.impl.PayBankCheckFlagImpl;
import kd.tmc.bei.business.service.factory.impl.TransDownBankCheckFlagImpl;
import kd.tmc.bei.business.service.factory.impl.TransHandleBankCheckFlagImpl;
import kd.tmc.bei.business.service.factory.impl.TransUpBankCheckFlagImpl;
import kd.tmc.bei.common.constants.DBRouteConst;
import kd.tmc.bei.common.enums.AutoMatchBillEnum;
import kd.tmc.bei.common.enums.AutoMatchFlagEnum;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.AutoMatchService;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.bei.service.tcc.TccServiceFactory;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AutoMatchBillTCCService
extends TCCAdapterService {
    private static final Log LOGGER = LogFactory.getLog(AutoMatchService.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("autoMatchRegion");
    private static final List<String> MATCH_RECEIVED_WAY_LIST = Arrays.asList(ReceredWayEnum.AUTOMATCH.getValue(), ReceredWayEnum.HANDMATCH.getValue(), ReceredWayEnum.BEIPAY.getValue(), ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.REVERSEMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue());
    private static final List<String> RECEIVED_WAY_LIST = Arrays.asList(ReceredWayEnum.RULE.getValue(), ReceredWayEnum.HAND.getValue(), ReceredWayEnum.HANDMERGE.getValue());

    public void Try(Object param) throws Exception {
        List autoMatchInfoList;
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        if (doExecute && !this.lockOrRelease(TccLockEnum.TRY, autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam), commonParam.getString((Object)"version"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u5339\u914d\u7684\u4e1a\u52a1\u5355\u636e\u5df2\u7ecf\u5728\u5339\u914d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchService_1", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        }
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        List autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        LOGGER.info("AutoMatchBillTCCService.confirm doExecute:{}, autoMatchInfoList:{}", (Object)doExecute, (Object)autoMatchInfoList);
        if (doExecute) {
            this.updateRecedBills(autoMatchInfoList, commonParam.getString((Object)"receredway"), (Set)commonParam.get((Object)"autoRecPayBizBillId"));
            this.lockOrRelease(TccLockEnum.CONFIRM, autoMatchInfoList, commonParam.getString((Object)"version"));
        } else {
            boolean isDeleteWork = Boolean.parseBoolean(commonParam.getString((Object)"isDeleteWork"));
            this.cancelRecedBills(autoMatchInfoList, commonParam.getString((Object)"receredway"), isDeleteWork);
        }
        return null;
    }

    public void cancel(Object param) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        if (doExecute) {
            List<AutoMatchInfoParam> autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
            autoMatchInfoList = autoMatchInfoList.stream().filter(o -> !AutoMatchServiceHelper.mTmcDb.contains(o.getRecedBillType())).collect(Collectors.toList());
            this.lockOrRelease(TccLockEnum.CANCEL, autoMatchInfoList, commonParam.getString((Object)"version"));
        }
    }

    private boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        Map<String, List<AutoMatchInfoParam>> tAutoMatchInfoParamMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType));
        for (Map.Entry<String, List<AutoMatchInfoParam>> tAutoMatchInfoParamEntry : tAutoMatchInfoParamMap.entrySet()) {
            IAutoMatchTccService autoMatchServiceTcc = TccServiceFactory.getMatchAutoBiz(AutoMatchServiceHelper.getRecedBillType((String)tAutoMatchInfoParamEntry.getKey()));
            if (autoMatchServiceTcc == null) continue;
            return autoMatchServiceTcc.lockOrRelease(lock, tAutoMatchInfoParamEntry.getValue(), version);
        }
        return true;
    }

    public void updateRecedBills(List<AutoMatchInfoParam> tAutoMatchInfoParamList, String receredway, Set<Object> autoRecPayBizBillIdSet) {
        Map<Long, List<AutoMatchInfoParam>> tAutoMatchInfoParamMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
        Map tRecedBillsIdMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType, Collectors.mapping(AutoMatchInfoParam::getRecedBillId, Collectors.toList())));
        HashMap<String, Map<Long, DynamicObject>> tRecedBillsMap = new HashMap<String, Map<Long, DynamicObject>>(tRecedBillsIdMap.size());
        for (Map.Entry entry : tRecedBillsIdMap.entrySet()) {
            String key = AutoMatchServiceHelper.getRecedBillType((String)entry.getKey());
            DynamicObject[] tRecedBills = BusinessDataServiceHelper.load((Object[])entry.getValue().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)key));
            tRecedBillsMap.put(entry.getKey(), Arrays.stream(tRecedBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v)));
        }
        if (ReceredWayEnum.SINGLEMATCH.getValue().equals(receredway) && tRecedBillsIdMap.containsKey("bei_transdetail")) {
            return;
        }
        for (Map.Entry<Object, List<Object>> entry : tAutoMatchInfoParamMap.entrySet()) {
            Map<String, List<AutoMatchInfoParam>> tRecedBillTypeMap = entry.getValue().stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType));
            for (Map.Entry<String, List<AutoMatchInfoParam>> tRecedBillTypeEntry : tRecedBillTypeMap.entrySet()) {
                Map tRecedBillsFromDBMap = (Map)tRecedBillsMap.get(tRecedBillTypeEntry.getKey());
                for (AutoMatchInfoParam tAutoMatchInfoParam : tRecedBillTypeEntry.getValue()) {
                    DynamicObject tRecedBill = (DynamicObject)tRecedBillsFromDBMap.get(tAutoMatchInfoParam.getRecedBillId());
                    IAutoMatchTccService autoMatchTccService = TccServiceFactory.getMatchAutoBiz(AutoMatchServiceHelper.getRecedBillType((String)tRecedBillTypeEntry.getKey()));
                    if (autoMatchTccService == null) continue;
                    autoMatchTccService.update(tRecedBill, tAutoMatchInfoParam, receredway, null);
                }
            }
        }
        for (Map.Entry<Object, List<Object>> entry : tRecedBillsMap.entrySet()) {
            SaveServiceHelper.save((DynamicObject[])((Map)((Object)entry.getValue())).values().toArray(new DynamicObject[0]));
        }
        if (!ReceredWayEnum.SINGLEMATCH.getValue().equals(receredway)) {
            AutoMatchBillTCCService.saveBotpRelation(tAutoMatchInfoParamList, receredway);
        }
        Map tAutoRecPayMap = AutoMatchServiceHelper.getAutoRecPayMap(autoRecPayBizBillIdSet, tRecedBillsMap, (Boolean)true);
        tAutoRecPayMap.entrySet().forEach(tAutoRecPayEntry -> {
            DynamicObject[] dynamicObjects = (DynamicObject[])((Map)tRecedBillsMap.get(tAutoRecPayEntry.getKey())).entrySet().stream().filter(o -> ((List)tAutoRecPayEntry.getValue()).contains(o.getKey())).map(Map.Entry::getValue).toArray(DynamicObject[]::new);
            TX.addCommitListener((CommitListener)new CommitListener((Map.Entry)tAutoRecPayEntry, dynamicObjects){
                final /* synthetic */ Map.Entry val$tAutoRecPayEntry;
                final /* synthetic */ DynamicObject[] val$dynamicObjects;
                {
                    this.val$tAutoRecPayEntry = entry;
                    this.val$dynamicObjects = dynamicObjectArray;
                }

                public void onCommitted() {
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            LOGGER.info("\u5339\u914d,\u5df2\u5ba1\u6838\u7684\u4e1a\u52a1\u5355\u636eauditAutoPayDOList:" + this.val$tAutoRecPayEntry.getValue());
                            OperateOption operateOption = OperateOption.create();
                            operateOption.setVariableValue("isLock", "true");
                            String entityKey = AutoMatchServiceHelper.getRecedBillType((String)((String)this.val$tAutoRecPayEntry.getKey()));
                            AutoMatchBillEnum autoMatchBillEnum = AutoMatchBillEnum.getByName((String)entityKey);
                            TmcOperateServiceHelper.execOperate((String)autoMatchBillEnum.getAutoRecPayOperateKey(), (String)autoMatchBillEnum.getName(), (DynamicObject[])this.val$dynamicObjects, (OperateOption)operateOption);
                            LOGGER.info("===========\u5339\u914d,\u5df2\u5ba1\u6838\u7684\u4e1a\u52a1\u5355\u636e,\u6267\u884c\u81ea\u52a8\u6536\u4ed8\u6b3e\u64cd\u4f5c\u6210\u529f");
                        }
                        catch (Exception ex) {
                            LOGGER.error("\u6267\u884c\u81ea\u52a8\u6536\u4ed8\u6b3e\u64cd\u4f5c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                            tx.markRollback();
                        }
                    }
                }
            });
        });
    }

    private static void saveBotpRelation(List<AutoMatchInfoParam> tAutoMatchInfoParamList, String receredway) {
        if (ReceredWayEnum.DIFFERMATCH.getValue().equals(receredway)) {
            for (AutoMatchInfoParam autoMatchInfoParam : tAutoMatchInfoParamList) {
                Pair srcTarId = Pair.of((Object)autoMatchInfoParam.getTransDetailId(), (Object)autoMatchInfoParam.getRecedBillId());
                CasBotpHelper.batchSaveRelation((DBRoute)(AutoMatchServiceHelper.mTmcDb.contains(autoMatchInfoParam.getRecedBillType()) ? DBRouteConst.TMC : DBRouteConst.cas), (String)autoMatchInfoParam.getDifferMatchSourceEntity(), (String)autoMatchInfoParam.getRecedBillType(), Collections.singletonList(srcTarId));
            }
        } else {
            Map collect = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getSourceEntity, Collectors.groupingBy(vk -> AutoMatchServiceHelper.getRecedBillType((String)vk.getRecedBillType()), Collectors.mapping(vv -> Pair.of((Object)vv.getTransDetailId(), (Object)vv.getRecedBillId()), Collectors.toList()))));
            collect.forEach((key, value) -> value.forEach((key1, value1) -> CasBotpHelper.batchSaveRelation((DBRoute)(AutoMatchServiceHelper.mTmcDb.contains(key1) ? DBRouteConst.TMC : DBRouteConst.cas), (String)key, (String)key1, (List)value1)));
        }
    }

    public void cancelRecedBills(List<AutoMatchInfoParam> tAutoMatchInfoParamList, String receredWay, boolean isDeleteWork) {
        Map<Long, List<AutoMatchInfoParam>> tAutoMatchInfoParamMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
        ArrayList<Long> transDetailIds = new ArrayList<Long>(tAutoMatchInfoParamMap.keySet());
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((Object[])tAutoMatchInfoParamMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        Map<Long, DynamicObject> transDetailsMap = Arrays.stream(transDetails).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map tRecedBillsIdMap = tAutoMatchInfoParamList.stream().filter(o -> o.getRecedBillId() != 0L).collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType, Collectors.mapping(AutoMatchInfoParam::getRecedBillId, Collectors.toList())));
        HashMap<String, Map<Long, DynamicObject>> tRecedBillsMap = new HashMap<String, Map<Long, DynamicObject>>(tRecedBillsIdMap.size());
        if (tRecedBillsIdMap.containsKey("bei_transdetail")) {
            return;
        }
        for (Map.Entry tRecedBillsEntry : tRecedBillsIdMap.entrySet()) {
            String key2 = AutoMatchServiceHelper.getRecedBillType((String)tRecedBillsEntry.getKey());
            DynamicObject[] tRecedBills = BusinessDataServiceHelper.load((Object[])tRecedBillsEntry.getValue().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)key2));
            tRecedBillsMap.put(tRecedBillsEntry.getKey(), Arrays.stream(tRecedBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v)));
        }
        List tHandLinkDetailList = Arrays.stream(transDetails).filter(o -> o.getBoolean("ishandlink") || MATCH_RECEIVED_WAY_LIST.contains(o.getString("receredway"))).map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> tHandMergeDetailList = Arrays.stream(transDetails).filter(o -> !o.getBoolean("ishandlink") && RECEIVED_WAY_LIST.contains(o.getString("receredway"))).map(o -> o.getLong("id")).collect(Collectors.toList());
        if (!isDeleteWork) {
            tHandLinkDetailList.addAll(tHandMergeDetailList);
            tHandMergeDetailList.clear();
        }
        HashSet autoRecPayBizBillIdSet = new HashSet();
        if (isDeleteWork) {
            List receredWayCollect = Arrays.asList(transDetails).stream().filter(o -> RECEIVED_WAY_LIST.contains(o.getString("receredway"))).collect(Collectors.toList());
            this.dealCancleRuleSameNameTrans(tAutoMatchInfoParamList, receredWayCollect);
        }
        for (Long tHandLinkDetailid : tHandLinkDetailList) {
            DynamicObject transDetail = transDetailsMap.get(tHandLinkDetailid);
            List<AutoMatchInfoParam> autoMatchInfoParams = tAutoMatchInfoParamMap.get(tHandLinkDetailid);
            if (transDetail.getBoolean("autorecorpay")) {
                autoRecPayBizBillIdSet.addAll(autoMatchInfoParams.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet()));
            }
            this.doHandLinkDetail(autoMatchInfoParams, tRecedBillsMap, transDetail, transDetailIds, receredWay);
        }
        if (!tHandMergeDetailList.isEmpty()) {
            this.doDeleteBills(tHandMergeDetailList);
        }
        Map tAutoRecPayMap = AutoMatchServiceHelper.getAutoRecPayMap(autoRecPayBizBillIdSet, tRecedBillsMap, (Boolean)false);
        tAutoRecPayMap.forEach((key, value) -> {
            DynamicObject[] dynamicObjects = (DynamicObject[])((Map)tRecedBillsMap.get(key)).entrySet().stream().filter(o -> value.contains(o.getKey())).map(Map.Entry::getValue).toArray(DynamicObject[]::new);
            TX.addCommitListener((CommitListener)new CommitListener((List)value, (String)key, dynamicObjects){
                final /* synthetic */ List val$value;
                final /* synthetic */ String val$key;
                final /* synthetic */ DynamicObject[] val$dynamicObjects;
                {
                    this.val$value = list;
                    this.val$key = string;
                    this.val$dynamicObjects = dynamicObjectArray;
                }

                public void onCommitted() {
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            LOGGER.info("\u5339\u914d,\u5df2\u6536\u4ed8\u6b3e\u7684\u4e1a\u52a1\u5355\u636eauditAutoPayDOList:" + this.val$value);
                            OperateOption operateOption = OperateOption.create();
                            operateOption.setVariableValue("isLock", "true");
                            String entityKey = AutoMatchServiceHelper.getRecedBillType((String)this.val$key);
                            AutoMatchBillEnum autoMatchBillEnum = AutoMatchBillEnum.getByName((String)entityKey);
                            TmcOperateServiceHelper.execOperate((String)autoMatchBillEnum.getCancelPayOpKey(), (String)autoMatchBillEnum.getName(), (DynamicObject[])this.val$dynamicObjects, (OperateOption)operateOption);
                            LOGGER.info("===========\u5339\u914d,\u5df2\u6536\u4ed8\u6b3e\u7684\u4e1a\u52a1\u5355\u636e,\u6267\u884c\u81ea\u52a8\u53d6\u6d88\u6536\u4ed8\u6b3e\u64cd\u4f5c\u6210\u529f");
                        }
                        catch (Exception ex) {
                            LOGGER.error("\u6267\u884c\u81ea\u52a8\u53d6\u6d88\u6536\u4ed8\u6b3e\u64cd\u4f5c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                            tx.markRollback();
                        }
                    }
                }
            });
        });
    }

    private void doDeleteBills(List<Long> ids) {
        if (EmptyUtil.isEmpty(ids)) {
            return;
        }
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,recedbillentry.e_recedbillid,recedbillentry.e_recedbilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> billIds = new HashSet<Long>(8);
        for (DynamicObject detail : details) {
            for (DynamicObject oneEntryRow : detail.getDynamicObjectCollection("recedbillentry")) {
                QFilter filter;
                long recedBillId = oneEntryRow.getLong("e_recedbillid");
                if (billIds.contains(recedBillId)) continue;
                billIds.add(recedBillId);
                String recedEntity = this.getEntityNameByString(oneEntryRow.getString("e_recedbilltype"));
                boolean isExists = QueryServiceHelper.exists((String)recedEntity, (QFilter[])(filter = new QFilter("id", "=", (Object)recedBillId).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())).toArray());
                if (!isExists) continue;
                OperateServiceHelper.execOperate((String)"deletework", (String)recedEntity, (Object[])new Object[]{recedBillId}, (OperateOption)OperateOption.create());
            }
        }
    }

    String getEntityNameByString(String name) {
        if (new ArrayList<String>(Arrays.asList("cas_paybill_synonym", "cas_paybill_spanmainpart", "cas_paybill_cash", "cas_paybill_dcep")).contains(name)) {
            return "cas_paybill";
        }
        return name;
    }

    private void doHandLinkDetail(List<AutoMatchInfoParam> tAutoMatchInfoParamList, Map<String, Map<Long, DynamicObject>> tRecedBillsMap, DynamicObject transDetail, List<Long> transDetailIds, String receredWay) {
        Map<String, List<AutoMatchInfoParam>> tRecedBillTypeMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType));
        for (Map.Entry<String, List<AutoMatchInfoParam>> tRecedBillTypeEntry : tRecedBillTypeMap.entrySet()) {
            Map<Long, DynamicObject> tRecedBillsFromDBMap = tRecedBillsMap.get(tRecedBillTypeEntry.getKey());
            HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(10);
            HashSet<Long> billIdSet = new HashSet<Long>(16);
            boolean isExchangeBill = "cas_exchangebill".equals(tRecedBillTypeEntry.getKey());
            boolean haveBankcheckflag = EntityMetadataCache.getDataEntityType((String)AutoMatchServiceHelper.getRecedBillType((String)tRecedBillTypeEntry.getKey())).getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()) || "bankcheckflag_tag".equals(o.getName()));
            if (AutoMatchServiceHelper.mTmcDb.contains(tRecedBillTypeEntry.getKey())) {
                haveBankcheckflag = true;
            }
            Map<String, String> tBillField = this.getBillField(tRecedBillTypeEntry.getKey());
            for (AutoMatchInfoParam tAutoMatchInfoParam : tRecedBillTypeEntry.getValue()) {
                Boolean isFromBei = this.bankCheckFlagIsFrom(tAutoMatchInfoParam.getRecedBillType(), tAutoMatchInfoParam.getRecedBillId());
                DynamicObject tRecedBill = tRecedBillsFromDBMap.get(tAutoMatchInfoParam.getRecedBillId());
                if (!billIdSet.contains(tAutoMatchInfoParam.getRecedBillId())) {
                    billSet.add(tRecedBill);
                    billIdSet.add(tAutoMatchInfoParam.getRecedBillId());
                }
                if (isExchangeBill) {
                    MatchAmountDealHelper.matchExchangeBill((DynamicObject)tRecedBill, (DynamicObject)transDetail);
                    AutoMatchServiceHelper.cancelExchangeBill((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getTraceType(), (String)tAutoMatchInfoParam.getBankCheckFlag(), (Date)tAutoMatchInfoParam.getBizDate());
                } else {
                    boolean notBeiPay;
                    boolean bl = notBeiPay = !ReceredWayEnum.BEIPAY.getValue().equalsIgnoreCase(transDetail.getString("receredway"));
                    if (tBillField.containsKey(tRecedBillTypeEntry.getKey()) && tAutoMatchInfoParam.getRecedBillEntryId() != 0L) {
                        DynamicObject tRecedBillEntry = tRecedBill.getDynamicObjectCollection(tBillField.get(tRecedBillTypeEntry.getKey())).stream().filter(item -> item.getLong("id") == tAutoMatchInfoParam.getRecedBillEntryId().longValue()).findFirst().orElse(null);
                        if (tRecedBillEntry == null) {
                            LOGGER.error("\u5355\u636e\u7f16\u53f7\uff1a" + tRecedBill.getString("billno") + "\uff0c\u4e0d\u5b58\u5728ID\u4e3a\u201c" + tAutoMatchInfoParam.getRecedBillEntryId() + "\u201d\u7684\u5206\u5f55\uff0c\u8be5\u6570\u636e\u5c06\u4f1a\u88ab\u820d\u5f03\uff01");
                        } else {
                            this.updateRecedBillWithReceredWay(tRecedBillTypeEntry.getKey(), tRecedBill, tRecedBillEntry, transDetail.getString("receredway"), false);
                            if (haveBankcheckflag) {
                                String bankcheckflag = tBillField.get(tBillField.get(tRecedBillTypeEntry.getKey()));
                                if (Arrays.asList("cas_agentpaybill", "fca_transupbill", "fca_transdownbill").contains(tRecedBillTypeEntry.getKey()) && notBeiPay) {
                                    tRecedBillEntry.set(bankcheckflag, (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)tRecedBillEntry.getString(bankcheckflag), (String)tAutoMatchInfoParam.getBankCheckFlag()), (String)"", (int)50));
                                }
                            }
                        }
                    }
                    this.updateRecedBillWithReceredWay(tRecedBillTypeEntry.getKey(), tRecedBill, null, transDetail.getString("receredway"), false);
                    if (haveBankcheckflag) {
                        String bankcheckBill = "";
                        if ("ifm_transhandlebill".equals(tRecedBillTypeEntry.getKey())) {
                            bankcheckBill = tRecedBill.getString("beibankcheckflag");
                            tRecedBill.set("beibankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag()), (String)"", (int)1024));
                        } else if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag_tag".equals(o.getName()))) {
                            bankcheckBill = tRecedBill.getString("bankcheckflag_tag");
                            tRecedBill.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag()), (String)"", (int)0));
                            tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag()), (String)"", (int)255));
                        } else if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()))) {
                            bankcheckBill = tRecedBill.getString("bankcheckflag");
                            tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)AutoMatchServiceHelper.dealBankcheckflag((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag()), (String)"", (int)255));
                        }
                        if (Arrays.asList(SourceBillTypeEnum.AGENTPAYBILL.getValue(), SourceBillTypeEnum.RECBILL.getValue(), SourceBillTypeEnum.PAYBILL.getValue()).contains(AutoMatchServiceHelper.getRecedBillType((String)tRecedBillTypeEntry.getKey())) && notBeiPay) {
                            String matchBankCheckFlag = tAutoMatchInfoParam.getBankCheckFlag();
                            DynamicObjectCollection bankCheckEntity = tRecedBill.getDynamicObjectCollection("bankcheckentity");
                            if (!EmptyUtil.isEmpty((String)matchBankCheckFlag)) {
                                String[] split;
                                for (String strFlag : split = matchBankCheckFlag.split(",")) {
                                    List eBankCheckFlag = bankCheckEntity.stream().filter(o -> strFlag.equalsIgnoreCase(o.getString("ebankcheckflag"))).collect(Collectors.toList());
                                    bankCheckEntity.removeAll(eBankCheckFlag);
                                }
                            }
                        }
                    }
                    String oldReceredWay = transDetail.getString("receredway");
                    MatchAmountDealHelper.dealCancelMatchInfo((String)AutoMatchServiceHelper.getBunessType((String)(ReceredWayEnum.DIFFERMATCH.getValue().equals(oldReceredWay) ? tAutoMatchInfoParam.getDifferMatchSourceEntity() : tAutoMatchInfoParam.getSourceEntity()), (String)oldReceredWay), (BigDecimal)tAutoMatchInfoParam.getAmount(), (Long)tAutoMatchInfoParam.getRecedBillEntryId(), (DynamicObject)tRecedBill, (String)oldReceredWay);
                }
                String filedName = "acttradedate";
                if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> filedName.equals(o.getName()))) {
                    tRecedBill.set(filedName, (Object)tAutoMatchInfoParam.getBizDate());
                }
                if ("cas_agentpaybill".equals(tRecedBillTypeEntry.getKey())) {
                    DynamicObjectCollection entry = tRecedBill.getDynamicObjectCollection("entry");
                    for (DynamicObject bill : entry) {
                        if (AutoMatchFlagEnum.NONE.getValue().equals(bill.getString("entrymatchflag"))) continue;
                        bill.set("e_paytime", (Object)tAutoMatchInfoParam.getBizDate());
                    }
                }
                AutoMatchHelper.initMatchAmountInCancelMatch(transDetailIds, (DynamicObject)tRecedBill);
                boolean isMatcheReceipt = transDetail.getBoolean("ismatchereceipt");
                if (!isMatcheReceipt || !tRecedBill.containsProperty("isgetreceipt")) continue;
                tRecedBill.set("isgetreceipt", (Object)false);
            }
            if (billSet.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])billSet.toArray(new DynamicObject[0]));
        }
        String[] inTmcDb = (String[])tRecedBillsMap.keySet().stream().filter(AutoMatchServiceHelper.mTmcDb::contains).toArray(String[]::new);
        String[] inCasDb = (String[])tRecedBillsMap.keySet().stream().map(t -> AutoMatchServiceHelper.getRecedBillType((String)t)).filter(o -> !AutoMatchServiceHelper.mTmcDb.contains(o)).toArray(String[]::new);
        tAutoMatchInfoParamList.stream().forEach(item -> {
            if (tRecedBillsMap.size() != inCasDb.length) {
                CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (Object)item.getTransDetailId(), (Boolean)false, (String[])inTmcDb);
            }
            if (inCasDb.length > 0) {
                CasBotpHelper.deleteRation((DBRoute)DBRouteConst.cas, (Object)item.getTransDetailId(), (Boolean)false, (String[])inCasDb);
            }
        });
    }

    private Boolean bankCheckFlagIsFrom(String entityName, Long id) {
        Boolean isFromBei = Boolean.FALSE;
        entityName = AutoMatchServiceHelper.getRecedBillType((String)entityName);
        if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equalsIgnoreCase(entityName)) {
            AgentBankCheckFlagImpl instance = AgentBankCheckFlagImpl.getInstance();
            isFromBei = instance.bankCheckFlagFromBei(id);
        } else if (SourceBillTypeEnum.PAYBILL.getValue().equalsIgnoreCase(entityName)) {
            PayBankCheckFlagImpl instance = PayBankCheckFlagImpl.getInstance();
            isFromBei = instance.bankCheckFlagFromBei(id);
        } else if (SourceBillTypeEnum.TRANSDOWNBILL.getValue().equalsIgnoreCase(entityName)) {
            TransDownBankCheckFlagImpl instance = TransDownBankCheckFlagImpl.getInstance();
            isFromBei = instance.bankCheckFlagFromBei(id);
        } else if (SourceBillTypeEnum.TRANSUPBILL.getValue().equalsIgnoreCase(entityName)) {
            TransUpBankCheckFlagImpl instance = TransUpBankCheckFlagImpl.getInstance();
            isFromBei = instance.bankCheckFlagFromBei(id);
        } else if (SourceBillTypeEnum.TRANSHANDLEBILL.getValue().equalsIgnoreCase(entityName)) {
            TransHandleBankCheckFlagImpl instance = TransHandleBankCheckFlagImpl.getInstance();
            isFromBei = instance.bankCheckFlagFromBei(id);
        }
        return isFromBei;
    }

    private void dealCancleRuleSameNameTrans(List<AutoMatchInfoParam> tAutoMatchInfoParamList, List<DynamicObject> receredWayCollect) {
        Map tSourceEntityMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getSourceEntity, Collectors.mapping(AutoMatchInfoParam::getTransDetailId, Collectors.toSet())));
        for (Map.Entry tSourceEntityEntry : tSourceEntityMap.entrySet()) {
            List collect = receredWayCollect.stream().filter(o -> ((Set)tSourceEntityEntry.getValue()).contains(o.getLong("id"))).collect(Collectors.toList());
            if (collect.isEmpty()) continue;
            if ("bei_intelpay".equals(tSourceEntityEntry.getKey())) {
                try {
                    LOGGER.info("beginOperationTransaction dealCancleRuleSameNameTrans start");
                    DealTheSameNameTransHelper.dealCancleRuleSameNameTrans(collect, (String)"cas_paybill");
                    LOGGER.info("beginOperationTransaction dealCancleRuleSameNameTrans end");
                }
                catch (Exception ex) {
                    LOGGER.error("\u540c\u540d\u8f6c\u8d26\u5f02\u5e38" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                }
                continue;
            }
            if (!"bei_intelrec".equals(tSourceEntityEntry.getKey())) continue;
            try {
                LOGGER.info("beginOperationTransaction dealCancleRuleSameNameTrans start");
                DealTheSameNameTransHelper.dealCancleRuleSameNameTrans(collect, (String)"cas_recbill");
                LOGGER.info("beginOperationTransaction dealCancleRuleSameNameTrans end");
            }
            catch (Exception ex) {
                LOGGER.error("\u540c\u540d\u8f6c\u8d26\u5f02\u5e38" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            }
        }
    }

    private Map<String, String> getBillField(String billtype) {
        HashMap<String, String> tBillField = new HashMap<String, String>(1);
        if ("fca_transupbill".equals(billtype) || "fca_transdownbill".equals(billtype)) {
            tBillField.put(billtype, "entrys");
            tBillField.put("entrys", "bankcheckflag");
        } else if ("cas_agentpaybill".equals(billtype)) {
            tBillField.put(billtype, "entry");
            tBillField.put("entry", "e_bankcheckflag");
        }
        return tBillField;
    }

    private void updateRecedBillWithReceredWay(String tRecedBillType, DynamicObject tRecedBill, DynamicObject tRecedBillEntry, String receredway, boolean notCancel) {
        if (ReceredWayEnum.AUTOMATCH.getValue().equals(receredway) && "cas_agentpaybill".equals(tRecedBillType)) {
            if (notCancel) {
                tRecedBill.set("matchresult", (Object)"1");
            } else {
                tRecedBill.set("matchresult", (Object)"0");
            }
            if (tRecedBillEntry != null) {
                if (notCancel) {
                    tRecedBillEntry.set("e_matchresult", (Object)"1");
                } else {
                    tRecedBillEntry.set("e_matchresult", (Object)"0");
                }
            }
        }
        if (("fca_transupbill".equals(tRecedBillType) || "fca_transdownbill".equals(tRecedBillType)) && tRecedBillEntry != null) {
            if (notCancel) {
                tRecedBillEntry.set("matchresult", (Object)"1");
            } else {
                tRecedBillEntry.set("matchresult", (Object)"0");
            }
        }
    }
}

