/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.bei.service.tcc.TccServiceFactory;

public class AutoMatchDetailTCCService
extends TCCAdapterService {
    private static final Log LOGGER = LogFactory.getLog(AutoMatchDetailTCCService.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("autoMatchRegion");
    private IAutoMatchTccService autoMatchTccService = TccServiceFactory.getMatchAutoBiz("bei_transdetail_cas");

    public void Try(Object param) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        List autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
        String receivedWay = commonParam.getString((Object)"receredway");
        Set recedBillType = autoMatchInfoList.stream().map(v -> v.getRecedBillType()).collect(Collectors.toSet());
        if (ReceredWayEnum.SINGLEMATCH.getValue().equals(receivedWay) && !recedBillType.contains("bei_transdetail")) {
            return;
        }
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        if (doExecute) {
            if (!this.autoMatchTccService.lockOrRelease(TccLockEnum.TRY, autoMatchInfoList, commonParam.getString((Object)"version"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u4e1a\u52a1\u5355\u636e\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchService_0", (String)"tmc-bei-mservice", (Object[])new Object[0]));
            }
        } else if (!this.autoMatchTccService.lockOrRelease(TccLockEnum.REVERSE_TRY, autoMatchInfoList, commonParam.getString((Object)"version"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u53d6\u6d88\u5339\u914d\u4e1a\u52a1\u5355\u636e\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchService_2", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        }
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        List autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
        if (doExecute) {
            CommonParam tComParam = AutoMatchServiceHelper.getCommonParam((Object)param);
            String receredway = tComParam.getString((Object)"receredway");
            this.autoMatchTccService.update(null, null, receredway, commonParam);
            this.autoMatchTccService.lockOrRelease(TccLockEnum.CONFIRM, autoMatchInfoList, commonParam.getString((Object)"version"));
        } else {
            this.autoMatchTccService.cancel(autoMatchInfoList);
            this.autoMatchTccService.lockOrRelease(TccLockEnum.REVERSE_CONFIRM, autoMatchInfoList, commonParam.getString((Object)"version"));
        }
        return null;
    }

    public void cancel(Object param) throws Exception {
        CommonParam commonParam = AutoMatchServiceHelper.getCommonParam((Object)param);
        boolean doExecute = Boolean.parseBoolean(commonParam.getString((Object)"DoExecute"));
        List autoMatchInfoList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)commonParam);
        if (doExecute) {
            this.autoMatchTccService.lockOrRelease(TccLockEnum.CANCEL, autoMatchInfoList, commonParam.getString((Object)"version"));
        } else {
            this.autoMatchTccService.lockOrRelease(TccLockEnum.REVERSE_CANCEL, autoMatchInfoList, commonParam.getString((Object)"version"));
        }
    }
}

