/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.common.enums.AutoMatchFlagEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.helper.DetailInfoExtFieldsHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgentTccServiceImpl
implements IAutoMatchTccService {
    private static final Log LOGGER = LogFactory.getLog(AgentTccServiceImpl.class);

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        LOGGER.info("AgentTccServiceImpl,isLock:{},tAutoMatchInfoParamList:{},version:{}", tAutoMatchInfoParamList, (Object)version);
        List collectInEntry = tAutoMatchInfoParamList.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getRecedBillEntryId())).collect(Collectors.toList());
        if (!collectInEntry.isEmpty()) {
            String tUpdateSql = this.getUpdateSql((AutoMatchInfoParam)collectInEntry.get(0), lock);
            Set billIdSet = collectInEntry.stream().map(AutoMatchInfoParam::getRecedBillEntryId).collect(Collectors.toSet());
            List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
            return AutoMatchServiceHelper.executeBatchSql((String)"cas_agentpaybill", (String)tUpdateSql, paramList);
        }
        List collectInHead = tAutoMatchInfoParamList.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getRecedBillEntryId())).collect(Collectors.toList());
        if (!collectInHead.isEmpty()) {
            String tUpdateSql = this.getUpdateSql((AutoMatchInfoParam)collectInHead.get(0), lock);
            Set billIdSet = collectInHead.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet());
            List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
            return AutoMatchServiceHelper.executeBatchSql((String)"cas_agentpaybill", (String)tUpdateSql, paramList);
        }
        return true;
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        String matchBankCheckFlag = tAutoMatchInfoParam.getBankCheckFlag();
        DynamicObjectCollection bankCheckEntity = tRecedBill.getDynamicObjectCollection("bankcheckentity");
        if (!EmptyUtil.isEmpty((String)matchBankCheckFlag)) {
            String bankCheckFlagTag = tRecedBill.getString("bankcheckflag_tag");
            tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankCheckFlagTag, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)255));
            tRecedBill.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankCheckFlagTag, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)0));
            String[] split = matchBankCheckFlag.split(",");
            Map detailInfoFieldsMap = DetailInfoExtFieldsHelper.getDetailInfoFields((String)tAutoMatchInfoParam.getRecedBillType());
            DynamicObject detail = QueryServiceHelper.queryOne((String)"bei_transdetail", (String)(detailInfoFieldsMap.isEmpty() ? "id,billno,bizdate" : String.join((CharSequence)",", detailInfoFieldsMap.keySet())), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tAutoMatchInfoParam.getTransDetailId())});
            for (String strFlag : split) {
                List eBankCheckEntity;
                if (bankCheckEntity.stream().noneMatch(o -> Objects.equals(o.getString("ebankcheckflag"), strFlag))) {
                    DynamicObject dynamicObject = bankCheckEntity.addNew();
                    dynamicObject.set("ebankcheckflag", (Object)strFlag);
                    DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)detail, (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                    continue;
                }
                if (!bankCheckEntity.stream().anyMatch(o -> Objects.equals(o.getString("ebankcheckflag"), strFlag)) || (eBankCheckEntity = bankCheckEntity.stream().filter(o -> strFlag.equals(o.getString("ebankcheckflag"))).collect(Collectors.toList())).isEmpty()) continue;
                for (DynamicObject dynamicObject : eBankCheckEntity) {
                    DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)detail, (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                }
            }
        }
        if (EmptyUtil.isEmpty((Long)tAutoMatchInfoParam.getRecedBillEntryId())) {
            MatchAmountDealHelper.matchManyToOne((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getRecedBillType(), (BigDecimal)tAutoMatchInfoParam.getAmount(), (Object)0, (String)receredway);
            AgentTccServiceImpl.updateAgentPayBill(tRecedBill, null, tAutoMatchInfoParam.getBizDate());
            if (ReceredWayEnum.AUTOMATCH.getValue().equals(receredway)) {
                tRecedBill.set("matchresult", (Object)"1");
            }
            return;
        }
        DynamicObject tRecedBillEntry = tRecedBill.getDynamicObjectCollection("entry").stream().filter(item -> item.getLong("id") == tAutoMatchInfoParam.getRecedBillEntryId().longValue()).findFirst().orElse(null);
        if (tRecedBillEntry == null) {
            LOGGER.error("\u5355\u636e\u7f16\u53f7\uff1a" + tRecedBill.getString("billno") + "\uff0c\u4e0d\u5b58\u5728ID\u4e3a\u201c" + tAutoMatchInfoParam.getRecedBillEntryId() + "\u201d\u7684\u5206\u5f55\uff0c\u8be5\u6570\u636e\u5c06\u4f1a\u88ab\u820d\u5f03\uff01");
            return;
        }
        MatchAmountDealHelper.matchManyToOne((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getRecedBillType(), (BigDecimal)tAutoMatchInfoParam.getAmount(), (Object)tAutoMatchInfoParam.getRecedBillEntryId(), (String)receredway);
        String bankcheckflag = "e_bankcheckflag";
        tRecedBillEntry.set(bankcheckflag, (Object)AutoMatchServiceHelper.getbankcheckBill((String)tRecedBillEntry.getString(bankcheckflag), (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)50));
        AgentTccServiceImpl.updateAgentPayBill(tRecedBill, tRecedBillEntry, tAutoMatchInfoParam.getBizDate());
        tRecedBill.set("matchresult", (Object)"1");
        tRecedBillEntry.set("e_matchresult", (Object)"1");
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
    }

    private String getUpdateSql(AutoMatchInfoParam autoMatchInfoParam, TccLockEnum lock) {
        String updateSql = TccLockEnum.TRY == lock ? (EmptyUtil.isNoEmpty((Long)autoMatchInfoParam.getRecedBillEntryId()) ? "UPDATE t_cas_agentpaybillentry_e set fversion=?,fentryispreflag='1' where fversion=' ' and fentrymatchflag in ('0','2') and fentryispreflag='0' and fentryid=?" : "UPDATE t_cas_agentpaybill_e set fversion=?,fispreflag='1' where fversion=' ' and fmatchflag in ('0','2') and fispreflag='0' and fid=?") : (EmptyUtil.isNoEmpty((Long)autoMatchInfoParam.getRecedBillEntryId()) ? "UPDATE t_cas_agentpaybillentry_e set fversion=' ',fentryispreflag='0' where fversion=? and fentryispreflag='1' and fentryid=?" : "UPDATE t_cas_agentpaybill_e set fversion=' ',fispreflag='0' where fversion=? and fispreflag='1' and fid=?");
        return updateSql;
    }

    private static void updateAgentPayBill(DynamicObject tRecedBill, DynamicObject tRecedBillEntry, Date tBizDate) {
        Date traceDate = tRecedBill.getDate("acttradedate");
        if (tRecedBill.getBoolean("isagencypersonpay")) {
            Date exchangedate = tRecedBill.getDate("acttradedate");
            if (exchangedate != null && exchangedate.compareTo(traceDate) > 0) {
                traceDate = exchangedate;
            }
        } else {
            DynamicObjectCollection entry = tRecedBill.getDynamicObjectCollection("entry");
            if (tRecedBillEntry != null) {
                tRecedBillEntry.set("e_paytime", (Object)tBizDate);
            } else {
                for (DynamicObject bill : entry) {
                    if (AutoMatchFlagEnum.NONE.getValue().equals(bill.getString("entrymatchflag"))) continue;
                    bill.set("e_paytime", (Object)tBizDate);
                }
            }
        }
        if (traceDate == null || tBizDate != null && traceDate.compareTo(tBizDate) < 0) {
            traceDate = tBizDate;
        }
        tRecedBill.set("acttradedate", (Object)traceDate);
    }
}

