/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;

public class ExchangeTccServiceImpl
implements IAutoMatchTccService {
    private static final Log LOGGER = LogFactory.getLog(ExchangeTccServiceImpl.class);

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        Set billIdSet;
        List paramList;
        Map.Entry<String, List<AutoMatchInfoParam>> collectItem;
        String tUpdateSql;
        LOGGER.info("ExchangeTccServiceImpl,tAutoMatchInfoParamList:{},version:{}", tAutoMatchInfoParamList, (Object)version);
        Map<String, List<AutoMatchInfoParam>> collect = tAutoMatchInfoParamList.stream().filter(o -> o.getTraceType() != null && o.getTraceType().trim().length() > 0).collect(Collectors.groupingBy(AutoMatchInfoParam::getTraceType));
        boolean isSuccess = true;
        Iterator<Map.Entry<String, List<AutoMatchInfoParam>>> iterator = collect.entrySet().iterator();
        while (iterator.hasNext() && (isSuccess = AutoMatchServiceHelper.executeBatchSql((String)"cas_exchangebill", (String)(tUpdateSql = this.getUpdateSql((collectItem = iterator.next()).getValue().get(0), lock)), paramList = (billIdSet = collectItem.getValue().stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet())).stream().map(id -> new Object[]{version, id}).collect(Collectors.toList())))) {
        }
        return isSuccess;
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        MatchAmountDealHelper.matchExchangeBill((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getTraceType(), (BigDecimal)tAutoMatchInfoParam.getAmount(), (String)receredway);
        AutoMatchServiceHelper.updataExchangeBill((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getTraceType(), (String)tAutoMatchInfoParam.getBankCheckFlag(), (Date)tAutoMatchInfoParam.getBizDate());
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
    }

    private String getUpdateSql(AutoMatchInfoParam autoMatchInfoParam, TccLockEnum lock) {
        String updateSql = null;
        if (TccLockEnum.TRY == lock) {
            if ("buy".equals(autoMatchInfoParam.getTraceType())) {
                updateSql = "UPDATE t_cas_exchangebill set fversion=?,fbuyispreflag='1' where fversion=' ' and fbuymatchflag in ('0','2') and fbuyispreflag='0' and fid=?";
            } else if ("sell".equals(autoMatchInfoParam.getTraceType())) {
                updateSql = "UPDATE t_cas_exchangebill set fversion=?,fsellispreflag='1' where fversion=' ' and fsellmatchflag in ('0','2') and fsellispreflag='0' and fid=?";
            } else if ("fee".equals(autoMatchInfoParam.getTraceType())) {
                updateSql = "UPDATE t_cas_exchangebill set fversion=?,ffeeispreflag='1' where fversion=' ' and ffeematchflag in ('0','2') and ffeeispreflag='0' and fid=?";
            }
        } else if ("buy".equals(autoMatchInfoParam.getTraceType())) {
            updateSql = "UPDATE t_cas_exchangebill set fversion=' ',fbuyispreflag='0' where fversion=? and fbuyispreflag='1' and fid=?";
        } else if ("sell".equals(autoMatchInfoParam.getTraceType())) {
            updateSql = "UPDATE t_cas_exchangebill set fversion=' ',fsellispreflag='0' where fversion=? and fsellispreflag='1' and fid=?";
        } else if ("fee".equals(autoMatchInfoParam.getTraceType())) {
            updateSql = "UPDATE t_cas_exchangebill set fversion=' ',ffeeispreflag='0' where fversion=? and ffeeispreflag='1' and fid=?";
        }
        return updateSql;
    }
}

