/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Base64;
import kd.bos.encrypt.Encrypters;

public class AmountHelper {
    public static String encodeAmount(BigDecimal amount) {
        BigDecimal amt = amount.setScale(6, RoundingMode.DOWN);
        return Encrypters.encode((String)amt.toString());
    }

    public static BigDecimal decodeAmount(String encryptAmount) {
        if (encryptAmount == null || encryptAmount.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        if (Encrypters.isEncrypted((String)encryptAmount)) {
            return new BigDecimal(Encrypters.decode((String)encryptAmount));
        }
        return new BigDecimal(new String(Base64.getDecoder().decode(encryptAmount)));
    }

    public static String getAmtFormat(BigDecimal amt, Integer amtPrecision) {
        amt = amt.setScale((int)amtPrecision, RoundingMode.HALF_UP);
        StringBuilder format = new StringBuilder(",###");
        if (amtPrecision > 0) {
            format.append(".");
            for (int i = 0; i < amtPrecision; ++i) {
                format.append("0");
            }
        }
        return new DecimalFormat(format.toString()).format(amt);
    }
}

