/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class BeiBotpHelper {
    private static final Log logger = LogFactory.getLog(BeiBotpHelper.class);

    public static DynamicObject[] push(DynamicObject[] srcBills, String targetEntity, String ruleId) {
        logger.info("[BeiBotpHelper]push size\uff1a{}, targetEntity\uff1a{}, ids\uff1a{}", new Object[]{srcBills.length, targetEntity, Arrays.stream(srcBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet())});
        PushArgs pushArgs = new PushArgs();
        String srcEntityName = srcBills[0].getDataEntityType().getName();
        pushArgs.setSourceEntityNumber(srcEntityName);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAppId("");
        pushArgs.setRuleId("");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            pushArgs.setRuleId(ruleId);
        }
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : srcBills) {
            ListSelectedRow row = new ListSelectedRow((Object)srcBill.getLong("id"));
            selectedRows.add(row);
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            logger.error("BeiBotpHelper.push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDBizException(ec, new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs.toArray(new DynamicObject[0]);
    }

    private static void doException(DynamicObject detailDO, String errorStr, boolean isThrowErr, OperationResult result) {
        if (isThrowErr) {
            throw new KDBizException(errorStr);
        }
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(detailDO.getPkValue());
        operateErrorInfo.setMessage(errorStr);
        result.addErrorInfo(operateErrorInfo);
    }
}

