/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BeiHelper {
    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BeiHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg, String title) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(title);
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView view) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        int errorCount = operationResult.getAllErrorInfo().size();
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u5f20\uff0c\u5931\u8d25%4$s\u5f20", (String)"RecWorkbenchPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]), operationResult.getBillCount(), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, operationResult.getBillCount() - errorCount, errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        view.showForm(parameters);
    }

    public static void getPdfPutStream(String sourceUrl, List<byte[]> resList) throws IOException {
        int len;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fs.getInputStream(sourceUrl);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = ins.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        resList.add(bos.toByteArray());
        ins.close();
    }

    public static byte[] getPdfPutStream(String sourceUrl) throws IOException {
        return BeiHelper.getPdfPutStream(sourceUrl, "");
    }

    public static byte[] getPdfPutStream(String sourceUrl, String type) throws IOException {
        int len;
        InputStream ins;
        if ("new".equals(type)) {
            ins = BosPrintServiceHelper.getFileInputStream((String)sourceUrl);
        } else {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            ins = fs.getInputStream(sourceUrl);
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = ins.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        ins.close();
        if (bos.toString().contains("file is not exist")) {
            return new byte[0];
        }
        return bos.toByteArray();
    }

    public static void showConditionForm(IFormView view, String entityNumber, String conditionJson, CloseCallBack closeCallBack) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(entityNumber);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fldNodes = JSON.toJSONString((Object)billTreeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "true");
        showParameter.getCustomParams().put("treenodes", fldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static boolean isReceiptFileFromBank(DynamicObject receipt) {
        if (receipt.containsProperty("datasource") && receipt.containsProperty("fileflag") && receipt.containsProperty("uploadfilename")) {
            return DataSourceEnum.FROMBANK.getValue().equals(receipt.getString("datasource")) && receipt.getBoolean("fileflag") && EmptyUtil.isNoEmpty((String)receipt.getString("uploadfilename"));
        }
        return false;
    }
}

