/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.constants.ReceiptInfoBean;
import kd.tmc.bei.common.constants.ReceiptRecongnizeDetail;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.bei.common.util.FileContentUtils;
import kd.tmc.fbp.common.bean.Reconciliation;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.OFDReconciliationUtils;
import org.apache.commons.io.FilenameUtils;

public class OfdFileParseHelper {
    private static final Log logger = LogFactory.getLog(OfdFileParseHelper.class);

    public static String uploadAndGenResult(InputStream ins, String name, List<DealResultBean> results, DealResultBean result) {
        result.setFileName(name);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String path = "/" + tenantId + "/" + accountId + "/" + DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyyMMdd") + "/statement/" + name;
        result.setFileURL(path);
        logger.info("\u6587\u4ef6path:" + path);
        FileItem fi = new FileItem(path, path, ins);
        logger.info("\u6587\u4ef6pathfi" + fi);
        String upload = fs.upload(fi);
        logger.info("\u6587\u4ef6upload:" + upload);
        try {
            String desPlace = "./".concat(name);
            OutputStream out = TmcAttachmentHelper.downloadFile((String)desPlace, (String)upload);
            File ofdFile = TmcAttachmentHelper.getFile((OutputStream)out, (String)upload, (String)desPlace);
            if (ofdFile != null) {
                OFDReconciliationUtils ofdReconciliationUtils = new OFDReconciliationUtils();
                String canonicalPath = ofdFile.getCanonicalPath();
                Reconciliation reconciliation = ofdReconciliationUtils.parseOFDStructuredData(canonicalPath);
                if (reconciliation.getDetails().isEmpty()) {
                    result.setStatus("F");
                    result.addFailureReason(ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u5bf9\u8d26\u5355\u8bb0\u5f55\u3002", (String)"StatementImportTask_0", (String)"tmc-bei-common", (Object[])new Object[0]));
                    return "continue";
                }
                if (!ofdFile.delete()) {
                    logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\u6210\u529f");
                }
                OfdFileParseHelper.genStatement(reconciliation, result);
            }
        }
        catch (Exception e) {
            result.setStatus("F");
            result.addFailureReason(ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a%s\u3002", (String)"TransDetailFileTask_0", (String)"tmc-bei-common", (Object[])new Object[]{e}));
            logger.error((Throwable)e);
            results.add(result);
            return "continue";
        }
        return "";
    }

    private static void genStatement(Reconciliation reconciliation, DealResultBean result) {
        String currency;
        StringBuilder errorMessage = new StringBuilder();
        String accNo = reconciliation.getAccNo();
        if (EmptyUtil.isEmpty((String)accNo)) {
            errorMessage.append(ResManager.loadKDString((String)"\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"StatementImportTask_1", (String)"tmc-bei-common", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((String)(currency = reconciliation.getCurrency()))) {
            errorMessage.append(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"StatementImportTask_2", (String)"tmc-bei-common", (Object[])new Object[0]));
        }
        String year = reconciliation.getYear();
        String month = reconciliation.getMonth();
        if (EmptyUtil.isEmpty((String)year) || EmptyUtil.isEmpty((String)month)) {
            errorMessage.append(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"StatementImportTask_3", (String)"tmc-bei-common", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)errorMessage.toString())) {
            result.setStatus("F");
            result.addFailureReason(errorMessage.toString());
        } else {
            QFilter curFilter;
            DynamicObject queryCur;
            result.setAccno(accNo);
            result.setCurrency(currency);
            result.setPeriod(year + "-" + month);
            QFilter accFilter = new QFilter("bankaccountnumber", "=", (Object)accNo);
            DynamicObject queryAcc = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id", (QFilter[])accFilter.toArray());
            if (EmptyUtil.isEmpty((DynamicObject)queryAcc)) {
                result.setStatus("F");
                result.addFailureReason(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"StatementImportTask_4", (String)"tmc-bei-common", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(queryCur = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id", (QFilter[])(curFilter = new QFilter("number", "=", (Object)currency)).toArray())))) {
                result.setStatus("F");
                result.addFailureReason(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u5e01\u79cd\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"StatementImportTask_5", (String)"tmc-bei-common", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)queryAcc) && EmptyUtil.isNoEmpty((DynamicObject)queryCur)) {
                Long accountId = (Long)queryAcc.getPkValue();
                QFilter qFilter = new QFilter("accountbank", "=", (Object)accountId);
                Long currencyId = (Long)queryCur.getPkValue();
                qFilter.and("currency", "=", (Object)currencyId);
                qFilter.and("period", "=", (Object)DateUtils.stringToDate((String)(year + month), (String)"yyyyMM"));
                boolean existsFileImport = QueryServiceHelper.exists((String)"bei_elecstatement", (QFilter[])new QFilter[]{qFilter, new QFilter("datasource", "=", (Object)DataSourceEnum.FILEIMPORT.getValue())});
                if (existsFileImport) {
                    result.setPreValidate(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u5982\u679c\u7ee7\u7eed\u5bfc\u5165\u5c06\u8fdb\u884c\u8986\u76d6\u66f4\u65b0\u3002", (String)"StatementImportTask_6", (String)"tmc-bei-common", (Object[])new Object[0]));
                }
            }
        }
        if (!"F".equals(result.getStatus())) {
            result.setStatus("S");
            String jsonStr = JSONObject.toJSONString((Object)reconciliation);
            result.setJson(jsonStr);
        } else {
            result.setPreValidate(ResManager.loadKDString((String)"\u672a\u68c0\u9a8c", (String)"LeadInCheck_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (!"F".equals(result.getPreStatus())) {
            result.setPreStatus("S");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReceiptInfoBean genReceiptOfdParseResult(String uploadPath, String fileName) {
        ReceiptInfoBean receiptInfoBean = new ReceiptInfoBean();
        String desPlace = "./".concat(fileName);
        OutputStream out = TmcAttachmentHelper.downloadFile((String)desPlace, (String)uploadPath);
        File ofdFile = TmcAttachmentHelper.getFile((OutputStream)out, (String)uploadPath, (String)desPlace);
        if (ofdFile != null && ofdFile.exists()) {
            FileContentUtils fileContentUtils = new FileContentUtils();
            try {
                ReceiptRecongnizeDetail parseResult = fileContentUtils.parseReceiptOFDStructuredData(ofdFile.getCanonicalPath());
                receiptInfoBean.setRecongnizeDetail(parseResult);
                receiptInfoBean.setErrorInfo("");
            }
            catch (Exception e) {
                receiptInfoBean.setErrorInfo(e.getMessage());
                logger.error("genReceiptOfdParseResultException: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                try {
                    out.close();
                    if (EmptyUtil.isNoEmpty((String)FilenameUtils.getPath((String)fileName))) {
                        Files.deleteIfExists(Paths.get(FilenameUtils.getPath((String)fileName), new String[0]));
                    }
                }
                catch (Exception e) {
                    logger.error("Delete temp files fail: " + e.getMessage() + desPlace);
                }
            }
        }
        return receiptInfoBean;
    }
}

