/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OrgHelper {
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String NO_LEGAL_PERSON = "3";

    public static DynamicObject getSuperiorBankOrg(String attributes, long orgId) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)attributes, (long)orgId);
        if (superiorOrgs == null || superiorOrgs.size() < 1) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id, orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", superiorOrgs.get(0))});
        return org;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        String appId = AppMetadataCache.getAppInfo((String)"bei").getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(ORGTYPE_BANKROLL, "=", (Object)Boolean.TRUE);
        if (allPermOrgs.hasAllOrgPerm()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    orgIds.add(row.getLong("id"));
                }
            }
        }
        List orgIdList = allPermOrgs.getHasPermOrgs();
        QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                orgIds.add(row.getLong("id"));
            }
        }
        return orgIds;
    }

    public static QFilter getQFilterAuthorizedOrgId(Long userID, String appNum, String entityNum, String permissionItem, String field) {
        String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userID, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)entityNum, (String)permissionItem);
        if (allPermOrgs.hasAllOrgPerm()) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.FALSE);
            boolean hasDis = QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{enableFilter});
            if (hasDis) {
                enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter functionFilter = new QFilter(ORGTYPE_BANKROLL, "=", (Object)"1");
                ArrayList<Long> result = new ArrayList<Long>();
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter}, null);){
                    for (Row row : ds) {
                        result.add(row.getLong("id"));
                    }
                }
                return new QFilter(field, "in", result);
            }
            return null;
        }
        List orgIdList = allPermOrgs.getHasPermOrgs();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(ORGTYPE_BANKROLL, "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgId", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter}, null);){
            for (Row row : ds) {
                result.add(row.getLong("id"));
            }
        }
        return new QFilter(field, "in", result);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static boolean hasPermission(String appNum, long userId, long orgId, String entityNum, String permissionItemId) {
        int res = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)AppMetadataCache.getAppInfo((String)appNum).getId(), (String)entityNum, (String)permissionItemId);
        return res == 1;
    }

    public static Boolean getCacheUserPermission(Long userId, String appId, String entityId, String permItem) {
        IAppCache cache = AppCache.get((String)"bei..TmcOrgDataHelper");
        String key = userId + "-" + entityId + "-" + permItem;
        cache.remove(key);
        String value = (String)cache.get(key, String.class);
        if (EmptyUtil.isEmpty((String)value)) {
            HasPermOrgResult result;
            if (EmptyUtil.isNotEmpty((CharSequence)appId)) {
                appId = AppMetadataCache.getAppInfo((String)appId).getId();
            }
            if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem)).hasAllOrgPerm()) {
                return true;
            }
        }
        return false;
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String entityID, String permissionItem) {
        Map orgs;
        String appId = AppMetadataCache.getAppInfo((String)"bei").getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(ORGTYPE_ACCOUNTING, "=", (Object)Boolean.TRUE);
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem, String funType) {
        Map orgs;
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(funType, "=", (Object)Boolean.TRUE);
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }
}

