/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.init;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class PayUpdateStatusUpService {
    private static final Log LOGGER = LogFactory.getLog(PayUpdateStatusUpService.class);

    public static void update() {
        try (TXHandle h = TX.requiresNew((String)"PayUpdateStatusUpService");){
            try {
                DataSet upCount = DB.queryDataSet((String)"upCount", (DBRoute)DBRouteConst.TMC, (String)"SELECT COUNT(1) count FROM t_bei_updatepaystat");
                int count = ((Row)upCount.iterator().next()).getInteger("count");
                int page = 0;
                if (count > 50000) {
                    page = count / 50000;
                }
                for (int j = 0; j < page + 1; ++j) {
                    int startsize = j * 50000;
                    int endsize = (j + 1) * 50000;
                    DataSet dataSet = PayUpdateStatusUpService.queryDataSet(startsize, endsize);
                    ArrayList<Object[]> batchParam = new ArrayList<Object[]>(10);
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long sourceBillId = row.getLong("fsourcebillid");
                        String sourceBillNo = row.getString("fsourcebillno");
                        String isEncrypTion = row.getString("fisencryption");
                        Long currencyId = row.getLong("fcurrencyid");
                        Long id = row.getLong("fid");
                        batchParam.add(new Object[]{sourceBillId, sourceBillNo, isEncrypTion, currencyId, id});
                    }
                    PayUpdateStatusUpService.executeBatch(batchParam);
                }
                LOGGER.info("\u5171" + count + "\u6761\u6570\u636e\u3002");
                upCount.close();
            }
            catch (Exception ee) {
                LOGGER.error("PayUpdateStatusUpService===============" + ee);
            }
        }
    }

    private static DataSet queryDataSet(int startsize, int endsize) {
        return DB.queryDataSet((String)"queryUpdatePayStat", (DBRoute)DBRouteConst.TMC, (String)"select fsourcebillid,fsourcebillno,fisencryption,fcurrencyid,fid  from t_bei_updatepaystat where fsourcebillid  != 0 and fsourcebillno != ' '").limit(startsize, endsize);
    }

    private static void executeBatch(List<Object[]> batchParam) {
        String sql = "UPDATE t_bei_updatepaystat_entry SET fsourcebillid = ?,fsourcebillno = ?,fisencryption = ?,fcurrencyid = ? where  Fid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, batchParam);
    }
}

