/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BalanceAddByHand
extends AbstractTmcBillEdit {
    private static final Log logger = LogFactory.getLog(BalanceAddByHand.class);
    private static final String KEY_OVERRIDE = "isOverride";
    private static final String SYSTEM_TYPE = "tmc-bei-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.bankAcctF7Init();
        this.currencyF7Init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amount", null);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"valibalance", null);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"lstbalance", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        switch (fieldName = e.getProperty().getName()) {
            case "accountbank": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("accountbank"))) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", null);
                    break;
                }
                DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", (Object)accountBank.getDynamicObject("defaultcurrency"));
                Set currencyIds = accountBank.getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                this.getView().setEnable(Boolean.valueOf(currencyIds.size() != 1), new String[]{"currency"});
                this.checkOverride();
                break;
            }
            case "amount": {
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                if (!EmptyUtil.isNoEmpty((BigDecimal)amount)) break;
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"valibalance", (Object)amount);
                break;
            }
            case "bizdate": 
            case "currency": {
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("accountbank")) || !EmptyUtil.isNoEmpty((Object)this.getModel().getValue("currency"))) break;
                this.checkOverride();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            if (this.getModel().getValue("accountbank") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BalanceAddByHand_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.getModel().getValue("amount") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5f53\u524d\u4f59\u989d\u3002", (String)"BalanceAddByHand_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject balance = BalanceHelper.checkIfExist((ModelAgent)new ModelAgent((Object)this.getModel()));
            if (!EmptyUtil.isEmpty((DynamicObject)balance)) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u5df2\u5b58\u5728%1$s\u7684%2$s\u4f59\u989d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\u66f4\u65b0\uff1f", (String)"BalanceAddByHand_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), DateUtils.formatString((Date)((Date)this.getModel().getValue("bizdate")), (String)"yyyy-MM-dd"), currency.getString("name")), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_OVERRIDE, (IFormPlugin)this));
            } else {
                this.executeSaveOperation(false);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (KEY_OVERRIDE.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.executeSaveOperation(true);
        }
    }

    private void executeSaveOperation(boolean isOverride) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        ArrayList saveBalanceList = new ArrayList();
        ArrayList updateBalanceList = new ArrayList();
        try {
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            BalanceHelper.handDoSaveBalanceOperation((int)0, Collections.singletonList(bizDate), (boolean)false, (boolean)isOverride, (ModelAgent)new ModelAgent((Object)this.getModel()), saveBalanceList, updateBalanceList);
            map.put("isSuccess", true);
        }
        catch (KDBizException e) {
            logger.error("\u624b\u5de5\u65b0\u589e\u4f59\u989d\u4fdd\u5b58\u5931\u8d25 {}", (Object)e.getMessage());
            map.put("isSuccess", false);
        }
        if (saveBalanceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveBalanceList.toArray(new DynamicObject[0]));
        }
        if (updateBalanceList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBalanceList.toArray(new DynamicObject[0]));
        }
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void bankAcctF7Init() {
        BasedataEdit bankAcctF7 = (BasedataEdit)this.getControl("accountbank");
        bankAcctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_bankbalance", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("company", "in", (Object)authOrgList);
            qFilter.and("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            qFilter.and("isvirtual", "=", (Object)"0");
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{qFilter.copy().and("entry.e_bankfunction", "=", (Object)BankFuncEnum.QUERY.getValue()).and("entry.e_enable", "=", (Object)"1")});
            QFilter interfaceFilter = banks != null && !banks.isEmpty() ? new QFilter("issetbankinterface", "=", (Object)"0").or(new QFilter("id", "not in", banks.stream().map(b -> b.getLong("id")).collect(Collectors.toSet())).and("entry.e_enable", "=", (Object)"1")) : new QFilter("issetbankinterface", "=", (Object)"0").or(new QFilter("entry.e_enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter.and(interfaceFilter));
        });
    }

    private void currencyF7Init() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("accountbank"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BalanceAddByHand_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
                Set currencyIds = accountBank.getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", currencyIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void checkOverride() {
        DynamicObject balance = BalanceHelper.checkIfExist((ModelAgent)new ModelAgent((Object)this.getModel()));
        if (EmptyUtil.isNoEmpty((DynamicObject)balance)) {
            this.getModel().setValue("amount", (Object)balance.getBigDecimal("amount"));
            this.getModel().setValue("valibalance", (Object)balance.getBigDecimal("valibalance"));
            this.getModel().setValue("freezebalance", (Object)balance.getBigDecimal("freezebalance"));
            this.getModel().setValue("lstbalance", (Object)balance.getBigDecimal("lstbalance"));
        }
    }
}

