/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BalanceBatchAddDetail
extends AbstractTmcBillEdit {
    private static final Log logger = LogFactory.getLog(BalanceBatchAddDetail.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_OVERRIDE = "isoverride";
    private static final String KEY_SUCCESS = "isSuccess";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String SYSTEM_TYPE = "tmc-bei-formplugin";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"amount", null);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"valibalance", null);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"lstbalance", null);
        this.detailBalanceInit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (fieldName.equals("amount")) {
            ChangeData[] changeSet;
            for (ChangeData changeData : changeSet = e.getChangeSet()) {
                DynamicObject dataEntity = changeData.getDataEntity();
                dataEntity.set("valibalance", changeData.getNewValue());
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(ENTRY_ENTITY);
            ArrayList<Object> balanceList = new ArrayList<Object>(10);
            ArrayList<String> tipList = new ArrayList<String>(10);
            for (Object entryEntity : entryEntities) {
                if (entryEntity.getInt(KEY_OVERRIDE) != 1) continue;
                balanceList.add(entryEntity);
                DynamicObject bankAcct = entryEntity.getDynamicObject("accountbank");
                DynamicObject currency = entryEntity.getDynamicObject("currency");
                tipList.add(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5df2\u5b58\u5728%2$s\u7684%3$s\u4f59\u989d\u3002", (String)"BalanceBatchAddDetail_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), bankAcct.getString("number"), DateUtils.formatString((Date)entryEntity.getDate("bizdate"), (String)"yyyy-MM-dd"), currency.getString("name")));
            }
            if (!balanceList.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String tip : tipList) {
                    stringBuilder.append(tip);
                    stringBuilder.append(" \n");
                }
                stringBuilder.append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u8986\u76d6\u66f4\u65b0\uff1f", (String)"BalanceBatchAddDetail_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().showConfirm(stringBuilder.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_OVERRIDE, (IFormPlugin)this));
            } else {
                this.executeSaveOperation();
            }
        } else if ("save".equals(operateKey) && !args.getOperationResult().isSuccess()) {
            OperationResult opResult = args.getOperationResult();
            opResult.setShowMessage(false);
            int entrySize = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY).size();
            ArrayList<String> errorMsg = new ArrayList<String>(entrySize);
            List allErrorInfo = ((ValidateResult)opResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                errorMsg.add(errorInfo.getMessage());
            }
            String errorMsgDetail = String.join((CharSequence)"\r\n", errorMsg);
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u884c\u5206\u5f55\uff0c\u4fdd\u5b58\u6210\u529f0\u884c\uff0c\u5931\u8d25%1$s\u884c\u3002", (String)"BalanceBatchAddDetail_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), entrySize);
            this.getView().showMessage(title, errorMsgDetail, MessageTypes.Default);
        } else if ("cancel".equals(operateKey)) {
            this.getView().returnDataToParent(Collections.singletonMap("cancel", true));
            this.getView().close();
        }
    }

    private void executeSaveOperation() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        ArrayList saveBalanceList = new ArrayList();
        ArrayList updateBalanceList = new ArrayList();
        try {
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(ENTRY_ENTITY);
            BalanceHelper.handDoBatchSaveBalanceOperation((DynamicObjectCollection)entryEntities, saveBalanceList, updateBalanceList);
            map.put(KEY_SUCCESS, true);
        }
        catch (KDBizException e) {
            logger.error("\u624b\u5de5\u65b0\u589e\u4f59\u989d\u4fdd\u5b58\u5931\u8d25 {}", (Object)e.getMessage());
            map.put(KEY_SUCCESS, false);
        }
        if (saveBalanceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveBalanceList.toArray(new DynamicObject[0]));
        }
        if (updateBalanceList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBalanceList.toArray(new DynamicObject[0]));
        }
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntities;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey) && (entryEntities = this.getModel().getEntryEntity(ENTRY_ENTITY)).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f59\u989d\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u540e\u4fdd\u5b58\u3002", (String)"BalanceBatchAddDetail_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (KEY_OVERRIDE.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.executeSaveOperation();
        }
    }

    private void detailBalanceInit() {
        Date endDate;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Date startDate = DateFormatUtil.FormatDate((String)((String)formShowParameter.getCustomParam(START_DATE)));
        boolean isOneDay = startDate.compareTo(endDate = DateFormatUtil.FormatDate((String)((String)formShowParameter.getCustomParam(END_DATE)))) == 0;
        JSONArray params = (JSONArray)formShowParameter.getCustomParam("accountbank");
        HashSet<Long> ids = new HashSet<Long>(10);
        for (int i = 0; i < params.size(); ++i) {
            JSONObject param = params.getJSONObject(i);
            JSONObject dy = param.getJSONObject("fbasedataid");
            ids.add(dy.getLong("id"));
        }
        String selectStr = "id, bankaccountnumber, company, currency, bizdate, bank, acctname";
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectStr, (QFilter[])new QFilter("id", "in", ids).toArray());
        QFilter qFilter = new QFilter("accountbank", "in", ids);
        if (isOneDay) {
            qFilter.and(new QFilter("bizdate", "=", (Object)startDate));
        } else {
            qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
            qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        HashMap keyValue = new HashMap(10);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"queryExistBalance", (String)"bei_bankbalance", (String)"accountbank.id,currency.id,bizdate,amount,valibalance,freezebalance,lstbalance", (QFilter[])qFilter.toArray(), null);
        while (ds.hasNext()) {
            Row row = ds.next();
            String string = row.getString("accountbank.id") + "-" + row.getString("currency.id") + "-" + DateUtils.formatString((Date)row.getDate("bizdate"), (String)"yyyy-MM-dd");
            HashMap<String, BigDecimal> fieldValue = new HashMap<String, BigDecimal>(4);
            fieldValue.put("amount", row.getBigDecimal("amount"));
            fieldValue.put("valibalance", row.getBigDecimal("valibalance"));
            fieldValue.put("freezebalance", row.getBigDecimal("freezebalance"));
            fieldValue.put("lstbalance", row.getBigDecimal("lstbalance"));
            keyValue.put(string, fieldValue);
        }
        ds.close();
        ArrayList dataMapList = new ArrayList(10);
        for (DynamicObject account : accounts) {
            DynamicObjectCollection currencies = account.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencies) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(startDate);
                while (calendar.getTime().compareTo(endDate) <= 0) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(10);
                    dataMap.put("company", account.getDynamicObject("company"));
                    dataMap.put("accountbank", account);
                    dataMap.put("currency", currency.getDynamicObject("fbasedataid"));
                    dataMap.put("bizdate", calendar.getTime());
                    dataMap.put("bank", account.getDynamicObject("bank").getString("name"));
                    dataMap.put("acctname", account.getString("acctname"));
                    String key = account.getString("id") + "-" + currency.getDynamicObject("fbasedataid").getString("id") + "-" + DateUtils.formatString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                    Map value = (Map)keyValue.get(key);
                    if (value != null) {
                        dataMap.put("amount", value.get("amount"));
                        dataMap.put("valibalance", value.get("valibalance"));
                        dataMap.put("freezebalance", value.get("freezebalance"));
                        dataMap.put("lstbalance", value.get("lstbalance"));
                        dataMap.put(KEY_OVERRIDE, 1);
                    }
                    dataMapList.add(dataMap);
                    ((Calendar)calendar).add(5, 1);
                }
            }
        }
        dataMapList.sort((m1, m2) -> {
            Date d1 = (Date)m1.get("bizdate");
            Date d2 = (Date)m2.get("bizdate");
            return d1.compareTo(d2);
        });
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        abstractFormDataModel.beginInit();
        TmcViewInputHelper.batchFillEntity((String)ENTRY_ENTITY, (AbstractFormDataModel)abstractFormDataModel, dataMapList);
        abstractFormDataModel.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.getModel().setDataChanged(dataChanged);
    }
}

