/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.helper.SyncQueryBankAccountHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankBalanceList
extends AbstractTmcBillBaseList {
    protected boolean disableDoubleClick() {
        return true;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        AccountBankHelper.filterContainerInitForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctToBillQf());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "transdetail": {
                IListView listview = (IListView)this.getView();
                DynamicObject bankbalanceData = TmcDataServiceHelper.loadSingle((Object)listview.getFocusRowPkId(), (String)"bei_bankbalance", (String)"company,accountbank,currency,bizdate,bank");
                Long companyId = bankbalanceData.getLong("company.id");
                Long accountBankId = bankbalanceData.getLong("accountbank.id");
                Long bankId = bankbalanceData.getLong("bank.id");
                Long currencyId = bankbalanceData.getLong("currency.id");
                Date bizDate = bankbalanceData.getDate("bizdate");
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("bei_transdetail_linkquery");
                showParameter.setFormId("bos_list");
                showParameter.setCustomParam("source", (Object)"bei_bankbalance");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("company.id", (Object)String.valueOf(companyId));
                showParameter.setCustomParam("bank", (Object)String.valueOf(bankId));
                showParameter.setCustomParam("accountbank.id", (Object)String.valueOf(accountBankId));
                showParameter.setCustomParam("currency.id", (Object)String.valueOf(currencyId));
                showParameter.setCustomParam("bizdate", (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "addbyhand": {
                if (!args.getOperationResult().isSuccess()) break;
                this.showBalanceAddView("bei_balanceadd_hand");
                break;
            }
            case "batchaddbyhand": {
                if (!args.getOperationResult().isSuccess()) break;
                this.showBalanceAddView("bei_balancebatchadd_base");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("barsynbalance".equals(key.toLowerCase(Locale.ENGLISH))) {
            this.syncBalance();
        }
    }

    private void syncBalance() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_synbalance");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        ControlFilters controlFilters = this.getControlFilters();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean updateFlag = false;
        if (this.getPageCache().get("beforeSelectCompany") == null) {
            List companyFilterList = controlFilters.getFilter("company.id");
            String companyId = JSON.toJSONString((Object)companyFilterList);
            this.getPageCache().put("beforeSelectCompany", companyId);
        } else {
            String companyId = this.getPageCache().get("beforeSelectCompany");
            List beforeCompanyList = JSON.parseArray((String)companyId, Object.class);
            List currentCompanyList = controlFilters.getFilter("company.id");
            List collect = currentCompanyList.stream().filter(e -> !beforeCompanyList.contains(e)).collect(Collectors.toList());
            boolean flag = collect.stream().allMatch(""::equals);
            if (!EmptyUtil.isEmpty(collect) && !flag) {
                updateFlag = true;
            }
        }
        SyncQueryBankAccountHelper.SyncAccount((ControlFilters)controlFilters, (FormShowParameter)showForm, (String)appId, (String)"bei_bankbalance", (boolean)updateFlag);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_synbalance"));
        this.getView().showForm(showForm);
    }

    private void showBalanceAddView(String entityName) {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId(entityName);
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityName));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"bei_synbalance")) {
            Map map = (Map)args.getReturnData();
            if (map != null && map.get("close") != null && "close".equals(map.get("close"))) {
                List accId = (List)map.get("accId");
                Date startdate = (Date)map.get("startdate");
                Date enddate = (Date)map.get("enddate");
                if (EmptyUtil.isNoEmpty((Object)accId)) {
                    DynamicObject[] schedules = BusinessDataServiceHelper.load((Object[])accId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_acctbank_schedule"));
                    HashMap<String, Object> param = new HashMap<String, Object>(8);
                    param.put("accountid", Arrays.stream(schedules).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                    param.put("startdate", DateUtils.formatString((Date)startdate, (String)"yyyy-MM-dd"));
                    param.put("enddate", DateUtils.formatString((Date)enddate, (String)"yyyy-MM-dd"));
                    this.startQueryBalanceTask(param);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u4e0b\u8f7d\u6bcf\u65e5\u4f59\u989d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BankBalanceList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        } else if ("bei_balanceadd_hand".equals(actionId) || "bei_balancebatchadd_base".equals(actionId)) {
            Map map = (Map)args.getReturnData();
            if (EmptyUtil.isEmpty((Object)map)) {
                return;
            }
            if (Boolean.TRUE.equals(map.get("isSuccess"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f59\u989d\u4fdd\u5b58\u6210\u529f\u3002", (String)"BankBalanceList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else if (Boolean.FALSE.equals(map.get("isSuccess"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f59\u989d\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BankBalanceList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void startQueryBalanceTask(Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        Date queryDate = new Date();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2%1$s\u3002", (String)"BankBalanceList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd HH:mm:ss")));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setAppId(TmcAppEnum.BEI.getValue());
        jobInfo.setTaskClassname("kd.tmc.bei.business.task.balance.QueryBalanceTask");
        params.put("view", this.getView().getPageId());
        params.put("RequestContext", SerializationUtils.toJsonString((Object)RequestContext.get()));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setTimeout(600);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        CloseCallBack closeCallBack = new CloseCallBack("kd.tmc.bei.business.task.balance.QuerybalanceCallBack", "background_actionid");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.tmc.bei.business.task.balance.QuerybalanceProgressClick");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }
}

