/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QueryBalanceProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHEKEY_TASKID = "taskid";

    public void registerListener(EventObject e) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object bankLogId = pkEvent.getRowData().get("banklogid");
            if (pkEvent.getSource() instanceof OperationColumn && EmptyUtil.isEmpty((Object)bankLogId) && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        String taskId = this.getTaskId();
        this.getPageCache().put("isLoadFinish", "0");
        if (EmptyUtil.isNoEmpty((String)taskId)) {
            this.updateQueryResult(taskId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        if (EmptyUtil.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.getProgress() != 100 || !taskInfo.isTaskEnd() || "0".equals(this.getPageCache().get("isLoadFinish"))) {
            this.updateQueryResult(taskId);
            if (taskInfo.getProgress() == 100) {
                this.getPageCache().put("isLoadFinish", "1");
                progressEvent.setProgress(99);
            } else {
                progressEvent.setProgress(taskInfo.getProgress());
            }
        } else {
            progressEvent.setProgress(100);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("querybanklog".equals(operateKey)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entry");
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            DynamicObject row = (DynamicObject)entryEntity.get(focusRow);
            long bankLogId = row.getLong("banklogid");
            if (EmptyUtil.isNoEmpty((Long)bankLogId)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("bei_banklog");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setPkId((Object)bankLogId);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void updateQueryResult(String taskId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entry");
        List existRequests = entryEntity.stream().map(r -> r.getLong("requestid")).collect(Collectors.toList());
        DynamicObjectCollection queryRequestRecords = QueryServiceHelper.query((String)"bei_queryrequest", (String)"id,accountbank.fbasedataid.id accountbank,currency.id currency,begindate,enddate,status,exception,publishtime,task.creator.id queryer", (QFilter[])new QFilter[]{new QFilter("task", "=", (Object)Long.valueOf(taskId)).and("id", "not in", existRequests)}, (String)"accountbank,currency,begindate");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)queryRequestRecords)) {
            return;
        }
        List requestIds = queryRequestRecords.stream().map(r -> r.get("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection banklogs = QueryServiceHelper.query((String)"bei_banklog", (String)"id,requestid", (QFilter[])new QFilter[]{new QFilter("requestid", "in", requestIds)});
        Map<Long, List<DynamicObject>> banklogMap = banklogs.stream().collect(Collectors.groupingBy(b -> b.getLong("requestid")));
        Long queryerId = ((DynamicObject)queryRequestRecords.get(0)).getLong("queryer");
        Map account = TmcDataServiceHelper.loadFromCache((Object[])queryRequestRecords.stream().map(r -> r.getLong("accountbank")).distinct().toArray(), (String)"am_accountbank");
        Map currency = TmcDataServiceHelper.loadFromCache((Object[])queryRequestRecords.stream().map(r -> r.getLong("currency")).distinct().toArray(), (String)"bd_currency");
        Map queryer = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{queryerId}, (String)"bos_user");
        HashSet<Long> accountIds = new HashSet<Long>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        HashSet<Date> dates = new HashSet<Date>(16);
        ArrayList<Integer> indexs = new ArrayList<Integer>(10);
        for (DynamicObject record : queryRequestRecords) {
            Long accountId = record.getLong("accountbank");
            Long currencyId = record.getLong("currency");
            Long requestId = record.getLong("id");
            String status = record.getString("status");
            Date startDate = record.getDate("begindate");
            Date endDate = record.getDate("enddate");
            ArrayList<Date> queryDates = new ArrayList<Date>(10);
            while (endDate.compareTo(startDate) >= 0) {
                queryDates.add(startDate);
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
            }
            for (Date date : queryDates) {
                int newEntryRow = this.getModel().createNewEntryRow("entry");
                model.setValue("accountbank", account.get(accountId), newEntryRow);
                model.setValue("currency", currency.get(currencyId), newEntryRow);
                model.setValue("date", (Object)date, newEntryRow);
                model.setValue("requestid", (Object)requestId, newEntryRow);
                model.setValue("queryer", queryer.get(queryerId), newEntryRow);
                model.setValue("querytime", (Object)record.getDate("publishtime"), newEntryRow);
                model.setValue("status", (Object)status, newEntryRow);
                model.setValue("resultinfo", (Object)record.getString("exception"), newEntryRow);
                if (banklogMap.containsKey(requestId)) {
                    model.setValue("banklogid", (Object)banklogMap.get(requestId).get(0).getLong("id"), newEntryRow);
                }
                if (!QueryRequestStatusEnum.SUCCESS.getValue().equals(status)) continue;
                accountIds.add(accountId);
                currencyIds.add(currencyId);
                dates.addAll(queryDates);
                indexs.add(newEntryRow);
            }
        }
        this.getView().updateView("entry");
        this.updateBankBalance(accountIds, currencyIds, dates, indexs);
    }

    private void updateBankBalance(Set<Long> accountIds, Set<Long> currencyIds, Set<Date> dates, List<Integer> indexs) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entry");
        QFilter qFilter = new QFilter("accountbank", "in", accountIds).and("currency", "in", currencyIds).and("bizdate", "in", dates);
        DynamicObjectCollection bankBalances = QueryServiceHelper.query((String)"bei_bankbalance", (String)"id,accountbank.id,currency.id,bizdate,amount,valibalance,lstbalance,freezebalance,modifytime", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
        for (int index : indexs) {
            DynamicObject row = (DynamicObject)entry.get(index);
            DynamicObject bankBalance = bankBalances.stream().filter(b -> row.getDynamicObject("accountbank").getPkValue().equals(b.get("accountbank.id")) && row.getDynamicObject("currency").getPkValue().equals(b.get("currency.id")) && row.get("date").equals(b.get("bizdate"))).findFirst().orElse(null);
            if (bankBalance == null) continue;
            model.setValue("amount", (Object)bankBalance.getBigDecimal("amount"), index);
            model.setValue("lstbalance", (Object)bankBalance.getBigDecimal("lstbalance"), index);
            model.setValue("valibalance", (Object)bankBalance.getBigDecimal("valibalance"), index);
            model.setValue("freezebalance", (Object)bankBalance.getBigDecimal("freezebalance"), index);
            model.setValue("modifytime", (Object)bankBalance.getDate("modifytime"), index);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }
}

