/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.bei.common.helper.SyncAutoBalanceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SyncAutoBalance
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private static final Log logger = LogFactory.getLog(SyncAutoBalance.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountBank = (BasedataEdit)this.getControl("accountbank");
        accountBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String genBanlanceWay;
        String first;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List companyIdList = (List)customParams.get("companyIdList");
        if (EmptyUtil.isNoEmpty((Object)companyIdList) && !"".equals(first = String.valueOf(companyIdList.get(0))) && "0".equals(genBanlanceWay = (String)TmcParameterHelper.getAppParameter((String)TmcAppEnum.BEI.getId(), (Long)Long.valueOf(first), (String)"bei010"))) {
            DynamicObject[] load = TmcDataServiceHelper.load((Object[])companyIdList.stream().map(s -> Long.parseLong(s.toString())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            DynamicObjectCollection orgColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"org", (DynamicObject[])load);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"org", (Object)orgColls);
        }
        Date currentDate = DateUtils.getCurrentDate();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"startdate", (Object)currentDate);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"enddate", (Object)currentDate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        switch (fieldName = e.getProperty().getName()) {
            case "org": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"accountbank", null);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", null);
                break;
            }
            case "accountbank": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if ("org".equals(property)) {
            logger.info("\u8fdb\u5165SyncAutoBalance\u7684F7\u65b9\u6cd5");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            AppParam param = new AppParam();
            param.setAppId(TmcAppEnum.BEI.getId());
            param.setViewType("08");
            long paraStartTime = System.currentTimeMillis();
            Long userId = RequestContext.get().getCurrUserId();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)formShowParameter.getAppId(), (String)"bei_betransdetail_imp", (String)"47150e89000000ac");
            logger.info("\u6709\u6743\u9650\u7684\u6240\u6709\u7ec4\u7ec7ID:" + authOrgIds.toString());
            Map orgSystemParams = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, (List)authOrgIds);
            long paraCostTime = System.currentTimeMillis() - paraStartTime;
            logger.info("\u67e5\u8be2\u53c2\u6570\u8017\u65f6\uff1a" + paraCostTime);
            Set filterOrgIds = orgSystemParams.entrySet().stream().filter(e -> e.getValue() != null && ((Map)e.getValue()).containsKey("bei010") && StringUtils.equals((CharSequence)((String)((Map)e.getValue()).get("bei010")), (CharSequence)"0")).map(t -> Long.valueOf((String)t.getKey())).collect(Collectors.toSet());
            logger.info("\u6709\u6743\u9650\u7684\u4e14\u7cfb\u7edf\u53c2\u6570\u4e3a\u6309\u7167\u4ea4\u6613\u660e\u7ec6\u4f59\u989d\u81ea\u52a8\u751f\u6210\uff08\u5bfc\u5165\u89e6\u53d1\uff09\u7684\u7ec4\u7ec7ID:" + filterOrgIds.toString());
            QFilter orgFilter = new QFilter("id", "in", filterOrgIds);
            qFilters.add(orgFilter);
        } else if ("accountbank".equals(property)) {
            boolean mustInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"org");
            if (!mustInput) {
                evt.setCancel(true);
            } else {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
                List orgIds = org.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter qFilter = SyncAutoBalanceHelper.getAccountBankQfilter(orgIds);
                qFilters.add(qFilter);
            }
        } else if ("currency".equals(property)) {
            boolean mustInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"accountbank");
            if (!mustInput) {
                evt.setCancel(true);
            } else {
                DynamicObjectCollection accountBank = (DynamicObjectCollection)this.getModel().getValue("accountbank");
                List accountIds = accountBank.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", accountIds);
                DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"currency.fbasedataid.id as currencyid", (QFilter[])qFilter.toArray());
                Set currencyIds = accountBanks.stream().map(o -> o.getLong("currencyid")).collect(Collectors.toSet());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qFilters = filterParam.getQFilters();
                QFilter qCurrency = new QFilter("id", "in", currencyIds);
                qFilters.add(qCurrency);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "sync".equals(operateKey)) {
            String traceId = RequestContext.get().getTraceId();
            String messageStr = (String)cache.get("auto_balance_cache_message_list_" + traceId);
            HashMap<String, String> returnData = new HashMap<String, String>(4);
            returnData.put("message", messageStr);
            cache.remove("auto_balance_cache_message_list_" + traceId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

