/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.banklog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BankLogTreeEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(BankLogTreeEdit.class);

    public void registerListener(EventObject e) {
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject logInfo = this.getModel().getDataEntity();
        JSONObject sendInfo = JSON.parseObject((String)logInfo.getString("sendinfo"));
        JSONObject receiveInfo = JSON.parseObject((String)logInfo.getString("receiveinfo"));
        if ("bei_bankagentpay".equals(this.getModel().getValue("sourcebilltype"))) {
            if (this.isEncryption()) {
                JSONObject maskData = new JSONObject();
                JSONObject body = new JSONObject();
                JSONObject datails = new JSONObject();
                datails.put("amount", (Object)"**.**");
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)datails);
                body.put("details", (Object)jsonArray);
                maskData.put("body", (Object)body);
                BankLogTreeEdit.dataMask(sendInfo, maskData);
                BankLogTreeEdit.dataMask(receiveInfo, maskData);
                this.getModel().setValue("isencryption", (Object)true);
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isencryption"});
        }
        this.builtTree(sendInfo, "sendinfo_tree");
        this.builtTree(receiveInfo, "recinfo_tree");
    }

    private void builtTree(JSONObject json, String treeKey) {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BankLogTreeEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        String nodeID = UUID.randomUUID().toString();
        root.addChildren(this.builtTreeNode(json, nodeID));
        TreeView tView = (TreeView)this.getControl(treeKey);
        tView.addNode(root);
    }

    private List<TreeNode> builtTreeNode(JSONObject json, String parentId) {
        ArrayList<TreeNode> childrenNodes = new ArrayList<TreeNode>();
        if (json == null) {
            return childrenNodes;
        }
        String bankLogType = this.getModel().getDataEntity().getString("banklogtype");
        boolean isPay = "pay".equals(bankLogType) || "overseaPay".equals(bankLogType) || "queryPay".equals(bankLogType) || "queryOverseaPay".equals(bankLogType);
        for (Map.Entry entry : json.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                TreeNode treeNode = this.builtTreeNode(parentId, (String)entry.getKey());
                treeNode.addChildren(this.builtTreeNode((JSONObject)value, treeNode.getId()));
                childrenNodes.add(treeNode);
                continue;
            }
            if (value instanceof JSONArray) {
                if (isPay && "details".equals(entry.getKey())) {
                    value = this.detailProcess((JSONArray)value);
                }
                for (int i = 0; i < ((JSONArray)value).size(); ++i) {
                    TreeNode arrayNode = null;
                    Object obj = ((JSONArray)value).get(i);
                    StringBuilder text = new StringBuilder();
                    if (obj instanceof JSONObject || obj instanceof JSONArray) {
                        text.append((String)entry.getKey());
                        text.append("[");
                        text.append(i);
                        text.append("]");
                        arrayNode = this.builtTreeNode(parentId, text.toString());
                        arrayNode.addChildren(this.builtTreeNode((JSONObject)obj, arrayNode.getId()));
                    } else {
                        text.append((String)entry.getKey());
                        text.append("[");
                        text.append(i);
                        text.append("] : ");
                        text.append(((JSONArray)value).get(i));
                        arrayNode = this.builtTreeNode(parentId, text.toString());
                    }
                    childrenNodes.add(arrayNode);
                }
                continue;
            }
            StringBuilder text = new StringBuilder();
            text.append((String)entry.getKey());
            text.append(" : ");
            text.append(value);
            childrenNodes.add(this.builtTreeNode(parentId, text.toString()));
        }
        return childrenNodes;
    }

    private TreeNode builtTreeNode(String parentId, String text) {
        TreeNode node = new TreeNode();
        String nodeID = UUID.randomUUID().toString();
        node.setId(nodeID);
        node.setParentid(parentId);
        node.setText(text);
        return node;
    }

    public static void dataMask(final JSONObject data, JSONObject maskData) {
        if (data == null || maskData == null) {
            return;
        }
        try {
            maskData.forEach((BiConsumer)new BiConsumer<String, Object>(){

                @Override
                public void accept(String s, Object o) {
                    if (data.get((Object)s) == null) {
                        return;
                    }
                    if (o instanceof String) {
                        data.put(s, o);
                    } else if (o instanceof JSONObject) {
                        BankLogTreeEdit.dataMask((JSONObject)data.get((Object)s), (JSONObject)o);
                    } else if (o instanceof JSONArray) {
                        for (Object o1 : (JSONArray)data.get((Object)s)) {
                            BankLogTreeEdit.dataMask((JSONObject)o1, (JSONObject)((JSONArray)o).get(0));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8131\u654f\u5931\u8d25:data={},maskData={}", (Object)data, (Object)maskData);
        }
    }

    public boolean isEncryption() {
        DynamicObject resultObj = BusinessDataServiceHelper.loadSingle((String)"bei_bankagentpay", (String)"isencryption", (QFilter[])new QFilter[]{new QFilter("billno", "=", this.getModel().getValue("sourcebillno"))});
        if (resultObj != null) {
            return resultObj.getBoolean("isencryption");
        }
        return false;
    }

    private JSONArray detailProcess(JSONArray json) {
        if (json.size() <= 1) {
            return json;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String trackBillNo = (String)formShowParameter.getCustomParam("trackBillNo");
        logger.info("\u65e5\u5fd7\u8054\u67e5\u5355\u636e\u7f16\u53f7\uff1a{}", (Object)trackBillNo);
        String targetDetailSeqId = null;
        if (StringUtil.isNotEmpty((String)trackBillNo)) {
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            Iterator iterator = entryEntities.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                if (!trackBillNo.equals(row.getString("e_billnumber"))) {
                    iterator.remove();
                } else {
                    targetDetailSeqId = String.valueOf(row.getLong("e_billid"));
                }
                this.getModel().setDataChanged(false);
            }
        }
        if (targetDetailSeqId == null) {
            return json;
        }
        for (Object obj : json) {
            if (!(obj instanceof JSONObject)) continue;
            try {
                String detailNo = (String)((JSONObject)obj).get((Object)"detailSeqID");
                logger.info("\u5f53\u524d\u652f\u4ed8\u660e\u7ec6\u6d41\u6c34\u53f7\uff1a{}", (Object)detailNo);
                if (!detailNo.equals(targetDetailSeqId)) continue;
                json = new JSONArray(1);
                json.add(0, obj);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u652f\u4ed8\u660e\u7ec6\u6d41\u6c34\u53f7\u5931\u8d25:{}", targetDetailSeqId);
            }
        }
        return json;
    }
}

