/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.bankpay;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.tmc.bei.common.convert.AbstractBillConverter;
import kd.tmc.bei.common.convert.BankPayingUpdateStatPushConverter;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.bei.common.resource.BankPayResource;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankPayingBillList
extends AbstractTmcBillBaseList {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParameter = e.getParameter();
        Object billId = showParameter.getPkId();
        if (showParameter.getStatus() != OperationStatus.ADDNEW && billId != null) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList list;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (("trackdown".equals(opKey) || "trackup".equals(opKey)) && (selectedRows = (list = (BillList)this.getView().getControl("billlistap")).getSelectedRows()).size() != 1) {
            this.getView().showTipNotification(new BankPayResource().getSearchbillOnlyone());
            args.cancel = true;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = source.getOperateKey();
        String successMessage = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BankPayingBillList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        boolean showSuccess = true;
        switch (key) {
            case "bitback": {
                successMessage = new BankPayResource().getBitbackSuccessMsg();
                ((ListView)this.getView()).refresh();
                break;
            }
            case "syncstatus": {
                successMessage = new BankPayResource().getSyncbestatusSuccessMsg();
                ((ListView)this.getView()).refresh();
                break;
            }
            case "commitbe": {
                successMessage = ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"BankPayingBillList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                ((ListView)this.getView()).refresh();
                break;
            }
            case "repay": {
                showSuccess = false;
                break;
            }
            case "updatestatpush": {
                showSuccess = false;
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds.size() <= 0) break;
                BillList billList = (BillList)this.getControl("billlistap");
                PayStateUpdateHelper.showTemplateEditForm((IFormView)this.getView(), (List)successPkIds, (String)billList.getEntityId(), (AbstractBillConverter)new BankPayingUpdateStatPushConverter());
                break;
            }
            default: {
                showSuccess = false;
            }
        }
        if (operationResult != null && (isSuccess = operationResult.isSuccess()) && showSuccess) {
            this.getView().showSuccessNotification(successMessage, Integer.valueOf(2000));
        }
    }
}

