/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.banktrans;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.EntryGridSetRowDataConfig;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayBillUpdateStatEdit
extends AbstractBillPlugIn {
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void initialize() {
        super.initialize();
        EntryGrid grid = (EntryGrid)this.getControl("entrys");
        EntryGridSetRowDataConfig config = new EntryGridSetRowDataConfig();
        config.setAddRowDisabled(false);
        config.setDisabled(true);
        grid.setSetRowDataConfig(config);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.payBillUpdateStatModelBuild();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            if (pkValue != null && pkValue != 0L) {
                DynamicObject dataFromDB = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)this.getModel().getDataEntityType().getName());
                this.getModel().setValue("billstatus", dataFromDB.get("billstatus"));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void payBillUpdateStatModelBuild() {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String targetBillStr = (String)formShowParameter.getCustomParam("targetBillStr");
        String entityName = (String)formShowParameter.getCustomParam("targetBillEntryStr");
        if (EmptyUtil.isNotEmpty((CharSequence)targetBillStr) && EmptyUtil.isNotEmpty((CharSequence)entityName)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject targetBill = (DynamicObject)jser.deserializeFromString(targetBillStr, null);
            model.setValue("sourcetype", targetBill.get("sourcetype"));
            model.setValue("modifier", targetBill.get("modifier_id"));
            model.setValue("modifytime", targetBill.get("modifytime"));
            Object companyId = targetBill.get("company_id");
            String initLoad = this.getPageCache().get("initLoad");
            if (EmptyUtil.isNoEmpty((Object)companyId) && initLoad == null) {
                model.setValue("company", companyId);
            }
            DynamicObjectCollection entrys = (DynamicObjectCollection)targetBill.get("entrys");
            for (DynamicObject entry : entrys) {
                int rowIndex = model.createNewEntryRow("entrys");
                Boolean isEncrypTion = entry.getBoolean("e_isencryption");
                model.setValue("e_sourcebillid", entry.get("e_sourcebillid"), rowIndex);
                model.setValue("e_sourcebillno", entry.get("e_sourcebillno"), rowIndex);
                model.setValue("e_supersrcbillid", entry.get("e_supersrcbillid"), rowIndex);
                model.setValue("e_supersrctype", entry.get("e_supersrctype"), rowIndex);
                model.setValue("e_currency", entry.get("e_currency_id"), rowIndex);
                model.setValue("e_isencryption", (Object)isEncrypTion, rowIndex);
                model.setValue("paystatus", entry.get("paystatus"), rowIndex);
                String payAcct = entry.getString("payacct");
                model.setValue("payacct", (Object)payAcct, rowIndex);
                model.setValue("enc_payacct", (Object)this.getShowEncPayAcct(isEncrypTion, payAcct), rowIndex);
                DynamicObject currency = (DynamicObject)model.getValue("e_currency", rowIndex);
                BigDecimal payAmt = entry.getBigDecimal("payamt").setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                model.setValue("payamt", (Object)payAmt, rowIndex);
                model.setValue("enc_payamt", (Object)this.getShowEncPayAmt(isEncrypTion, currency, payAmt), rowIndex);
                model.setValue("bankreturnmsg", entry.get("bankreturnmsg"), rowIndex);
                model.setValue("sourceentryid", entry.get("sourceentryid"), rowIndex);
                model.setValue("recuser", entry.get("recuser"), rowIndex);
                model.setValue("recbank", entry.get("recbank"), rowIndex);
            }
            this.getPageCache().put("initLoad", "true");
        }
    }

    private String getShowEncPayAmt(Boolean isEncrypTion, DynamicObject currency, BigDecimal payAmt) {
        if (isEncrypTion.booleanValue()) {
            return "**.**";
        }
        return currency.getString("sign") + payAmt;
    }

    private String getShowEncPayAcct(Boolean isEncrypTion, String bankAcctNum) {
        if (isEncrypTion.booleanValue()) {
            if (bankAcctNum.length() > 8) {
                String head = bankAcctNum.substring(0, 4);
                String tail = bankAcctNum.substring(bankAcctNum.length() - 4);
                bankAcctNum = head + "****" + tail;
            }
            return bankAcctNum;
        }
        return bankAcctNum;
    }
}

