/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QueryTransDetailProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CACHEKEY_TASKID = "taskid";

    public void registerListener(EventObject e) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object bankLogId = pkEvent.getRowData().get("banklogid");
            if (pkEvent.getSource() instanceof OperationColumn && EmptyUtil.isEmpty((Object)bankLogId) && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        String taskId = this.getTaskId();
        if (EmptyUtil.isNoEmpty((String)taskId)) {
            this.updateQueryResult(taskId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        if (EmptyUtil.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (progressEvent.getProgress() != 100 || !taskInfo.isTaskEnd()) {
            this.updateQueryResult(taskId);
            progressEvent.setProgress(taskInfo.getProgress());
        } else {
            progressEvent.setProgress(100);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("querybanklog".equals(operateKey)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entry");
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            DynamicObject row = (DynamicObject)entryEntity.get(focusRow);
            long bankLogId = row.getLong("banklogid");
            if (EmptyUtil.isNoEmpty((Long)bankLogId)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("bei_banklog");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setPkId((Object)bankLogId);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void updateQueryResult(String taskId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entry");
        List existRequests = entryEntity.stream().map(r -> r.getLong("requestid")).collect(Collectors.toList());
        DynamicObjectCollection queryRequestRecords = QueryServiceHelper.query((String)"bei_queryrequest", (String)"id,accountbank.fbasedataid.id accountbank,currency.id currency,begindate,enddate,status,exception,publishtime,task.creator.id queryer", (QFilter[])new QFilter[]{new QFilter("task", "=", (Object)Long.valueOf(taskId)).and("id", "not in", existRequests)}, (String)"accountbank,currency,begindate");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)queryRequestRecords)) {
            return;
        }
        List requestIds = queryRequestRecords.stream().map(r -> r.get("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection banklogs = QueryServiceHelper.query((String)"bei_banklog", (String)"id,requestid", (QFilter[])new QFilter[]{new QFilter("requestid", "in", requestIds)});
        Map<Long, List<DynamicObject>> banklogMap = banklogs.stream().collect(Collectors.groupingBy(b -> b.getLong("requestid")));
        Long queryerId = ((DynamicObject)queryRequestRecords.get(0)).getLong("queryer");
        Map account = TmcDataServiceHelper.loadFromCache((Object[])queryRequestRecords.stream().map(r -> r.getLong("accountbank")).distinct().toArray(), (String)"am_accountbank");
        Map currency = TmcDataServiceHelper.loadFromCache((Object[])queryRequestRecords.stream().map(r -> r.getLong("currency")).distinct().toArray(), (String)"bd_currency");
        Map queryer = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{queryerId}, (String)"bos_user");
        HashSet<Long> accountIds = new HashSet<Long>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        ArrayList<Integer> indexs = new ArrayList<Integer>(10);
        for (DynamicObject record : queryRequestRecords) {
            Long accountId = record.getLong("accountbank");
            Long currencyId = record.getLong("currency");
            Long requestId = record.getLong("id");
            String status = record.getString("status");
            Date startDate = record.getDate("begindate");
            Date endDate = record.getDate("enddate");
            int newEntryRow = this.getModel().createNewEntryRow("entry");
            model.setValue("accountbank", account.get(accountId), newEntryRow);
            model.setValue("currency", currency.get(currencyId), newEntryRow);
            model.setValue("begindate", (Object)startDate, newEntryRow);
            model.setValue("enddate", (Object)endDate, newEntryRow);
            model.setValue("requestid", (Object)requestId, newEntryRow);
            model.setValue("queryer", queryer.get(queryerId), newEntryRow);
            model.setValue("querytime", (Object)record.getDate("publishtime"), newEntryRow);
            model.setValue("status", (Object)status, newEntryRow);
            model.setValue("resultinfo", (Object)record.getString("exception"), newEntryRow);
            if (banklogMap.containsKey(requestId)) {
                model.setValue("banklogid", (Object)banklogMap.get(requestId).get(0).getLong("id"), newEntryRow);
            }
            if (!QueryRequestStatusEnum.SUCCESS.getValue().equals(status)) continue;
            accountIds.add(accountId);
            currencyIds.add(currencyId);
            indexs.add(newEntryRow);
        }
        this.getView().updateView("entry");
        this.updateTransDetails(accountIds, currencyIds, indexs);
    }

    private void updateTransDetails(Set<Long> accountIds, Set<Long> currencyIds, List<Integer> indexs) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entry");
        Date beginDate = ((DynamicObject)entry.get(0)).getDate("begindate");
        Date endDate = ((DynamicObject)entry.get(0)).getDate("enddate");
        QFilter qFilter = new QFilter("accountbank", "in", accountIds).and("currency", "in", currencyIds).and("bizdate", ">=", (Object)beginDate).and("bizdate", "<=", (Object)endDate);
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,accountbank.id,currency.id currency,modifytime", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
        for (int index : indexs) {
            DynamicObject row = (DynamicObject)entry.get(index);
            transDetails.stream().filter(b -> row.getDynamicObject("accountbank").getPkValue().equals(b.get("accountbank.id")) && row.getDynamicObject("currency").getPkValue().equals(b.get("currency"))).findFirst().ifPresent(transDetail -> model.setValue("modifytime", (Object)transDetail.getDate("modifytime"), index));
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }
}

