/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TransDetailClaimList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(TransDetailClaimList.class);
    private final String cancelclaim = "tblcancelclaim";
    private final String cancelclaimOp = "cancelclaim";
    private final String claimOp = "claim";
    private final String cancelclaimCallBackID = "cancelclaimCallBackID";

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("creditamount", "!=", (Object)BigDecimal.ZERO));
        ArrayList<String> receredTypeList = new ArrayList<String>();
        receredTypeList.add(ReceredTypeEnum.UNRECERED.getValue());
        receredTypeList.add(ReceredTypeEnum.RECERED.getValue());
        e.getQFilters().add(new QFilter("receredtype", "in", receredTypeList));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tblcancelclaim", (CharSequence)itemKey)) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showErrorNotification(new BeiBizResource().getPleaseSelect());
            } else if (selectedRows.size() > 1) {
                this.getView().showErrorNotification(new BeiBizResource().getTipsClaimBatchCheck());
            } else {
                DynamicObject ClaimDO = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"bei_transdetail_claim");
                String receredtype = ClaimDO.getString("receredtype");
                if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.UNRECERED.getValue())) {
                    this.getView().showErrorNotification(new BeiBizResource().getTipsCancelClaimCheck());
                } else if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.RECERED.getValue())) {
                    String billnum = ClaimDO.getString("number");
                    if (EmptyUtil.isEmpty((String)billnum)) {
                        this.getView().showErrorNotification(new BeiBizResource().getTipsCancelClaimNot());
                    } else {
                        this.getView().showConfirm(new BeiBizResource().getTipsCancelClaim(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("cancelclaimCallBackID", (IFormPlugin)this));
                    }
                }
            }
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"cancelclaimCallBackID", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("cancelclaim");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "claim": {
                this.claim(args);
            }
        }
    }

    private void claim(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showErrorNotification(new BeiBizResource().getTipsClaimBatchCheck());
            args.setCancel(true);
        } else {
            DynamicObject ClaimDO = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"bei_transdetail_claim");
            String receredtype = ClaimDO.getString("receredtype");
            if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.RECERED.getValue())) {
                this.getView().showErrorNotification(new BeiBizResource().getTipsClaimCheck());
                args.setCancel(true);
            } else if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.UNRECERED.getValue())) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(ClaimDO.getPkValue());
                parameter.setFormId("bei_transdetail_claim");
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }
}

