/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.formplugin.detail.TransDetailFileTask;
import kd.tmc.bei.formplugin.elec.ElecStatementFileParseTask;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class TransDetailFileImplEdit
extends AbstractTmcBillEdit
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(TransDetailFileImplEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnupload", "btnok", "btndisimport"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int steps = Integer.parseInt(this.getModel().getValue("stepstatus").toString());
        if (1 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btndisimport", "btnok"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("stepstatus".equals(name)) {
            this.setViewByStep();
        }
    }

    private void setViewByStep() {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        int steps = Integer.parseInt(this.getModel().getValue("stepstatus").toString());
        Map<String, Integer> currentStepMap = Collections.singletonMap("currentStep", steps - 1);
        wizard.setWizardCurrentStep(currentStepMap);
        if (2 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnupload"});
        } else if (3 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btndisimport", "btnok"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnupload".equals(key)) {
            this.beginTask();
        } else if ("btnok".equals(key)) {
            this.importData();
        }
    }

    public void onProgress(ProgressEvent evet) {
        int progress;
        int n = progress = this.getPageCache().get("progress") == null ? 10 : Integer.parseInt(this.getPageCache().get("progress"));
        if (progress < 100) {
            evet.setProgress(progress);
        } else {
            String resultJson = this.getPageCache().get("resultJson");
            evet.setProgress(100);
            this.getModel().setValue("stepstatus", (Object)3);
            List<Integer> successIndex = this.setFileValidateEntity(resultJson);
            Tab tabap = (Tab)this.getControl("tabap");
            tabap.activeTab("tabimport");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(successIndex.stream().mapToInt(i -> i).toArray(), 0);
        }
    }

    private List<Integer> setFileValidateEntity(String json) {
        String entityName = this.getEntityNameFromCustom();
        List dealResults = (List)JSON.parseObject((String)json, List.class);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("requestid", new Object[0]);
        vs.addField("filename", new Object[0]);
        vs.addField("fileurl", new Object[0]);
        vs.addField("status", new Object[0]);
        vs.addField("failurereason", new Object[0]);
        vs.addField("prevalidate", new Object[0]);
        if ("bei_elecstatement".equals(entityName)) {
            vs.addField("accno", new Object[0]);
            vs.addField("currency", new Object[0]);
            vs.addField("period", new Object[0]);
            vs.addField("prestatus", new Object[0]);
            vs.addField("json", new Object[0]);
        }
        int success = 0;
        int failure = 0;
        ArrayList<Integer> successIndex = new ArrayList<Integer>(10);
        for (int i = 0; i < dealResults.size(); ++i) {
            Object dealResult = dealResults.get(i);
            DealResultBean result = (DealResultBean)((JSONObject)dealResult).toJavaObject(DealResultBean.class);
            if ("bei_elecstatement".equals(entityName)) {
                vs.addRow(new Object[]{result.getRequestId(), result.getFileName(), result.getFileURL(), result.getStatus(), result.getFailureReason(), result.getPreValidate(), result.getAccno(), result.getCurrency(), result.getPeriod(), result.getPreStatus(), result.getJson()});
            } else {
                vs.addRow(new Object[]{result.getRequestId(), result.getFileName(), result.getFileURL(), result.getStatus(), result.getFailureReason(), result.getPreValidate()});
            }
            if ("F".equals(result.getStatus())) {
                ++failure;
                continue;
            }
            if (!"S".equals(result.getStatus())) continue;
            ++success;
            successIndex.add(i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        model.setValue("success", (Object)ResManager.loadKDString((String)"%s\u5f20\u8bc6\u522b\u6210\u529f\u3002", (String)"TransDetailFileImplEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{String.valueOf(success)}));
        model.setValue("failure", (Object)ResManager.loadKDString((String)"%s\u5f20\u8bc6\u522b\u5931\u8d25\u3002", (String)"TransDetailFileImplEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{String.valueOf(failure)}));
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().updateView("success");
        this.getView().updateView("failure");
        return successIndex;
    }

    private String getEntityNameFromCustom() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get("entityName");
    }

    private void beginTask() {
        Runnable task;
        AttachmentPanel control = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = control.getAttachmentData();
        String dataJson = JSON.toJSONString((Object)attachmentData);
        if (attachmentData.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ElecImageUploadEdit_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        this.start();
        this.getPageCache().put("total", String.valueOf(attachmentData.size()));
        String entityName = this.getEntityNameFromCustom();
        logger.info("\u8bc6\u522b\u529f\u80fd\u5bf9\u5e94\u7684\u5b9e\u4f53\u540d\u79f0\uff1a" + entityName);
        if ("bei_elecstatement".equals(entityName)) {
            task = new ElecStatementFileParseTask(this.getView().getPageId(), dataJson);
            ThreadPools.executeOnceIncludeRequestContext((String)"ElecStatementFileParseTask", (Runnable)task);
        } else {
            task = new TransDetailFileTask(this.getView().getPageId(), dataJson);
            ThreadPools.executeOnceIncludeRequestContext((String)"detailtaks", (Runnable)task);
        }
        this.getModel().setValue("stepstatus", (Object)2);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab("tabrecongnize");
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"ElecImageUploadEdit_12", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("progressBar", "true");
    }

    private void importData() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (null == rows || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u540e\u64cd\u4f5c\u3002", (String)"TransDetailFileImplEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List imports = Arrays.stream(rows).boxed().map(arg_0 -> entryEntity.get(arg_0)).filter(t -> "S".equals(t.getString("status"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(imports)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bc6\u522b\u6210\u529f\u7684\u6587\u4ef6\uff0c\u65e0\u9700\u5bfc\u5165\u3002", (String)"TransDetailFileImplEdit_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = this.getEntityNameFromCustom();
        if ("bei_elecstatement".equals(entityName)) {
            List preStatus = Arrays.stream(rows).boxed().map(arg_0 -> entryEntity.get(arg_0)).filter(t -> "F".equals(t.getString("prestatus"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(preStatus)) {
                String fileName = preStatus.stream().map(s -> s.getString("filename")).collect(Collectors.joining(";"));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"TransDetailFileImplEdit_4", (String)"tmc-bei-formplugin", (Object[])new Object[]{fileName}));
                return;
            }
        }
        List list = imports.stream().map(t -> {
            HashMap<String, String> map = new HashMap<String, String>(6);
            map.put("requestid", t.getString("requestid"));
            map.put("filename", t.getString("filename"));
            map.put("fileurl", t.getString("fileurl"));
            if ("bei_elecstatement".equals(entityName)) {
                map.put("json", t.getString("json"));
            }
            return map;
        }).collect(Collectors.toList());
        String data = SerializationUtils.toJsonString(list);
        logger.info("TransDetailFileImplEdit data : {}", (Object)data);
        Map<String, String> returnMap = Collections.singletonMap("data", data);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("viewdetail".equals(operateKey)) {
            this.showDetailForm();
        }
    }

    private void showDetailForm() {
        IDataModel model = this.getModel();
        DynamicObject row = model.getEntryRowEntity("entryentity", model.getEntryCurrentRowIndex("entryentity"));
        String file = row.getString("requestid");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bei_transdetail_filedata");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("file", (Object)file);
        this.getView().showForm(showParameter);
    }
}

