/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.helper.SyncQueryBankAccountHelper;
import kd.tmc.bei.common.init.SynTransDetailDataHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TransDetailList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(TransDetailList.class);
    private static final List<String> OPERATORS = new ArrayList<String>();

    protected boolean disableDoubleClick() {
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "bar_online": {
                this.OnlineQueryClick();
                break;
            }
            case "update": {
                try {
                    SynTransDetailDataHelper.synBillnoData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                billList.refresh();
                break;
            }
            case "returndate": {
                try {
                    SynTransDetailDataHelper.returnBillnoData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                billList.refresh();
                break;
            }
            case "synctrans": {
                this.syncTrans();
                break;
            }
        }
    }

    private void syncTrans() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_synctrans");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        ControlFilters controlFilters = this.getControlFilters();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean updateFlag = false;
        if (this.getPageCache().get("beforeSelectCompany") == null) {
            List companyFilterList = controlFilters.getFilter("company.id");
            String companyId = JSON.toJSONString((Object)companyFilterList);
            this.getPageCache().put("beforeSelectCompany", companyId);
        } else {
            String companyId = this.getPageCache().get("beforeSelectCompany");
            List beforeCompanyList = JSON.parseArray((String)companyId, Object.class);
            List currentCompanyList = controlFilters.getFilter("company.id");
            List collect = currentCompanyList.stream().filter(e -> !beforeCompanyList.contains(e)).collect(Collectors.toList());
            boolean flag = collect.stream().allMatch(""::equals);
            if (!EmptyUtil.isEmpty(collect) && !flag) {
                updateFlag = true;
            }
        }
        SyncQueryBankAccountHelper.SyncAccount((ControlFilters)controlFilters, (FormShowParameter)showForm, (String)appId, (String)"bei_transdetail", (boolean)updateFlag);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "synctrans"));
        this.getView().showForm(showForm);
    }

    private void OnlineQueryClick() {
        List idList = this.getSelectedIdList();
        if (idList != null && idList.size() > 0) {
            this.showOnLineQueryFrm(idList);
        }
    }

    private void showOnLineQueryFrm(List<Long> idList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bei_onlinequery");
        parameter.getCustomParams().put("idList", idList);
        parameter.getCustomParams().put("query", "detail");
        this.getView().showForm(parameter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = listShowParameter.isLookUp();
        if (lookUp) {
            return;
        }
        if (Arrays.asList("cas_multitag", "am_dormancyrpt").contains(listShowParameter.getParentFormId())) {
            FilterColumn comFilColumn = args.getFilterColumn("company.name");
            FilterColumn bizFilColumn = args.getFilterColumn("bizdate");
            FilterColumn finTypeCplumn = args.getFilterColumn("financialtype.name");
            comFilColumn.setDefaultValue(null);
            bizFilColumn.setDefaultValue(null);
            finTypeCplumn.setDefaultValue(null);
        }
        AccountBankHelper.filterContainerInitForAccountManagerTransfer((ListShowParameter)listShowParameter, (List)args.getCommonFilterColumns(), (IPageCache)this.getPageCache());
        String bizDate = (String)listShowParameter.getCustomParam("bizdate");
        if (bizDate != null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                String fieldName = filterColumn.getFieldName();
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!"bizdate".equals(fieldName)) continue;
                commonFilter.setDefaultValues(new Object[]{bizDate, bizDate});
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String source = (String)listShowParameter.getCustomParam("source");
        if ("bei_bankbalance".equals(source)) {
            String accountBankId = (String)listShowParameter.getCustomParam("accountbank.id");
            String companyId = (String)listShowParameter.getCustomParam("company.id");
            String bankId = (String)listShowParameter.getCustomParam("bank.id");
            if (accountBankId != null) {
                qFilters.add(new QFilter("accountbank", "=", (Object)Long.valueOf(accountBankId)));
            }
            if (companyId != null) {
                qFilters.add(new QFilter("company", "=", (Object)Long.valueOf(companyId)));
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                orgIds.add(Long.valueOf(companyId));
                e.setMainOrgQFilter(new QFilter("company", "in", orgIds));
            }
            if (bankId != null) {
                qFilters.add(new QFilter("bank", "=", (Object)Long.valueOf(bankId)));
            }
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String property = qFilter.getProperty();
                if (!"accountbank.bank.finorgtype.id".equals(property)) continue;
                iterator.remove();
                break;
            }
        }
        logger.info("TransDetailList: " + qFilters);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn source = (CommonFilterColumn)args.getSource();
        if (StringUtils.equals((CharSequence)source.getFieldName(), (CharSequence)"accountbank.bank.name")) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            qFilterList.add(new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue()));
            args.getQFilters().addAll(qFilterList);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (StringUtils.equals((CharSequence)"accountbank.bank.id", (CharSequence)args.getFieldName()) || StringUtils.equals((CharSequence)"accountbank.bank.name", (CharSequence)args.getFieldName())) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            qFilterList.add(new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue()));
            args.setQfilters(qFilterList);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        boolean executeResult = false;
        if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
            executeResult = true;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())};
            DynamicObject[] transdetails = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,istransup,istransdown,isbankwithholding,receredtype", (QFilter[])qFilters);
            switch (operateKey) {
                case "receipt": {
                    ArrayList<String> pkList = new ArrayList<String>(10);
                    String receiptID = args.getOperationResult().getMessage();
                    pkList.addAll(Arrays.asList(receiptID.split(";")));
                    ViewReceiptService service = new ViewReceiptService();
                    service.openReceiptById(this.getView(), pkList.toArray());
                    break;
                }
                case "transup": {
                    for (DynamicObject transdetail : transdetails) {
                        transdetail.set("istransup", (Object)"1");
                    }
                    break;
                }
                case "canceltransup": {
                    for (DynamicObject transdetail : transdetails) {
                        transdetail.set("istransup", (Object)"0");
                    }
                    break;
                }
                case "transdown": {
                    for (DynamicObject transdetail : transdetails) {
                        transdetail.set("istransdown", (Object)"1");
                    }
                    break;
                }
                case "canceltransdown": {
                    for (DynamicObject transdetail : transdetails) {
                        transdetail.set("istransdown", (Object)"0");
                    }
                    break;
                }
                case "bankwithholding": {
                    List successPkIds2 = operationResult.getSuccessPkIds();
                    this.showForm("bei_ackbankhold", "bei_ackbankhold", successPkIds2, Boolean.TRUE);
                    break;
                }
                case "cancelbankwithholding": {
                    for (DynamicObject transdetail : transdetails) {
                        transdetail.set("isbankwithholding", (Object)"0");
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u786e\u8ba4\u4ee3\u6263\u6210\u529f\u3002", (String)"TransDetailList_11", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "recered": {
                    this.receredOp(operateKey, transdetails);
                    break;
                }
                case "cancelrecered": {
                    this.receredOp(operateKey, transdetails);
                    break;
                }
            }
            TmcDataServiceHelper.save((DynamicObject[])transdetails);
            if (Arrays.asList("transup", "canceltransup", "transdown", "canceltransdown").contains(operateKey)) {
                this.getView().invokeOperation("refresh");
            }
        } else if (!EmptyUtil.isEmpty((Object)operationResult) && ("recered".equals(operateKey) || "cancelrecered".equals(operateKey))) {
            List successPkIds3 = operationResult.getSuccessPkIds();
            if (successPkIds3.size() > 0) {
                DynamicObject[] transdetails = TmcDataServiceHelper.load((String)"bei_transdetail", (String)"id,receredtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds3)});
                this.receredOp(operateKey, transdetails);
                TmcDataServiceHelper.save((DynamicObject[])transdetails);
                this.getView().invokeOperation("refresh");
            }
        } else if (!EmptyUtil.isEmpty((Object)operationResult) && "bankwithholding".equals(operateKey)) {
            List successPkIds4 = operationResult.getSuccessPkIds();
            if (successPkIds4.size() > 0) {
                this.showForm("bei_ackbankhold", "bei_ackbankhold", successPkIds4, Boolean.FALSE);
            }
        } else if (!EmptyUtil.isEmpty((Object)operationResult) && "cancelbankwithholding".equals(operateKey) && (successPkIds = operationResult.getSuccessPkIds()).size() > 0) {
            DynamicObject[] transdetails = TmcDataServiceHelper.load((String)"bei_transdetail", (String)"id,isbankwithholding", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)});
            this.ackHoldingOp(operateKey, transdetails);
            TmcDataServiceHelper.save((DynamicObject[])transdetails);
            this.getView().invokeOperation("refresh");
        }
        this.afterExecuteTransDownUp(args, executeResult);
    }

    private void afterExecuteTransDownUp(AfterDoOperationEventArgs args, Boolean executeResult) {
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (executeResult.booleanValue() || EmptyUtil.isEmpty((Object)operationResult) || !OPERATORS.contains(operateKey)) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds.size() <= 0) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)successPkIds)};
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,istransup,istransdown,isbankwithholding,receredtype", (QFilter[])qFilters);
        if (transDetails.length <= 0) {
            return;
        }
        boolean isTransDown = false;
        if (operateKey.equals("transdown") || operateKey.equals("canceltransdown")) {
            isTransDown = true;
        }
        String status = "1";
        if (operateKey.equals("canceltransup") || operateKey.equals("canceltransdown")) {
            status = "0";
        }
        for (DynamicObject transDetail : transDetails) {
            if (isTransDown) {
                transDetail.set("istransdown", (Object)status);
                continue;
            }
            transDetail.set("istransup", (Object)status);
        }
        TmcDataServiceHelper.save((DynamicObject[])transDetails);
        this.getView().invokeOperation("refresh");
    }

    private void receredOp(String opName, DynamicObject[] transdetails) {
        for (DynamicObject transdetail : transdetails) {
            if ("recered".equals(opName)) {
                if (!"0".equals(transdetail.getString("receredtype"))) continue;
                transdetail.set("receredtype", (Object)"3");
                continue;
            }
            if (!"cancelrecered".equals(opName) || !"3".equals(transdetail.getString("receredtype"))) continue;
            transdetail.set("receredtype", (Object)"0");
        }
    }

    private void ackHoldingOp(String opName, DynamicObject[] transdetails) {
        for (DynamicObject transdetail : transdetails) {
            if ("bankwithholding".equals(opName)) {
                if (transdetail.getBoolean("isbankwithholding")) continue;
                transdetail.set("isbankwithholding", (Object)"1");
                continue;
            }
            if (!"cancelbankwithholding".equals(opName) || !transdetail.getBoolean("isbankwithholding")) continue;
            transdetail.set("isbankwithholding", (Object)"0");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        String userId = RequestContext.get().getUserId();
        int checkPermission = 0;
        switch (opKey) {
            case "tblgenrecbill": {
                checkPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(userId), (Long)RequestContext.get().getOrgId(), (String)"cas", (String)"bei_betransdetail_imp", (String)"06V79L92HCIC");
                if (checkPermission == 1) break;
                args.setCancel(true);
                String opName = ResManager.loadKDString((String)"\u751f\u6210\u6536\u6b3e\u5355", (String)"TransDetailList_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                this.tipMessage(opName);
                break;
            }
            case "tblgenpaybill": {
                checkPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(userId), (Long)RequestContext.get().getOrgId(), (String)"cas", (String)"bei_betransdetail_imp", (String)"06V7DKO=Y6M7");
                if (checkPermission == 1) break;
                args.setCancel(true);
                String opName = ResManager.loadKDString((String)"\u751f\u6210\u4ed8\u6b3e\u5355", (String)"TransDetailList_8", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                this.tipMessage(opName);
                break;
            }
            case "bankwithholding": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                if (!this.IsHasIntoAcc(selectedRows).booleanValue()) break;
                args.setCancel(true);
            }
        }
    }

    private Boolean IsHasIntoAcc(ListSelectedRowCollection selectedRows) {
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            return Boolean.TRUE;
        }
        ArrayList<Integer> rowKeyList = new ArrayList<Integer>(10);
        ArrayList<Integer> detailIdList = new ArrayList<Integer>(10);
        for (ListSelectedRow row : selectedRows) {
            int rowKey = row.getRowKey() + 1;
            Object primaryKeyValue = row.getPrimaryKeyValue();
            DynamicObject transdetail = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bei_transdetail_cas");
            if (EmptyUtil.isEmpty((DynamicObject)transdetail)) continue;
            boolean isbankwithholding = (Boolean)transdetail.get("isbankwithholding");
            boolean istransdown = (Boolean)transdetail.get("istransdown");
            BigDecimal debitamount = (BigDecimal)transdetail.get("debitamount");
            if (isbankwithholding || istransdown || debitamount.compareTo(BigDecimal.ZERO) == 0) {
                rowKeyList.add(rowKey);
            }
            if (!transdetail.get("receredtype").equals("3") && debitamount.compareTo(BigDecimal.ZERO) != 0) continue;
            detailIdList.add(rowKey);
        }
        if (rowKeyList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String no = ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"TransDetailList_12", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
            sb.append(no);
            sb.append(rowKeyList);
            sb.append(ResManager.loadKDString((String)"\u94f6\u884c\u4ee3\u6263\u4e3a\u5426\u4e14\u94f6\u884c\u4e0b\u62e8\u4e3a\u5426\u4e14\u4ed8\u6b3e\u91d1\u989d\u4e0d\u7b49\u4e8e0\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u4ee3\u6263\u786e\u8ba4\u3002", (String)"TransDetailList_13", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(sb.toString());
            return Boolean.TRUE;
        }
        this.getPageCache().put("detailIdList", ((Object)detailIdList).toString());
        return Boolean.FALSE;
    }

    public void showForm(String formId, String callBackBtn, List<Object> successPkIds, boolean isAllSuccess) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCustomParam("successPkIds", successPkIds);
        fsp.setCustomParam("isAllSuccess", (Object)isAllSuccess);
        fsp.setFormId(formId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        HashMap returnData;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"bei_ackbankhold") && !EmptyUtil.isEmpty((Object)(returnData = (HashMap)args.getReturnData()))) {
            Boolean istopay = (Boolean)returnData.get("istopay");
            Boolean isAllSuccess = (Boolean)returnData.get("isAllSuccess");
            List successPkIds = (List)returnData.get("successPkIds");
            if (istopay.booleanValue()) {
                String detailIdList = this.getPageCache().get("detailIdList");
                String row = detailIdList.substring(1, detailIdList.length() - 1);
                if (StringUtils.isNotEmpty((CharSequence)row) && !row.equals("")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u201c%s\u201d\u4e3a\u201c\u5df2\u786e\u8ba4\u201d\u72b6\u6001\uff0c\u53ea\u6709\u201c\u5f85\u786e\u8ba4\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"TransDetailList_16", (String)"tmc-bei-formplugin", (Object[])new Object[0]), detailIdList));
                    return;
                }
                Object[] successIds = successPkIds.toArray();
                OperateOption operateOption = OperateOption.create();
                String returnDataStr = SerializationUtils.toJsonString((Object)returnData);
                operateOption.setVariableValue("returnDataByOpHolding", returnDataStr);
                OperationResult operationResult = null;
                try {
                    operationResult = TmcOperateServiceHelper.execOperate((String)"genpaybill", (String)"bei_transdetail_cas", (Object[])successIds, (OperateOption)operateOption);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
                if (operationResult != null && operationResult.isSuccess()) {
                    List successGenPayPkIds = operationResult.getSuccessPkIds();
                    this.changeRecordStatus(successGenPayPkIds, istopay, isAllSuccess);
                }
            } else {
                this.changeRecordStatus(successPkIds, istopay, isAllSuccess);
            }
        }
    }

    private void changeRecordStatus(List<Object> successPkIds, boolean istopay, boolean isAllSuccess) {
        if (successPkIds.size() > 0) {
            DynamicObject[] transdetails = TmcDataServiceHelper.load((String)"bei_transdetail", (String)"id,isbankwithholding,receredtype", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)});
            this.ackHoldingOp("bankwithholding", transdetails);
            if (istopay) {
                this.receredOp("recered", transdetails);
            }
            TmcDataServiceHelper.save((DynamicObject[])transdetails);
            if (isAllSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ee3\u6263\u6210\u529f\u3002", (String)"TransDetailList_10", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void tipMessage(String opName) {
        String msg1 = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709%s", (String)"TransDetailList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]), "[");
        String displayName = this.getView().getFormShowParameter().getCaption();
        String msg2 = String.format(ResManager.loadKDString((String)"%1$s\u7684\u64cd\u4f5c%2$s", (String)"TransDetailList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]), "]", "[");
        String controlName = ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"TransDetailList_6", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        String msg3 = String.format(ResManager.loadKDString((String)"%1$s\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d%2$s\u3002", (String)"TransDetailList_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]), "]", "[") + controlName;
        String msg4 = String.format(ResManager.loadKDString((String)"%s\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"TransDetailList_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]), "]");
        String msgString = String.format("%s%s%s%s%s%s%s", msg1, displayName, msg2, opName, msg3, opName, msg4);
        this.getView().showTipNotification(msgString);
    }

    static {
        OPERATORS.add("transdown");
        OPERATORS.add("transup");
        OPERATORS.add("canceltransdown");
        OPERATORS.add("canceltransup");
    }
}

