/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailRenoteList
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(TransDetailRenoteList.class);
    private static final String OP_TO_RENOTE = "torenote";
    private static final String RENOTE_CALL_BACK = "RENOTE_CALL_BACK";
    private static final List<String> MARK_OP = Arrays.asList("markrenote", "cancelmarkrenote");
    private Long markLogId;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        String operateKey = operate.getOperateKey();
        if (OP_TO_RENOTE.equals(operateKey)) {
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u7b14\u9000\u7968\u6d41\u6c34\u8fdb\u884c\u9000\u7968\u5904\u7406\u3002", (String)"TransDetailRenoteList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (MARK_OP.contains(operateKey) && !selectedRows.isEmpty()) {
            Object id = selectedRows.get(0).getPrimaryKeyValue();
            try {
                DynamicObject transDetailBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getModel().getDataEntityType().getName(), (String)"id,billno,company,currency");
                this.markLogId = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"RefundService", (String)"insertMarkLog", (Object[])new Object[]{transDetailBill, operateKey});
            }
            catch (Exception e) {
                logger.error("insert mark op log error", (Throwable)e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && opResult.isSuccess() && OP_TO_RENOTE.equals(operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cas_detail_renote");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("detailId", this.getSelectId());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RENOTE_CALL_BACK));
            this.getView().showForm(parameter);
        }
        if (MARK_OP.contains(operateKey)) {
            if (opResult != null && opResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
            if (EmptyUtil.isNoEmpty((Long)this.markLogId)) {
                try {
                    this.markLogId = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"RefundService", (String)"updateLogResult", (Object[])new Object[]{this.markLogId, opResult});
                }
                catch (Exception e) {
                    logger.error("update mark op log error", (Throwable)e);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (RENOTE_CALL_BACK.equals(event.getActionId()) && "success".equals(event.getReturnData())) {
            String successMsg = ResManager.loadKDString((String)"\u9000\u7968\u5904\u7406\u6210\u529f\u3002", (String)"TransDetailRenoteList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(successMsg);
            this.getView().invokeOperation("refresh");
        }
    }

    private Object getSelectId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ListSelectedRow selectedRow = selectedRows.get(0);
        return selectedRow.getPrimaryKeyValue();
    }
}

